/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheMapService;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.DefaultKeyCachedReference;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.cache.MemoryCacheMapServiceMBean;
import jp.ossc.nimbus.service.cache.PersistableCache;

public class MemoryCacheMapService
extends AbstractCacheMapService
implements Serializable,
PersistableCache,
MemoryCacheMapServiceMBean {
    private static final long serialVersionUID = 1595164377209904186L;
    private ServiceName persistCacheMapServiceName;
    private boolean isLoadOnStart = true;
    private boolean isSaveOnStop = true;

    @Override
    public void setPersistCacheMapServiceName(ServiceName name) {
        this.persistCacheMapServiceName = name;
    }

    @Override
    public ServiceName getPersistCacheMapServiceName() {
        return this.persistCacheMapServiceName;
    }

    @Override
    public void setLoadOnStart(boolean isLoad) {
        this.isLoadOnStart = isLoad;
    }

    @Override
    public boolean isLoadOnStart() {
        return this.isLoadOnStart;
    }

    @Override
    public void setSaveOnStop(boolean isSave) {
        this.isSaveOnStop = isSave;
    }

    @Override
    public boolean isSaveOnStop() {
        return this.isSaveOnStop;
    }

    @Override
    public void startService() throws Exception {
        if (this.isLoadOnStart) {
            this.load();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.isSaveOnStop) {
            this.save();
        }
    }

    @Override
    protected KeyCachedReference createKeyCachedReference(Object key, Object obj) {
        return new DefaultKeyCachedReference(key, obj);
    }

    @Override
    public synchronized void load() throws Exception {
        if (this.persistCacheMapServiceName != null) {
            CacheMap persistCacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.persistCacheMapServiceName);
            this.clear();
            this.putAll((Map)persistCacheMap);
        }
    }

    @Override
    public synchronized void save() throws Exception {
        if (this.persistCacheMapServiceName != null) {
            CacheMap persistCacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.persistCacheMapServiceName);
            persistCacheMap.clear();
            persistCacheMap.putAll((Map)this);
        }
    }
}

