/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheService;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.FileCacheServiceMBean;
import jp.ossc.nimbus.service.cache.FileCachedReference;
import jp.ossc.nimbus.service.io.Externalizer;

public class FileCacheService
extends AbstractCacheService
implements Serializable,
FileCacheServiceMBean {
    private static final long serialVersionUID = 4587745705534545655L;
    private static final String JVM_TMP_DIR = "java.io.tmpdir";
    private String outputDirectory;
    private File directory;
    private String prefix;
    private String suffix = ".obj";
    private boolean isDeleteOnExitWithJVM = true;
    private boolean isLoadOnStart;
    private boolean isCheckFileOnLoad;
    private boolean isDeleteOnCheckFileError;
    private ServiceName externalizerServiceName;
    private Externalizer externalizer;

    @Override
    public void setOutputDirectory(String path) throws IllegalArgumentException {
        if (path != null) {
            File dir = new File(path);
            if (dir.exists() ? !dir.isDirectory() : !dir.mkdirs()) {
                throw new IllegalArgumentException("Path is illegal : " + path);
            }
            this.directory = dir;
            this.outputDirectory = path;
        }
    }

    @Override
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void setOutputPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getOutputPrefix() {
        return this.prefix;
    }

    @Override
    public void setOutputSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public String getOutputSuffix() {
        return this.suffix;
    }

    @Override
    public void setLoadOnStart(boolean isLoad) {
        this.isLoadOnStart = isLoad;
    }

    @Override
    public boolean isLoadOnStart() {
        return this.isLoadOnStart;
    }

    @Override
    public void setCheckFileOnLoad(boolean isCheck) {
        this.isCheckFileOnLoad = isCheck;
    }

    @Override
    public boolean isCheckFileOnLoad() {
        return this.isCheckFileOnLoad;
    }

    @Override
    public void setDeleteOnCheckFileError(boolean isDelete) {
        this.isDeleteOnCheckFileError = isDelete;
    }

    @Override
    public boolean isDeleteOnCheckFileError() {
        return this.isDeleteOnCheckFileError;
    }

    @Override
    public void setExternalizerServiceName(ServiceName name) {
        this.externalizerServiceName = name;
    }

    @Override
    public ServiceName getExternalizerServiceName() {
        return this.externalizerServiceName;
    }

    public void setExternalizer(Externalizer ext) {
        this.externalizer = ext;
    }

    public Externalizer getExternalizer() {
        return this.externalizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createFile(Object obj) throws IOException {
        File file = null;
        String prefix = this.prefix;
        if (prefix == null) {
            if (obj != null) {
                Object object = obj;
                synchronized (object) {
                    prefix = obj.toString();
                }
            } else {
                prefix = "null";
            }
        }
        file = this.directory != null ? File.createTempFile(this.createPrefix(prefix), this.suffix, this.directory) : File.createTempFile(this.createPrefix(prefix), this.suffix);
        if (this.isDeleteOnExitWithJVM()) {
            file.deleteOnExit();
        }
        return file;
    }

    private String createPrefix(String prefix) {
        if (prefix.length() > 2) {
            return prefix;
        }
        StringBuffer buf = new StringBuffer(prefix);
        int max = 3 - prefix.length();
        for (int i = 0; i < max; ++i) {
            buf.append('_');
        }
        return buf.toString();
    }

    @Override
    public void setDeleteOnExitWithJVM(boolean isDeleteOnExit) {
        this.isDeleteOnExitWithJVM = isDeleteOnExit;
    }

    @Override
    public boolean isDeleteOnExitWithJVM() {
        return this.isDeleteOnExitWithJVM;
    }

    @Override
    public void startService() throws Exception {
        if (this.externalizerServiceName != null) {
            this.externalizer = (Externalizer)ServiceManagerFactory.getServiceObject(this.externalizerServiceName);
        }
        if (this.isLoadOnStart()) {
            this.load();
        }
    }

    protected void load() throws Exception {
        File tmpFile;
        String tmpFileStr;
        File dir = this.directory;
        if (dir == null && (tmpFileStr = System.getProperty(JVM_TMP_DIR)) != null && (tmpFile = new File(tmpFileStr)).exists() && tmpFile.isDirectory()) {
            dir = tmpFile;
        }
        if (dir != null) {
            File[] list = dir.listFiles(new FilenameFilter(){
                private final String pre;
                {
                    this.pre = FileCacheService.this.prefix != null ? FileCacheService.this.createPrefix(FileCacheService.this.prefix) : null;
                }

                @Override
                public boolean accept(File dir, String name) {
                    if (this.pre == null) {
                        return name.endsWith(FileCacheService.this.suffix);
                    }
                    return name.startsWith(this.pre) && name.endsWith(FileCacheService.this.suffix);
                }
            });
            for (int i = 0; i < list.length; ++i) {
                if (this.containsFile(list[i])) continue;
                FileCachedReference ref = new FileCachedReference(list[i], this.externalizer);
                if (this.isCheckFileOnLoad) {
                    try {
                        ref.deserializeObject();
                        this.add(ref);
                    }
                    catch (IOException e) {
                        if (!this.isDeleteOnCheckFileError) continue;
                        list[i].delete();
                    }
                    catch (ClassNotFoundException e) {
                        if (!this.isDeleteOnCheckFileError) continue;
                        list[i].delete();
                    }
                    continue;
                }
                this.add(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsFile(File file) {
        if (this.references == null || file == null) {
            return false;
        }
        boolean result = false;
        Set set = this.references;
        synchronized (set) {
            for (FileCachedReference ref : this.references) {
                if (!file.equals(ref.getFile())) continue;
                return true;
            }
        }
        return result;
    }

    @Override
    protected CachedReference createCachedReference(Object obj) {
        File file = null;
        try {
            file = this.createFile(obj);
            return new FileCachedReference(file, obj, this.externalizer);
        }
        catch (IOException e) {
            if (file != null) {
                file.delete();
            }
            return null;
        }
    }
}

