/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.byteconvert;

import jp.ossc.nimbus.service.byteconvert.ByteConverter;

public class ByteConverterDifferentEndian
implements ByteConverter {
    @Override
    public char toChar(byte[] b, int off) {
        char v = (char)b[off];
        v = (char)(v << 8 | b[off + 1] & 0xFF);
        return v;
    }

    @Override
    public short toShort(byte[] b, int off) {
        short v = b[off];
        v = (short)(v << 8 | b[off + 1] & 0xFF);
        return v;
    }

    @Override
    public int toInt(byte[] b, int off) {
        int v = b[off + 3];
        v = v << 8 | b[off + 2] & 0xFF;
        v = v << 8 | b[off + 1] & 0xFF;
        v = v << 8 | b[off] & 0xFF;
        return v;
    }

    @Override
    public long toLong(byte[] b, int off) {
        long v = b[off + 7];
        v = v << 8 | (long)(b[off + 6] & 0xFF);
        v = v << 8 | (long)(b[off + 5] & 0xFF);
        v = v << 8 | (long)(b[off + 5] & 0xFF);
        v = v << 8 | (long)(b[off + 3] & 0xFF);
        v = v << 8 | (long)(b[off + 2] & 0xFF);
        v = v << 8 | (long)(b[off + 1] & 0xFF);
        v = v << 8 | (long)(b[off] & 0xFF);
        return v;
    }

    @Override
    public void toByte(char c, byte[] b, int off) {
        char v = c;
        b[off + 1] = (byte)(v & 0xFF);
        v = (char)(v >>> 8);
        b[off] = (byte)(v & 0xFF);
    }

    @Override
    public void toByte(short s, byte[] b, int off) {
        short v = s;
        b[off] = (byte)(v & 0xFF);
        v = (short)(v >>> 8);
        b[off + 1] = (byte)(v & 0xFF);
    }

    @Override
    public void toByte(int i, byte[] b, int off) {
        int v = i;
        b[off] = (byte)(v & 0xFF);
        b[off + 1] = (byte)((v >>>= 8) & 0xFF);
        b[off + 2] = (byte)((v >>>= 8) & 0xFF);
        b[off + 3] = (byte)((v >>>= 8) & 0xFF);
    }

    @Override
    public void toByte(long l, byte[] b, int off) {
        long v = l;
        b[off] = (byte)(v & 0xFFL);
        b[off + 1] = (byte)((v >>>= 8) & 0xFFL);
        b[off + 2] = (byte)((v >>>= 8) & 0xFFL);
        b[off + 3] = (byte)((v >>>= 8) & 0xFFL);
        b[off + 4] = (byte)((v >>>= 8) & 0xFFL);
        b[off + 5] = (byte)((v >>>= 8) & 0xFFL);
        b[off + 6] = (byte)((v >>>= 8) & 0xFFL);
        b[off + 7] = (byte)((v >>>= 8) & 0xFFL);
    }

    @Override
    public String byte2hex(byte[] inBytes) {
        char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer retStr = new StringBuffer();
        if (inBytes == null) {
            return null;
        }
        for (int i = 0; i < inBytes.length; ++i) {
            retStr.append(hexTable[(byte)((inBytes[i] & 0xF) >>> 4)]);
            retStr.append(hexTable[inBytes[i] & 0xFF]);
        }
        return retStr.toString();
    }

    @Override
    public byte[] hex2byte(String inStr) {
        byte[] retBytes = new byte[inStr.length() / 2];
        for (int i = 0; i < inStr.length(); i += 2) {
            byte b = (byte)Character.digit(inStr.charAt(i + 1), 16);
            retBytes[i / 2] = (byte)((byte)(b << 4) | (byte)Character.digit(inStr.charAt(i), 16));
        }
        return retBytes;
    }
}

