/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpServletRequestCheckException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpServletRequestCheckInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;

public class HttpServletRequestCheckInterceptorService
extends ServletFilterInterceptorService
implements HttpServletRequestCheckInterceptorServiceMBean {
    private static final long serialVersionUID = -8791823240259229953L;
    protected int maxContentLength = -1;
    protected int minContentLength = -1;
    protected boolean isAllowNullContentType = true;
    protected String[] validContentTypes;
    protected Set validContentTypeValueSet;
    protected String[] invalidContentTypes;
    protected ContentType[] invalidContentTypeValues;
    protected boolean isAllowNullCharacterEncoding = true;
    protected String[] validCharacterEncodings;
    protected String[] invalidCharacterEncodings;
    protected boolean isAllowNullLocale = true;
    protected String[] validLocales;
    protected Pattern[] validLocalePatterns;
    protected String[] validProtocols;
    protected String[] validRemoteAddrs;
    protected Pattern[] validRemoteAddrPatterns;
    protected String[] validRemoteHosts;
    protected Pattern[] validRemoteHostPatterns;
    protected int[] validRemotePorts;
    protected String[] validSchemata;
    protected String[] validServerNames;
    protected Pattern[] validServerNamePatterns;
    protected String[] validMethods;
    protected String[] invalidMethods;
    protected Properties headerEquals;
    protected Map headerEqualsMap;
    protected int errorStatus = 400;
    protected boolean isThrowOnError;

    @Override
    public void setMaxContentLength(int max) {
        this.maxContentLength = max;
    }

    @Override
    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    @Override
    public void setMinContentLength(int min) {
        this.minContentLength = min;
    }

    @Override
    public int getMinContentLength() {
        return this.minContentLength;
    }

    @Override
    public void setAllowNullContentType(boolean isAllow) {
        this.isAllowNullContentType = isAllow;
    }

    @Override
    public boolean isAllowNullContentType() {
        return this.isAllowNullContentType;
    }

    @Override
    public void setValidContentTypes(String[] types) {
        this.validContentTypes = types;
    }

    @Override
    public String[] getValidContentTypes() {
        return this.validContentTypes;
    }

    @Override
    public void setInvalidContentTypes(String[] types) {
        this.invalidContentTypes = types;
    }

    @Override
    public String[] getInvalidContentTypes() {
        return this.invalidContentTypes;
    }

    @Override
    public void setAllowNullCharacterEncoding(boolean isAllow) {
        this.isAllowNullCharacterEncoding = isAllow;
    }

    @Override
    public boolean isAllowNullCharacterEncoding() {
        return this.isAllowNullCharacterEncoding;
    }

    @Override
    public void setValidCharacterEncodings(String[] encodings) {
        this.validCharacterEncodings = encodings;
    }

    @Override
    public String[] getValidCharacterEncodings() {
        return this.validCharacterEncodings;
    }

    @Override
    public void setInvalidCharacterEncodings(String[] encodings) {
        this.invalidCharacterEncodings = encodings;
    }

    @Override
    public String[] getInvalidCharacterEncodings() {
        return this.invalidCharacterEncodings;
    }

    @Override
    public void setAllowNullLocale(boolean isAllow) {
        this.isAllowNullLocale = isAllow;
    }

    @Override
    public boolean isAllowNullLocale() {
        return this.isAllowNullLocale;
    }

    @Override
    public void setValidLocales(String[] locales) {
        this.validLocales = locales;
    }

    @Override
    public String[] getValidLocales() {
        return this.validLocales;
    }

    @Override
    public void setValidProtocols(String[] protocols) {
        this.validProtocols = protocols;
    }

    @Override
    public String[] getValidProtocols() {
        return this.validProtocols;
    }

    @Override
    public void setValidRemoteAddrs(String[] addrs) {
        this.validRemoteAddrs = addrs;
    }

    @Override
    public String[] getValidRemoteAddrs() {
        return this.validRemoteAddrs;
    }

    @Override
    public void setValidRemoteHosts(String[] hosts) {
        this.validRemoteHosts = hosts;
    }

    @Override
    public String[] getValidRemoteHosts() {
        return this.validRemoteHosts;
    }

    @Override
    public void setValidRemotePorts(int[] ports) {
        this.validRemotePorts = ports;
    }

    @Override
    public int[] getValidRemotePorts() {
        return this.validRemotePorts;
    }

    @Override
    public void setValidSchemata(String[] schemata) {
        this.validSchemata = schemata;
    }

    @Override
    public String[] getValidSchemata() {
        return this.validSchemata;
    }

    @Override
    public void setValidServerNames(String[] names) {
        this.validServerNames = names;
    }

    @Override
    public String[] getValidServerNames() {
        return this.validServerNames;
    }

    @Override
    public void setValidMethods(String[] methods) {
        this.validMethods = methods;
    }

    @Override
    public String[] getValidMethods() {
        return this.validMethods;
    }

    @Override
    public void setInvalidMethods(String[] methods) {
        this.invalidMethods = methods;
    }

    @Override
    public String[] getInvalidMethods() {
        return this.invalidMethods;
    }

    @Override
    public void setHeaderEquals(Properties cond) {
        this.headerEquals = cond;
    }

    @Override
    public Properties getHeaderEquals() {
        return this.headerEquals;
    }

    @Override
    public void setErrorStatus(int status) {
        this.errorStatus = status;
    }

    @Override
    public int getErrorStatus() {
        return this.errorStatus;
    }

    @Override
    public void setThrowOnError(boolean isThrow) {
        this.isThrowOnError = isThrow;
    }

    @Override
    public boolean isThrowOnError() {
        return this.isThrowOnError;
    }

    @Override
    public void startService() throws Exception {
        int i;
        if (this.validLocales != null && this.validLocales.length != 0) {
            this.validLocalePatterns = new Pattern[this.validLocales.length];
            for (i = 0; i < this.validLocales.length; ++i) {
                this.validLocalePatterns[i] = Pattern.compile(this.validLocales[i]);
            }
        }
        if (this.validRemoteAddrs != null && this.validRemoteAddrs.length != 0) {
            this.validRemoteAddrPatterns = new Pattern[this.validRemoteAddrs.length];
            for (i = 0; i < this.validRemoteAddrs.length; ++i) {
                this.validRemoteAddrPatterns[i] = Pattern.compile(this.validRemoteAddrs[i]);
            }
        }
        if (this.validRemoteHosts != null && this.validRemoteHosts.length != 0) {
            this.validRemoteHostPatterns = new Pattern[this.validRemoteHosts.length];
            for (i = 0; i < this.validRemoteHosts.length; ++i) {
                this.validRemoteHostPatterns[i] = Pattern.compile(this.validRemoteHosts[i]);
            }
        }
        if (this.validServerNames != null && this.validServerNames.length != 0) {
            this.validServerNamePatterns = new Pattern[this.validServerNames.length];
            for (i = 0; i < this.validServerNames.length; ++i) {
                this.validServerNamePatterns[i] = Pattern.compile(this.validServerNames[i]);
            }
        }
        if (this.headerEquals != null) {
            this.headerEqualsMap = new HashMap();
            for (String string : this.headerEquals.keySet()) {
                this.headerEqualsMap.put(string, Pattern.compile(this.headerEquals.getProperty(string)));
            }
        }
        if (this.validContentTypes != null) {
            this.validContentTypeValueSet = new HashSet();
            for (int i2 = 0; i2 < this.validContentTypes.length; ++i2) {
                this.validContentTypeValueSet.add(new ContentType(this.validContentTypes[i2]));
            }
        }
        if (this.invalidContentTypes != null) {
            this.invalidContentTypeValues = new ContentType[this.invalidContentTypes.length];
            for (int i3 = 0; i3 < this.invalidContentTypes.length; ++i3) {
                this.invalidContentTypeValues[i3] = new ContentType(this.invalidContentTypes[i3]);
            }
        }
    }

    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        ServletRequest request = context.getServletRequest();
        ServletResponse response = context.getServletResponse();
        if (this.getState() == 3) {
            Matcher m;
            int i;
            Enumeration locales;
            String encoding;
            int i2;
            int contentLength = request.getContentLength();
            if (this.maxContentLength >= 0 && contentLength >= this.maxContentLength) {
                return this.fail(request, response, "MaxContentLength is " + this.maxContentLength + " : " + contentLength);
            }
            if (this.minContentLength >= 0 && contentLength <= this.minContentLength) {
                return this.fail(request, response, "MinContentLength is " + this.minContentLength + " : " + contentLength);
            }
            String contentType = request.getContentType();
            if (contentType == null) {
                if (!this.isAllowNullContentType) {
                    return this.fail(request, response, "ContentType is null.");
                }
            } else if (this.validContentTypeValueSet != null || this.invalidContentTypeValues != null) {
                ContentType contentTypeValue = new ContentType(contentType);
                if (this.validContentTypeValueSet != null && !this.validContentTypeValueSet.contains(contentTypeValue)) {
                    return this.fail(request, response, "ContentType is invalid : " + contentType);
                }
                if (this.invalidContentTypeValues != null) {
                    for (i2 = 0; i2 < this.invalidContentTypeValues.length; ++i2) {
                        if (!this.invalidContentTypeValues[i2].getMediaType().equalsIgnoreCase(contentTypeValue.getMediaType())) continue;
                        Map invalidParams = this.invalidContentTypeValues[i2].getParameters();
                        if (invalidParams == null) {
                            return this.fail(request, response, "ContentType is invalid : " + contentType);
                        }
                        Map params = contentTypeValue.getParameters();
                        if (params == null) continue;
                        boolean invalid = true;
                        for (Map.Entry entry : invalidParams.entrySet()) {
                            Object value;
                            if (!params.containsKey(entry.getKey()) || !((value = params.get(entry.getKey())) != null && entry.getValue() == null || value == null && entry.getValue() != null) && (entry.getValue() == null || entry.getValue().equals(value))) continue;
                            invalid = false;
                        }
                        if (!invalid) continue;
                        return this.fail(request, response, "ContentType is invalid : " + contentType);
                    }
                }
            }
            if ((encoding = request.getCharacterEncoding()) == null) {
                if (!this.isAllowNullCharacterEncoding) {
                    return this.fail(request, response, "CharacterEncoding is null.");
                }
            } else {
                if (this.validCharacterEncodings != null) {
                    boolean success = false;
                    for (int i3 = 0; i3 < this.validCharacterEncodings.length; ++i3) {
                        if (!encoding.equals(this.validCharacterEncodings[i3])) continue;
                        success = true;
                        break;
                    }
                    if (!success) {
                        return this.fail(request, response, "CharacterEncoding is invalid : " + encoding);
                    }
                }
                if (this.invalidCharacterEncodings != null) {
                    for (i2 = 0; i2 < this.invalidCharacterEncodings.length; ++i2) {
                        if (!encoding.equals(this.invalidCharacterEncodings[i2])) continue;
                        return this.fail(request, response, "CharacterEncoding is invalid : " + encoding);
                    }
                }
            }
            if (!(locales = request.getLocales()).hasMoreElements()) {
                if (!this.isAllowNullLocale) {
                    return this.fail(request, response, "Locale is null.");
                }
            } else if (this.validLocales != null) {
                boolean success = false;
                while (locales.hasMoreElements()) {
                    String locale = ((Locale)locales.nextElement()).toString();
                    for (i = 0; i < this.validLocales.length; ++i) {
                        m = this.validLocalePatterns[i].matcher(locale);
                        if (!m.matches()) continue;
                        success = true;
                        break;
                    }
                    if (!success) continue;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Locale is invalid : " + locales);
                }
            }
            if (this.validProtocols != null) {
                String protocol = request.getProtocol();
                boolean success = false;
                for (i = 0; i < this.validProtocols.length; ++i) {
                    if (!protocol.equals(this.validProtocols[i])) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Protocol is invalid : " + protocol);
                }
            }
            if (this.validRemoteAddrs != null) {
                String addr = request.getRemoteAddr();
                boolean success = false;
                for (i = 0; i < this.validRemoteAddrs.length; ++i) {
                    m = this.validRemoteAddrPatterns[i].matcher(addr);
                    if (!m.matches()) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Remote address is invalid : " + addr);
                }
            }
            if (this.validRemoteHosts != null) {
                String host = request.getRemoteHost();
                boolean success = false;
                for (i = 0; i < this.validRemoteHosts.length; ++i) {
                    m = this.validRemoteHostPatterns[i].matcher(host);
                    if (!m.matches()) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Remote host is invalid : " + host);
                }
            }
            if (this.validRemotePorts != null) {
                int port = request.getRemotePort();
                boolean success = false;
                for (i = 0; i < this.validRemotePorts.length; ++i) {
                    if (port != this.validRemotePorts[i]) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Remote port is invalid : " + port);
                }
            }
            if (this.validSchemata != null) {
                String scheme = request.getScheme();
                boolean success = false;
                for (i = 0; i < this.validSchemata.length; ++i) {
                    if (!scheme.equals(this.validSchemata[i])) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Scheme is invalid : " + scheme);
                }
            }
            if (this.validServerNames != null) {
                String serverName = request.getServerName();
                boolean success = false;
                for (i = 0; i < this.validServerNames.length; ++i) {
                    m = this.validServerNamePatterns[i].matcher(serverName);
                    if (!m.matches()) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Server name is invalid : " + serverName);
                }
            }
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpReq = (HttpServletRequest)request;
                String method = httpReq.getMethod();
                if (this.validMethods != null && method != null) {
                    boolean success = false;
                    for (int i4 = 0; i4 < this.validMethods.length; ++i4) {
                        if (!method.equals(this.validMethods[i4])) continue;
                        success = true;
                        break;
                    }
                    if (!success) {
                        return this.fail(request, response, "Method is invalid : " + method);
                    }
                }
                if (this.invalidMethods != null && method != null) {
                    for (i = 0; i < this.invalidMethods.length; ++i) {
                        if (!method.equals(this.invalidMethods[i])) continue;
                        return this.fail(request, response, "Method is invalid : " + method);
                    }
                }
                if (this.headerEqualsMap != null && this.headerEqualsMap.size() != 0) {
                    for (String name : this.headerEqualsMap.keySet()) {
                        String value = httpReq.getHeader(name);
                        if (value == null) {
                            return this.fail(request, response, "Header " + name + " is invalid : " + value);
                        }
                        Pattern p = (Pattern)this.headerEqualsMap.get(name);
                        Matcher m2 = p.matcher(value);
                        if (m2.matches()) continue;
                        return this.fail(request, response, "Header " + name + " is invalid : " + value);
                    }
                }
            }
        }
        return chain.invokeNext(context);
    }

    protected Object fail(ServletRequest request, ServletResponse response, String message) throws HttpServletRequestCheckException {
        if (this.isThrowOnError) {
            throw new HttpServletRequestCheckException(message);
        }
        if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).setStatus(this.errorStatus);
        }
        return null;
    }

    private static class ContentType
    implements Serializable {
        private static final long serialVersionUID = -2168875657048050381L;
        private final String mediaType;
        private final int hashCode;
        private Map parameters;

        public ContentType(String contentType) {
            String[] types = contentType.split(";");
            this.mediaType = types[0].trim();
            int hash = this.mediaType.toLowerCase().hashCode();
            if (types.length > 1) {
                this.parameters = new HashMap();
                for (int i = 1; i < types.length; ++i) {
                    String parameter = types[i].trim();
                    int index = parameter.indexOf(61);
                    if (index != -1) {
                        this.parameters.put(parameter.substring(0, index).toLowerCase(), parameter.substring(index + 1).toLowerCase());
                        continue;
                    }
                    this.parameters.put(parameter.toLowerCase(), null);
                }
                hash += this.parameters.hashCode();
            }
            this.hashCode = hash;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public Map getParameters() {
            return this.parameters;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ContentType)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            ContentType cmp = (ContentType)obj;
            if (!this.mediaType.equalsIgnoreCase(cmp.mediaType)) {
                return false;
            }
            if (this.parameters == null && cmp.parameters == null) {
                return true;
            }
            if (this.parameters == null && cmp.parameters != null || this.parameters != null && cmp.parameters == null) {
                return false;
            }
            return this.parameters.equals(cmp.parameters);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.mediaType);
            if (this.parameters != null) {
                Iterator itr = this.parameters.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    buf.append(entry.getKey());
                    if (entry.getValue() != null) {
                        buf.append('=').append(entry.getValue());
                    }
                    if (!itr.hasNext()) continue;
                    buf.append("; ");
                }
            }
            return buf.toString();
        }
    }
}

