/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.Method;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.MethodJournalInterceptorServiceMBean;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editor.MethodCallJournalData;
import jp.ossc.nimbus.service.journal.editor.MethodReturnJournalData;
import jp.ossc.nimbus.service.journal.editor.MethodThrowJournalData;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class MethodJournalInterceptorService
extends ServiceBase
implements Interceptor,
MethodJournalInterceptorServiceMBean {
    private static final long serialVersionUID = 6121765320688713719L;
    private ServiceName threadContextName;
    private Context threadContext;
    private ServiceName journalName;
    private Journal journal;
    private ServiceName requestEditorFinderName;
    private ServiceName methodCallEditorFinderName;
    private ServiceName methodReturnEditorFinderName;
    private EditorFinder requestEditorFinder;
    private EditorFinder methodCallEditorFinder;
    private EditorFinder methodReturnEditorFinder;
    private String requestJournalKey = "Request";
    private String methodCallJournalKey = "MethodCall";
    private String methodReturnJournalKey = "MethodReturn";
    private String requestIdKey = "REQUEST_ID";
    private boolean isEnabled = true;
    private boolean isBushingCallBlock = false;
    protected ThreadLocal callStack;

    @Override
    public void setRequestIdKey(String key) {
        this.requestIdKey = key;
    }

    @Override
    public String getRequestIdKey() {
        return this.requestIdKey;
    }

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextName;
    }

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalName;
    }

    @Override
    public void setRequestEditorFinderServiceName(ServiceName name) {
        this.requestEditorFinderName = name;
    }

    @Override
    public ServiceName getRequestEditorFinderServiceName() {
        return this.requestEditorFinderName;
    }

    @Override
    public void setMethodCallEditorFinderServiceName(ServiceName name) {
        this.methodCallEditorFinderName = name;
    }

    @Override
    public ServiceName getMethodCallEditorFinderServiceName() {
        return this.methodCallEditorFinderName;
    }

    @Override
    public void setMethodReturnEditorFinderServiceName(ServiceName name) {
        this.methodReturnEditorFinderName = name;
    }

    @Override
    public ServiceName getMethodReturnEditorFinderServiceName() {
        return this.methodReturnEditorFinderName;
    }

    @Override
    public void setRequestJournalKey(String key) {
        this.requestJournalKey = key;
    }

    @Override
    public String getRequestJournalKey() {
        return this.requestJournalKey;
    }

    @Override
    public void setMethodCallJournalKey(String key) {
        this.methodCallJournalKey = key;
    }

    @Override
    public String getMethodCallJournalKey() {
        return this.methodCallJournalKey;
    }

    @Override
    public void setMethodReturnJournalKey(String key) {
        this.methodReturnJournalKey = key;
    }

    @Override
    public String getMethodReturnJournalKey() {
        return this.methodReturnJournalKey;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setBushingCallBlock(boolean isBlock) {
        this.isBushingCallBlock = isBlock;
    }

    @Override
    public boolean isBushingCallBlock() {
        return this.isBushingCallBlock;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public void setMethodCallEditorFinder(EditorFinder editorFinder) {
        this.methodCallEditorFinder = editorFinder;
    }

    public void setMethodReturnEditorFinder(EditorFinder editorFinder) {
        this.methodReturnEditorFinder = editorFinder;
    }

    public void setRequestEditorFinder(EditorFinder editorFinder) {
        this.requestEditorFinder = editorFinder;
    }

    public void setThreadContext(Context context) {
        this.threadContext = context;
    }

    @Override
    public void startService() throws Exception {
        if (this.journalName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalName);
        }
        if (this.requestEditorFinderName != null) {
            this.requestEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.requestEditorFinderName);
        }
        if (this.methodCallEditorFinderName != null) {
            this.methodCallEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.methodCallEditorFinderName);
        }
        if (this.methodReturnEditorFinderName != null) {
            this.methodReturnEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.methodReturnEditorFinderName);
        }
        if (this.threadContextName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextName);
        }
        if (this.isBushingCallBlock) {
            this.callStack = new ThreadLocal(){

                protected Object initialValue() {
                    return new CallStack();
                }
            };
        }
    }

    @Override
    public void stopService() throws Exception {
        this.callStack = null;
    }

    @Override
    public void destroyService() {
        this.journal = null;
        this.requestEditorFinder = null;
        this.methodCallEditorFinder = null;
        this.methodReturnEditorFinder = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        Object ret;
        MethodInvocationContext ctx;
        block9: {
            ctx = (MethodInvocationContext)context;
            if (this.getState() != 3) return chain.invokeNext(ctx);
            if (!this.isEnabled()) return chain.invokeNext(ctx);
            if (this.callStack != null) {
                if (((CallStack)this.callStack.get()).stackIndex != 0) return chain.invokeNext(ctx);
            }
            ret = null;
            try {
                this.preNext(ctx);
                if (this.callStack != null) {
                    ++((CallStack)this.callStack.get()).stackIndex;
                }
                ret = chain.invokeNext(ctx);
                this.postNext(ctx, ret);
                if (this.callStack == null) break block9;
            }
            catch (RuntimeException e) {
                try {
                    throw this.throwRuntimeException(ctx, e);
                    catch (Exception e2) {
                        throw this.throwException(ctx, e2);
                    }
                    catch (Error e3) {
                        throw this.throwError(ctx, e3);
                    }
                }
                catch (Throwable throwable) {
                    if (this.callStack != null) {
                        --((CallStack)this.callStack.get()).stackIndex;
                    }
                    this.finallyNext(ctx, ret);
                    throw throwable;
                }
            }
            --((CallStack)this.callStack.get()).stackIndex;
        }
        this.finallyNext(ctx, ret);
        return ret;
    }

    protected void preNext(MethodInvocationContext context) throws Throwable {
        if (this.journal == null) {
            return;
        }
        this.journal.startJournal(this.requestJournalKey, this.requestEditorFinder);
        if (this.threadContext != null && this.requestIdKey != null) {
            this.journal.setRequestId((String)this.threadContext.get(this.requestIdKey));
        }
        Method method = context.getTargetMethod();
        MethodCallJournalData data = new MethodCallJournalData(context.getTargetObject(), method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), context.getParameters());
        this.journal.addInfo(this.methodCallJournalKey, (Object)data, this.methodCallEditorFinder);
    }

    protected void postNext(MethodInvocationContext context, Object ret) throws Throwable {
        if (this.journal == null) {
            return;
        }
        Method method = context.getTargetMethod();
        MethodReturnJournalData data = new MethodReturnJournalData(context.getTargetObject(), method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), ret);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.methodReturnEditorFinder);
    }

    protected RuntimeException throwRuntimeException(MethodInvocationContext context, RuntimeException e) throws Throwable {
        if (this.journal == null) {
            return e;
        }
        Method method = context.getTargetMethod();
        MethodThrowJournalData data = new MethodThrowJournalData(context.getTargetObject(), method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), e);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.methodReturnEditorFinder);
        return e;
    }

    protected Exception throwException(MethodInvocationContext context, Exception e) throws Throwable {
        if (this.journal == null) {
            return e;
        }
        Method method = context.getTargetMethod();
        MethodThrowJournalData data = new MethodThrowJournalData(context.getTargetObject(), method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), e);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.methodReturnEditorFinder);
        return e;
    }

    protected Error throwError(MethodInvocationContext context, Error error) throws Throwable {
        if (this.journal == null) {
            return error;
        }
        Method method = context.getTargetMethod();
        MethodThrowJournalData data = new MethodThrowJournalData(context.getTargetObject(), method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), error);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.methodReturnEditorFinder);
        return error;
    }

    protected void finallyNext(MethodInvocationContext context, Object ret) throws Throwable {
        if (this.journal == null) {
            return;
        }
        this.journal.endJournal();
    }

    protected static class CallStack {
        public int stackIndex;

        protected CallStack() {
        }
    }
}

