/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.FailToObtainSemaphoreException;
import jp.ossc.nimbus.service.aop.interceptor.FlowControlInterceptorServiceMBean;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class FlowControlInterceptorService
extends ServiceBase
implements Interceptor,
FlowControlInterceptorServiceMBean {
    private static final long serialVersionUID = 519397295732596256L;
    private ServiceName semaphoreServiceName;
    private Semaphore semaphore;
    private long timeout = -1L;
    private boolean isFailToObtainSemaphore = true;
    private int maxWaitingCount = -1;
    private long forceFreeTimeout = -1L;

    @Override
    public void setSemaphoreServiceName(ServiceName name) {
        this.semaphoreServiceName = name;
    }

    @Override
    public ServiceName getSemaphoreServiceName() {
        return this.semaphoreServiceName;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setMaxWaitingCount(int count) {
        this.maxWaitingCount = count;
    }

    @Override
    public int getMaxWaitingCount() {
        return this.maxWaitingCount;
    }

    @Override
    public void setForceFreeTimeout(long timeout) {
        this.forceFreeTimeout = timeout;
    }

    @Override
    public long getForceFreeTimeout() {
        return this.forceFreeTimeout;
    }

    @Override
    public void setFailToObtainSemaphore(boolean isThrow) {
        this.isFailToObtainSemaphore = isThrow;
    }

    @Override
    public boolean isFailToObtainSemaphore() {
        return this.isFailToObtainSemaphore;
    }

    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
    }

    @Override
    public void startService() throws Exception {
        if (this.semaphore == null && this.semaphoreServiceName != null) {
            this.semaphore = (Semaphore)ServiceManagerFactory.getServiceObject(this.semaphoreServiceName);
        }
        if (this.semaphore != null) {
            this.semaphore.accept();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3 && this.semaphore != null) {
            boolean isSuccess = this.semaphore.getResource(this.timeout, this.maxWaitingCount, this.forceFreeTimeout);
            Thread.interrupted();
            if (!isSuccess) {
                if (this.isFailToObtainSemaphore) {
                    throw new FailToObtainSemaphoreException();
                }
                return null;
            }
            try {
                Object object = chain.invokeNext(context);
                return object;
            }
            finally {
                this.semaphore.freeResource();
            }
        }
        return chain.invokeNext(context);
    }
}

