/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import jp.ossc.nimbus.util.converter.PaddingStringConverter;

public class FLVWriter
extends BufferedWriter {
    public static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    protected String lineSeparator = DEFAULT_LINE_SEPARATOR;
    protected boolean isAppendElement;
    protected int fieldIndex;
    protected String nullValue;
    protected PaddingStringConverter[] converters;
    protected WriterWrapper writerWrapper = (WriterWrapper)this.lock;

    public FLVWriter() {
        this(new WriterWrapper());
    }

    public FLVWriter(Writer writer) {
        this(writer, null);
    }

    public FLVWriter(Writer writer, PaddingStringConverter[] convs) {
        super(writer instanceof WriterWrapper ? writer : new WriterWrapper(writer));
        this.converters = convs;
    }

    public FLVWriter(int size) {
        this((Writer)new WriterWrapper(), size);
    }

    public FLVWriter(Writer writer, int size) {
        this(writer, null, size);
    }

    public FLVWriter(Writer writer, PaddingStringConverter[] convs, int size) {
        super(writer instanceof WriterWrapper ? writer : new WriterWrapper(writer), size);
        this.converters = convs;
    }

    public void setWriter(Writer writer) throws IOException {
        this.writerWrapper.setWriter(writer);
        this.isAppendElement = false;
        this.fieldIndex = 0;
    }

    public void setFieldPaddingStringConverter(PaddingStringConverter[] convs) {
        this.converters = convs;
    }

    public PaddingStringConverter[] getFieldPaddingStringConverter() {
        return this.converters;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setNullValue(String value) {
        this.nullValue = value;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    @Override
    public void newLine() throws IOException {
        super.write(this.lineSeparator);
        this.isAppendElement = false;
        this.fieldIndex = 0;
    }

    public void writeElement(String element) throws IOException {
        if (this.converters != null && this.converters.length != 0 && this.converters[this.fieldIndex] != null) {
            element = this.converters[this.fieldIndex].padding(element);
        }
        super.write(element);
        this.isAppendElement = true;
        ++this.fieldIndex;
    }

    public void writeElement(boolean element) throws IOException {
        this.writeElement(Boolean.toString(element));
    }

    public void writeElement(byte element) throws IOException {
        this.writeElement(Byte.toString(element));
    }

    public void writeElement(char element) throws IOException {
        this.writeElement(Character.toString(element));
    }

    public void writeElement(short element) throws IOException {
        this.writeElement(Short.toString(element));
    }

    public void writeElement(int element) throws IOException {
        this.writeElement(Integer.toString(element));
    }

    public void writeElement(long element) throws IOException {
        this.writeElement(Long.toString(element));
    }

    public void writeElement(float element) throws IOException {
        this.writeElement(Float.toString(element));
    }

    public void writeElement(double element) throws IOException {
        this.writeElement(Double.toString(element));
    }

    public void writeElement(Object element) throws IOException {
        this.writeElement(element == null ? (String)null : element.toString());
    }

    public void writeFLV(String[] elements) throws IOException {
        for (int i = 0; i < elements.length; ++i) {
            this.writeElement(elements[i]);
        }
        this.newLine();
    }

    public void writeFLV(Object[] elements) throws IOException {
        for (int i = 0; i < elements.length; ++i) {
            this.writeElement(elements[i]);
        }
        this.newLine();
    }

    public void writeFLV(List elements) throws IOException {
        int imax = elements.size();
        for (int i = 0; i < imax; ++i) {
            this.writeElement(elements.get(i));
        }
        this.newLine();
    }

    public FLVWriter cloneWriter() {
        return this.cloneWriter(new FLVWriter());
    }

    protected FLVWriter cloneWriter(FLVWriter clone) {
        clone.lineSeparator = this.lineSeparator;
        if (this.converters != null && this.converters.length != 0) {
            clone.converters = new PaddingStringConverter[this.converters.length];
            System.arraycopy(this.converters, 0, clone.converters, 0, this.converters.length);
        }
        return clone;
    }

    private static class WriterWrapper
    extends Writer {
        private Writer realWriter;
        private static Method APPEND1 = null;
        private static Method APPEND2 = null;
        private static Method APPEND3 = null;

        public WriterWrapper() {
        }

        public WriterWrapper(Writer writer) {
            this.realWriter = writer;
        }

        public Writer getWriter() {
            return this.realWriter;
        }

        public void setWriter(Writer writer) throws IOException {
            if (this.realWriter != null) {
                throw new IOException("Writer is already commited.");
            }
            this.realWriter = writer;
        }

        @Override
        public void write(int c) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            this.realWriter.write(c);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            this.realWriter.write(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            this.realWriter.write(cbuf, off, len);
        }

        @Override
        public void write(String str) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            this.realWriter.write(str);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            this.realWriter.write(str, off, len);
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            if (APPEND1 == null) {
                throw new UnsupportedOperationException("No such method.");
            }
            try {
                return (Writer)APPEND1.invoke((Object)this.realWriter, csq);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e.toString());
            }
        }

        @Override
        public Writer append(CharSequence csq, int off, int len) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            if (APPEND2 == null) {
                throw new UnsupportedOperationException("No such method.");
            }
            try {
                return (Writer)APPEND2.invoke((Object)this.realWriter, csq, new Integer(off), new Integer(len));
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e.toString());
            }
        }

        @Override
        public Writer append(char c) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            if (APPEND3 == null) {
                throw new UnsupportedOperationException("No such method.");
            }
            try {
                return (Writer)APPEND3.invoke((Object)this.realWriter, new Character(c));
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e.toString());
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.realWriter != null) {
                this.realWriter.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.realWriter != null) {
                this.realWriter.close();
            }
        }

        static {
            try {
                APPEND1 = Writer.class.getMethod("append", CharSequence.class);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                APPEND2 = Writer.class.getMethod("append", CharSequence.class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                APPEND3 = Writer.class.getMethod("append", Character.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

