/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import org.w3c.dom.Element;

public abstract class PropertyMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 6347124074999661643L;
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    protected String name;
    protected String value;

    public PropertyMetaData(MetaData parent) {
        super(parent);
    }

    protected abstract String getTagName();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(this.getTagName())) {
            throw new DeploymentException("Tag must be " + this.getTagName() + " : " + element.getTagName());
        }
        this.name = PropertyMetaData.getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        this.value = PropertyMetaData.getElementContent(element);
        if (this.value == null) {
            this.value = "";
        }
    }

    @Override
    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(this.getTagName()).append(" name=\"").append(this.name).append("\">");
        if (this.value != null) {
            buf.append(this.value);
        }
        buf.append("</").append(this.getTagName()).append('>');
        return buf;
    }
}

