/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.DefaultPropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.core.NimbusClassLoader;

public class RecordSchema {
    public static final String PROPERTY_SCHEMA_ALIAS_NAME_LIST = "LIST";
    public static final String PROPERTY_SCHEMA_ALIAS_NAME_RECORD = "RECORD";
    public static final String PROPERTY_SCHEMA_ALIAS_NAME_XPATH = "XPATH";
    private static final String PROP_SCHEMA_CLASS_DELIMETER = ":";
    protected static final Map recordSchemaManager = Collections.synchronizedMap(new HashMap());
    protected static final Map propertySchemaManager = Collections.synchronizedMap(new HashMap());
    protected static final Map propertySchemaAliasMap = Collections.synchronizedMap(new HashMap());
    protected Map propertySchemaMap = new HashMap();
    protected Map propertyNameIndexMap = new HashMap();
    protected PropertySchema[] propertySchemata;
    protected PropertySchema[] primaryKeyProperties;
    protected String schema;

    public static RecordSchema getInstance(String schema) throws PropertySchemaDefineException {
        RecordSchema recordSchema = (RecordSchema)recordSchemaManager.get(schema);
        if (recordSchema == null) {
            recordSchema = new RecordSchema();
            recordSchema.setSchema(schema);
            recordSchemaManager.put(schema, recordSchema);
        }
        return recordSchema;
    }

    public static RecordSchema getInstance(PropertySchema[] schemata) throws PropertySchemaDefineException {
        StringBuffer buf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < schemata.length; ++i) {
            PropertySchema propertySchema = schemata[i];
            buf.append(propertySchema.getSchema());
            if (i == schemata.length - 1) continue;
            buf.append(lineSep);
        }
        String schema = buf.toString();
        RecordSchema recordSchema = (RecordSchema)recordSchemaManager.get(schema);
        if (recordSchema == null) {
            recordSchema = new RecordSchema();
            recordSchema.setPropertySchemata(schemata);
            recordSchemaManager.put(schema, recordSchema);
        }
        return recordSchema;
    }

    public RecordSchema appendSchema(String schema) throws PropertySchemaDefineException {
        StringBuffer buf = new StringBuffer();
        if (this.schema != null) {
            buf.append(this.schema);
            buf.append(System.getProperty("line.separator"));
        }
        buf.append(schema);
        String newSchema = buf.toString();
        RecordSchema recordSchema = (RecordSchema)recordSchemaManager.get(newSchema);
        if (recordSchema == null) {
            recordSchema = new RecordSchema();
            recordSchema.setSchema(newSchema);
            recordSchemaManager.put(newSchema, recordSchema);
        }
        return recordSchema;
    }

    public void setSchema(String schema) throws PropertySchemaDefineException {
        this.propertySchemaMap.clear();
        this.propertyNameIndexMap.clear();
        if (this.primaryKeyProperties != null) {
            this.primaryKeyProperties = null;
        }
        BufferedReader reader = new BufferedReader(new StringReader(schema));
        String propertySchemaStr = null;
        try {
            ArrayList<PropertySchema> propertySchemaList = new ArrayList<PropertySchema>();
            ArrayList<PropertySchema> primaryKeyProps = null;
            while ((propertySchemaStr = reader.readLine()) != null) {
                PropertySchema propertySchema = this.createPropertySchema(propertySchemaStr);
                if (propertySchema == null) continue;
                if (this.propertySchemaMap.containsKey(propertySchema.getName())) {
                    throw new PropertySchemaDefineException(propertySchemaStr, "Property name is duplicated.");
                }
                propertySchemaList.add(propertySchema);
                this.propertySchemaMap.put(propertySchema.getName(), propertySchema);
                this.propertyNameIndexMap.put(propertySchema.getName(), new Integer(this.propertySchemaMap.size() - 1));
                if (!propertySchema.isPrimaryKey()) continue;
                if (primaryKeyProps == null) {
                    primaryKeyProps = new ArrayList<PropertySchema>();
                }
                primaryKeyProps.add(propertySchema);
            }
            this.propertySchemata = propertySchemaList.toArray(new PropertySchema[propertySchemaList.size()]);
            if (primaryKeyProps != null) {
                this.primaryKeyProperties = primaryKeyProps.toArray(new PropertySchema[primaryKeyProps.size()]);
            }
        }
        catch (IOException e) {
            throw new PropertySchemaDefineException(schema, e);
        }
        this.schema = schema;
    }

    protected PropertySchema createPropertySchema(String schema) throws PropertySchemaDefineException {
        if (schema == null || schema.length() == 0) {
            return null;
        }
        Class propertySchemaClass = DefaultPropertySchema.class;
        int index = schema.indexOf(PROP_SCHEMA_CLASS_DELIMETER);
        if (index == -1 || index == schema.length() - 1) {
            throw new PropertySchemaDefineException(schema, "The class name of PropertySchema is not specified.");
        }
        if (index != 0) {
            String propertySchemaClassName = schema.substring(0, index);
            if (propertySchemaAliasMap.containsKey(propertySchemaClassName)) {
                propertySchemaClassName = (String)propertySchemaAliasMap.get(propertySchemaClassName);
            }
            try {
                propertySchemaClass = Class.forName(propertySchemaClassName, true, NimbusClassLoader.getInstance());
            }
            catch (ClassNotFoundException e) {
                throw new PropertySchemaDefineException(schema, "The class name of PropertySchema is illegal.", e);
            }
        }
        schema = schema.substring(index + 1);
        String propertySchemaKey = propertySchemaClass.getName() + schema;
        PropertySchema propertySchema = (PropertySchema)propertySchemaManager.get(propertySchemaKey);
        if (propertySchema == null) {
            try {
                propertySchema = (PropertySchema)propertySchemaClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new PropertySchemaDefineException(schema, e);
            }
            catch (IllegalAccessException e) {
                throw new PropertySchemaDefineException(schema, e);
            }
            propertySchema.setSchema(schema);
            propertySchemaManager.put(propertySchemaKey, propertySchema);
        }
        return propertySchema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setPropertySchemata(PropertySchema[] schemata) {
        this.propertySchemaMap.clear();
        this.propertyNameIndexMap.clear();
        if (this.primaryKeyProperties != null) {
            this.primaryKeyProperties = null;
        }
        ArrayList<PropertySchema> propertySchemaList = new ArrayList<PropertySchema>();
        ArrayList<PropertySchema> primaryKeyProps = null;
        StringBuffer buf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < schemata.length; ++i) {
            PropertySchema propertySchema = schemata[i];
            buf.append(propertySchema.getSchema());
            if (i != schemata.length - 1) {
                buf.append(lineSep);
            }
            String propertySchemaKey = propertySchema.getClass().getName() + propertySchema.getSchema();
            propertySchemaManager.put(propertySchemaKey, propertySchema);
            propertySchemaList.add(propertySchema);
            this.propertySchemaMap.put(propertySchema.getName(), propertySchema);
            this.propertyNameIndexMap.put(propertySchema.getName(), new Integer(this.propertySchemaMap.size() - 1));
            if (!propertySchema.isPrimaryKey()) continue;
            if (primaryKeyProps == null) {
                primaryKeyProps = new ArrayList<PropertySchema>();
            }
            primaryKeyProps.add(propertySchema);
        }
        this.propertySchemata = propertySchemaList.toArray(new PropertySchema[propertySchemaList.size()]);
        if (primaryKeyProps != null) {
            this.primaryKeyProperties = primaryKeyProps.toArray(new PropertySchema[primaryKeyProps.size()]);
        }
        this.schema = buf.toString();
    }

    public PropertySchema[] getPropertySchemata() {
        return this.propertySchemata;
    }

    public PropertySchema[] getPrimaryKeyPropertySchemata() {
        return this.primaryKeyProperties;
    }

    public String getPropertyName(int index) {
        if (index < 0 || index >= this.propertySchemata.length) {
            return null;
        }
        return this.propertySchemata[index].getName();
    }

    public int getPropertyIndex(String name) {
        Integer index = (Integer)this.propertyNameIndexMap.get(name);
        return index == null ? -1 : index;
    }

    public PropertySchema getPropertySchema(int index) {
        if (index < 0 || index >= this.propertySchemata.length) {
            return null;
        }
        return this.propertySchemata[index];
    }

    public PropertySchema getPropertySchema(String name) {
        if (name == null) {
            return null;
        }
        return (PropertySchema)this.propertySchemaMap.get(name);
    }

    public int getPropertySize() {
        return this.propertySchemata.length;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        if (this.propertySchemata != null) {
            int imax = this.propertySchemata.length;
            for (int i = 0; i < imax; ++i) {
                buf.append(this.propertySchemata[i]);
                if (i == imax - 1) continue;
                buf.append(';');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    static {
        propertySchemaAliasMap.put(PROPERTY_SCHEMA_ALIAS_NAME_LIST, "jp.ossc.nimbus.beans.dataset.RecordListPropertySchema");
        propertySchemaAliasMap.put(PROPERTY_SCHEMA_ALIAS_NAME_RECORD, "jp.ossc.nimbus.beans.dataset.RecordPropertySchema");
        propertySchemaAliasMap.put(PROPERTY_SCHEMA_ALIAS_NAME_XPATH, "jp.ossc.nimbus.beans.dataset.XpathPropertySchema");
    }
}

