/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertyValidateException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.service.codemaster.CodeMasterUpdateKey;
import jp.ossc.nimbus.service.codemaster.PartUpdate;
import jp.ossc.nimbus.service.codemaster.PartUpdateRecords;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class RecordList
implements Externalizable,
List,
Cloneable,
PartUpdate {
    private static final long serialVersionUID = 6399184480196775369L;
    public static final String PRIMARY_KEY_INDEX_NAME = "$PRIMARY_KEY";
    protected String name;
    protected String schema;
    protected Class recordClass;
    protected RecordSchema recordSchema;
    protected List records = Collections.synchronizedList(new ArrayList());
    protected Map stockSearchConditionMap;
    protected Map stockSearchResultMap;
    protected Map stockSearchKeyMap;
    protected Map stockSearchKeyResultMap;
    protected int modCount = 0;
    protected int[] partUpdateOrderBy;
    protected boolean[] partUpdateIsAsc;
    protected boolean isSynchronized = true;

    public RecordList() {
        this(true);
    }

    public RecordList(boolean isSynch) {
        this.isSynchronized = isSynch;
        this.records = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
    }

    public RecordList(String name) {
        this(name, true);
    }

    public RecordList(String name, boolean isSynch) {
        this.name = name;
        this.isSynchronized = isSynch;
        this.records = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
    }

    public RecordList(String name, String schema) throws PropertySchemaDefineException {
        this(name, schema, true);
    }

    public RecordList(String name, String schema, boolean isSynch) throws PropertySchemaDefineException {
        this(name, isSynch);
        this.setSchema(schema);
    }

    public RecordList(String name, RecordSchema schema) throws PropertySchemaDefineException {
        this(name, schema, true);
    }

    public RecordList(String name, RecordSchema schema, boolean isSynch) throws PropertySchemaDefineException {
        this(name, isSynch);
        this.setRecordSchema(schema);
    }

    public RecordList(String name, Class clazz) throws PropertySchemaDefineException {
        this(name, clazz, true);
    }

    public RecordList(String name, Class clazz, boolean isSynch) throws PropertySchemaDefineException {
        this(name, isSynch);
        this.setRecordClass(clazz);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSchema(String schema) throws PropertySchemaDefineException {
        this.setRecordSchema(RecordSchema.getInstance(schema));
    }

    public String getSchema() {
        return this.schema;
    }

    public void setRecordSchema(RecordSchema schema) throws PropertySchemaDefineException {
        if (this.size() != 0) {
            throw new PropertySchemaDefineException("Record already exists.");
        }
        this.recordSchema = schema;
        this.schema = schema == null ? null : schema.getSchema();
        ArrayList<String> primaryKeyNames = null;
        PropertySchema[] primaryKeys = this.recordSchema.getPrimaryKeyPropertySchemata();
        if (primaryKeys != null) {
            for (int i = 0; i < primaryKeys.length; ++i) {
                if (primaryKeyNames == null) {
                    primaryKeyNames = new ArrayList<String>();
                }
                primaryKeyNames.add(primaryKeys[i].getName());
            }
        }
        if (primaryKeyNames == null) {
            this.removeStockKey(PRIMARY_KEY_INDEX_NAME);
        } else {
            this.setStockKeySearch(PRIMARY_KEY_INDEX_NAME, primaryKeyNames.toArray(new String[primaryKeyNames.size()]));
        }
    }

    public void replaceSchema(String schema) throws PropertySchemaDefineException {
        this.replaceRecordSchema(RecordSchema.getInstance(schema));
    }

    public void replaceRecordSchema(RecordSchema schema) throws PropertySchemaDefineException {
        if (this.recordSchema != null && schema != null && this.size() != 0) {
            int imax = this.records.size();
            for (int i = 0; i < imax; ++i) {
                Record record = (Record)this.records.get(i);
                record.replaceRecordSchema(schema);
            }
        }
        this.setRecordSchema(schema);
    }

    public void appendSchema(String schema) throws PropertySchemaDefineException {
        if (this.recordSchema == null) {
            this.setSchema(schema);
        } else {
            this.replaceRecordSchema(this.recordSchema.appendSchema(schema));
        }
    }

    public RecordSchema getRecordSchema() {
        return this.recordSchema;
    }

    public void setRecordClass(Class clazz) throws PropertySchemaDefineException {
        Record record = null;
        try {
            record = (Record)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (IllegalAccessException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (ClassCastException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        this.setRecordSchema(record.getRecordSchema());
        this.recordClass = clazz;
    }

    public Class getRecordClass() {
        return this.recordClass == null ? Record.class : this.recordClass;
    }

    public Record createRecord() {
        if (this.recordClass == null) {
            return new Record(this.recordSchema);
        }
        try {
            return (Record)this.recordClass.newInstance();
        }
        catch (Exception e) {
            return new Record(this.recordSchema);
        }
    }

    public Record getRecord(int index) {
        return (Record)this.get(index);
    }

    public void addRecord(Record r) {
        this.add(r);
    }

    public void addRecord(int index, Record r) {
        this.add(index, r);
    }

    public Record setRecord(int index, Record r) {
        return (Record)this.set(index, r);
    }

    public void removeRecord(Record r) {
        this.remove(r);
    }

    public Record removeRecord(int index) {
        return (Record)this.remove(index);
    }

    public void setStockKeySearch(String name, String[] propertyNames) {
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        int[] propertyIndexes = new int[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            propertyIndexes[i] = this.recordSchema.getPropertyIndex(propertyNames[i]);
            if (propertyIndexes[i] != -1) continue;
            throw new DataSetException("No such property " + propertyNames[i]);
        }
        this.setStockKeySearch(name, propertyIndexes);
    }

    public void setStockKeySearch(String name, int[] propertyIndexes) {
        if (this.stockSearchKeyMap == null) {
            Map map = this.stockSearchKeyMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        int fieldSize = this.recordSchema.getPropertySize();
        for (int i = 0; i < propertyIndexes.length; ++i) {
            if (propertyIndexes[i] < fieldSize) continue;
            throw new DataSetException("No such property " + propertyIndexes[i]);
        }
        RecordKeyCondition condition = new RecordKeyCondition(propertyIndexes);
        this.stockSearchKeyMap.put(name, condition);
        if (this.stockSearchKeyResultMap == null) {
            this.stockSearchKeyResultMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
        } else {
            this.stockSearchKeyResultMap.remove(name);
        }
        if (this.size() != 0) {
            this.analyzeStockKey(name);
        }
    }

    public String[] getStockKeyNames() {
        return this.stockSearchKeyMap == null || this.stockSearchKeyMap.size() == 0 ? new String[]{} : this.stockSearchKeyMap.keySet().toArray(new String[this.stockSearchKeyMap.size()]);
    }

    public String[] getStockKeyPropertyNames(String name) {
        int[] indexes = this.getStockKeyPropertyIndexes(name);
        if (indexes == null || this.recordSchema == null) {
            return null;
        }
        String[] propNames = new String[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            propNames[i] = this.recordSchema.getPropertyName(indexes[i]);
        }
        return propNames;
    }

    public int[] getStockKeyPropertyIndexes(String name) {
        if (this.stockSearchKeyMap == null || !this.stockSearchKeyMap.containsKey(name)) {
            return null;
        }
        RecordKeyCondition condition = (RecordKeyCondition)this.stockSearchKeyMap.get(name);
        return condition.propertyIndexes;
    }

    public void removeStockKey(String name) {
        if (this.stockSearchKeyMap != null) {
            this.stockSearchKeyMap.remove(name);
        }
        if (this.stockSearchKeyResultMap != null) {
            this.stockSearchKeyResultMap.remove(name);
        }
    }

    public void clearStockKey() {
        if (this.stockSearchKeyMap != null) {
            this.stockSearchKeyMap.clear();
        }
        if (this.stockSearchKeyResultMap != null) {
            this.stockSearchKeyResultMap.clear();
        }
    }

    public void setStockSearchCondition(String name, String condition) throws DataSetException {
        if (this.stockSearchConditionMap == null) {
            Map map = this.stockSearchConditionMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        try {
            Expression exp = ExpressionFactory.createExpression((String)condition);
            this.stockSearchConditionMap.put(name, exp);
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
        if (this.stockSearchResultMap == null) {
            this.stockSearchResultMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
        } else {
            this.stockSearchResultMap.remove(name);
        }
        if (this.size() != 0) {
            this.analyzeStockSearchCondition(name);
        }
    }

    public String[] getStockSearchConditionNames() {
        return this.stockSearchConditionMap == null || this.stockSearchConditionMap.size() == 0 ? new String[]{} : this.stockSearchConditionMap.keySet().toArray(new String[this.stockSearchConditionMap.size()]);
    }

    public String getStockSearchCondition(String name) {
        if (this.stockSearchConditionMap == null) {
            return null;
        }
        Expression exp = (Expression)this.stockSearchConditionMap.get(name);
        return exp == null ? null : exp.getExpression();
    }

    public void removeStockSearchCondition(String name) {
        if (this.stockSearchConditionMap != null) {
            this.stockSearchConditionMap.remove(name);
        }
        if (this.stockSearchResultMap != null) {
            this.stockSearchResultMap.remove(name);
        }
    }

    public void clearStockSearchCondition() {
        if (this.stockSearchConditionMap != null) {
            this.stockSearchConditionMap.clear();
        }
        if (this.stockSearchResultMap != null) {
            this.stockSearchResultMap.clear();
        }
    }

    public Record primaryKeySearch(Record key) {
        Record[] records = this.stockKeySearch(PRIMARY_KEY_INDEX_NAME, key);
        return records == null || records.length == 0 ? null : records[0];
    }

    public Record[] stockKeySearch(String name, Record key) {
        if (this.stockSearchKeyResultMap == null || this.stockSearchKeyResultMap.size() == 0) {
            return new Record[0];
        }
        Map map = (Map)this.stockSearchKeyResultMap.get(name);
        if (map == null) {
            return new Record[0];
        }
        RecordKeyCondition condition = (RecordKeyCondition)this.stockSearchKeyMap.get(name);
        if (condition == null) {
            return new Record[0];
        }
        Object recKey = condition.createKey(key);
        if (recKey == null) {
            return new Record[0];
        }
        List values = (List)map.get(recKey);
        if (values == null) {
            return new Record[0];
        }
        return values.toArray(new Record[values.size()]);
    }

    public RecordList stockSearch(String name) {
        RecordList clone = this.cloneSchema();
        if (this.stockSearchResultMap == null || this.stockSearchResultMap.size() == 0) {
            return clone;
        }
        List values = (List)this.stockSearchResultMap.get(name);
        if (values == null) {
            return clone;
        }
        clone.addAll((Collection)values);
        return clone;
    }

    public void analyzeStockSearchCondition(String name) throws DataSetException {
        if (this.size() == 0 || this.stockSearchConditionMap == null || this.stockSearchConditionMap.size() == 0 || !this.stockSearchConditionMap.containsKey(name)) {
            return;
        }
        Expression exp = (Expression)this.stockSearchConditionMap.get(name);
        List<Record> values = (List<Record>)this.stockSearchResultMap.get(name);
        if (values == null) {
            values = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
            this.stockSearchResultMap.put(name, values);
        }
        values.clear();
        try {
            int jmax = this.records.size();
            for (int j = 0; j < jmax; ++j) {
                Record record = (Record)this.records.get(j);
                JexlContext context = JexlHelper.createContext();
                int imax = this.recordSchema.getPropertySize();
                for (int i = 0; i < imax; ++i) {
                    PropertySchema prop = this.recordSchema.getPropertySchema(i);
                    String propName = prop.getName();
                    context.getVars().put(propName, record.getProperty(propName));
                }
                Object ret = exp.evaluate(context);
                if (!(ret instanceof Boolean)) {
                    throw new DataSetException("Illegal condition : " + exp.getExpression());
                }
                boolean isMatch = (Boolean)ret;
                if (!isMatch) continue;
                values.add(record);
            }
        }
        catch (DataSetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
    }

    public void analyzeStockKey(String name) throws DataSetException {
        if (this.size() == 0 || this.stockSearchKeyMap == null || this.stockSearchKeyMap.size() == 0 || !this.stockSearchKeyMap.containsKey(name)) {
            return;
        }
        RecordKeyCondition condition = (RecordKeyCondition)this.stockSearchKeyMap.get(name);
        Map<Object, ArrayList<Record>> map = (Map<Object, ArrayList<Record>>)this.stockSearchKeyResultMap.get(name);
        if (map == null) {
            map = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
            this.stockSearchKeyResultMap.put(name, map);
        } else {
            map.clear();
        }
        boolean isPrimaryKeyIndex = PRIMARY_KEY_INDEX_NAME.equals(name);
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            Object key = condition.createKey(record);
            if (key == null) continue;
            ArrayList<Record> values = (ArrayList<Record>)map.get(key);
            if (values == null) {
                values = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
                map.put(key, values);
            }
            if (isPrimaryKeyIndex && values.size() != 0) {
                throw new DataSetException("Duplicate primary key. " + key);
            }
            values.add(record);
        }
    }

    protected void stockSearchResult(Record record) throws DataSetException {
        if (this.stockSearchConditionMap == null || this.stockSearchConditionMap.size() == 0) {
            return;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        try {
            for (Map.Entry entry : this.stockSearchConditionMap.entrySet()) {
                String name = (String)entry.getKey();
                Expression exp = (Expression)entry.getValue();
                JexlContext context = JexlHelper.createContext();
                int imax = this.recordSchema.getPropertySize();
                for (int i = 0; i < imax; ++i) {
                    PropertySchema prop = this.recordSchema.getPropertySchema(i);
                    String propName = prop.getName();
                    context.getVars().put(propName, record.getProperty(propName));
                }
                Object ret = exp.evaluate(context);
                if (!(ret instanceof Boolean)) {
                    throw new DataSetException("Illegal condition : " + exp.getExpression());
                }
                boolean isMatch = (Boolean)ret;
                if (!isMatch) continue;
                ArrayList<Record> values = (ArrayList<Record>)this.stockSearchResultMap.get(name);
                if (values == null) {
                    values = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
                    this.stockSearchResultMap.put(name, values);
                }
                values.add(record);
            }
        }
        catch (DataSetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
    }

    protected void removeStockSearchResult(Record record) throws DataSetException {
        if (this.stockSearchResultMap == null || this.stockSearchResultMap.size() == 0) {
            return;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        for (List list : this.stockSearchResultMap.values()) {
            list.remove(record);
        }
    }

    protected void stockSearchKeyResult(Record record) throws DataSetException {
        if (this.stockSearchKeyMap == null || this.stockSearchKeyMap.size() == 0) {
            return;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        for (Map.Entry entry : this.stockSearchKeyMap.entrySet()) {
            ArrayList<Record> values;
            String name = (String)entry.getKey();
            boolean isPrimaryKeyIndex = PRIMARY_KEY_INDEX_NAME.equals(name);
            RecordKeyCondition condition = (RecordKeyCondition)entry.getValue();
            Object key = condition.createKey(record);
            if (key == null) continue;
            Map<Object, ArrayList<Record>> map = (Map<Object, ArrayList<Record>>)this.stockSearchKeyResultMap.get(name);
            if (map == null) {
                map = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
                this.stockSearchKeyResultMap.put(name, map);
            }
            if ((values = (ArrayList<Record>)map.get(key)) == null) {
                values = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
                map.put(key, values);
            }
            if (isPrimaryKeyIndex && values.size() != 0) {
                throw new DataSetException("Duplicate primary key. " + key);
            }
            values.add(record);
        }
    }

    protected void removeStockSearchKeyResult(Record record) throws DataSetException {
        if (this.stockSearchKeyMap == null || this.stockSearchKeyMap.size() == 0) {
            return;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        for (Map.Entry entry : this.stockSearchKeyMap.entrySet()) {
            List values;
            Map map;
            String name = (String)entry.getKey();
            RecordKeyCondition condition = (RecordKeyCondition)entry.getValue();
            Object key = condition.createKey(record);
            if (key == null || (map = (Map)this.stockSearchKeyResultMap.get(name)) == null || (values = (List)map.get(key)) == null) continue;
            values.remove(record);
        }
    }

    public RecordList realSearch(String condition, Map valueMap) throws DataSetException {
        RecordList result = this.cloneSchema();
        if (this.size() == 0) {
            return result;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        try {
            Expression exp = ExpressionFactory.createExpression((String)condition);
            JexlContext context = JexlHelper.createContext();
            int imax = this.size();
            for (int i = 0; i < imax; ++i) {
                Boolean ret;
                Record rd = this.getRecord(i);
                int jmax = this.recordSchema.getPropertySize();
                for (int j = 0; j < jmax; ++j) {
                    PropertySchema prop = this.recordSchema.getPropertySchema(j);
                    String propName = prop.getName();
                    context.getVars().put(propName, rd.getProperty(propName));
                }
                if (valueMap != null) {
                    context.getVars().putAll(valueMap);
                }
                if ((ret = (Boolean)exp.evaluate(context)) == null || !ret.booleanValue()) continue;
                result.add(rd);
            }
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
        return result;
    }

    public void sort(String[] orderBy) {
        this.sort(orderBy, null);
    }

    public static void sort(Record[] records, String[] orderBy) {
        RecordList.sort(records, orderBy, null);
    }

    public void sort(int[] orderBy) {
        this.sort(orderBy, null);
    }

    public static void sort(Record[] records, int[] orderBy) {
        RecordList.sort(records, orderBy, null);
    }

    public void sort(int[] orderBy, boolean[] isAsc) {
        if (this.records.size() < 2) {
            return;
        }
        Collections.sort(this.records, new RecordComparator(this.recordSchema, orderBy, isAsc));
    }

    public static void sort(Record[] records, int[] orderBy, boolean[] isAsc) {
        if (records == null || records.length < 2) {
            return;
        }
        Arrays.sort(records, new RecordComparator(records[0].getRecordSchema(), orderBy, isAsc));
    }

    public void sort(String[] orderBy, boolean[] isAsc) {
        if (this.records.size() < 2) {
            return;
        }
        Collections.sort(this.records, new RecordComparator(orderBy, isAsc));
    }

    public static void sort(Record[] records, String[] orderBy, boolean[] isAsc) {
        if (records == null || records.length < 2) {
            return;
        }
        Arrays.sort(records, new RecordComparator(orderBy, isAsc));
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.records.contains(o);
    }

    @Override
    public Iterator iterator() {
        return new RecordIterator();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new RecordListIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.records.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.records.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.records.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Record)) {
            throw new DataSetException("Not record : " + o);
        }
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                return this.addInternal((Record)o);
            }
        }
        return this.addInternal((Record)o);
    }

    private boolean addInternal(Record rec) {
        rec.setIndex(this.size());
        rec.setRecordList(this);
        boolean isAdd = this.records.add(rec);
        try {
            this.stockSearchResult(rec);
            this.stockSearchKeyResult(rec);
        }
        catch (DataSetException e) {
            this.remove(rec.getIndex());
            throw e;
        }
        if (isAdd) {
            ++this.modCount;
        }
        return isAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof Record)) {
            throw new DataSetException("Not record : " + element);
        }
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                this.addInternal(index, (Record)element);
            }
        } else {
            this.addInternal(index, (Record)element);
        }
    }

    private void addInternal(int index, Record rec) {
        rec.setIndex(index);
        rec.setRecordList(this);
        this.records.add(index, rec);
        int imax = this.size();
        for (int i = index + 1; i < imax; ++i) {
            Record record = (Record)this.get(i);
            if (record == null) continue;
            record.setIndex(record.getIndex() + 1);
        }
        try {
            this.stockSearchResult(rec);
            this.stockSearchKeyResult(rec);
        }
        catch (DataSetException e) {
            this.remove(rec.getIndex());
            throw e;
        }
        ++this.modCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        if (element != null && !(element instanceof Record)) {
            throw new DataSetException("Not record : " + element);
        }
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                return this.setInternal(index, (Record)element);
            }
        }
        return this.setInternal(index, (Record)element);
    }

    private Object setInternal(int index, Record rec) {
        rec.setIndex(index);
        rec.setRecordList(this);
        Record old = this.records.set(index, rec);
        try {
            this.removeStockSearchResult(old);
            this.stockSearchResult(rec);
            this.removeStockSearchKeyResult(old);
            this.stockSearchKeyResult(rec);
        }
        catch (DataSetException e) {
            this.setInternal(index, old);
            throw e;
        }
        old.setIndex(-1);
        old.setRecordList(null);
        return old;
    }

    public Object get(int index) {
        return this.records.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.records.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.records.lastIndexOf(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                return this.removeInternal(o);
            }
        }
        return this.removeInternal(o);
    }

    private boolean removeInternal(Object o) {
        boolean isRemoved = this.records.remove(o);
        if (isRemoved) {
            this.removeStockSearchResult((Record)o);
            this.removeStockSearchKeyResult((Record)o);
            int oldIndex = ((Record)o).getIndex();
            ((Record)o).setIndex(-1);
            ((Record)o).setRecordList(null);
            int imax = this.size();
            for (int i = oldIndex; i < imax; ++i) {
                Record record = (Record)this.get(i);
                if (record == null) continue;
                record.setIndex(i);
            }
            ++this.modCount;
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                return this.removeInternal(index);
            }
        }
        return this.removeInternal(index);
    }

    private Object removeInternal(int index) {
        Object old = this.records.remove(index);
        if (old != null) {
            this.removeStockSearchResult((Record)old);
            this.removeStockSearchKeyResult((Record)old);
            ((Record)old).setIndex(-1);
            ((Record)old).setRecordList(null);
            int imax = this.size();
            for (int i = index; i < imax; ++i) {
                Record record = (Record)this.get(i);
                if (record == null) continue;
                record.setIndex(record.getIndex() - 1);
            }
            ++this.modCount;
        }
        return old;
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.records.containsAll(c);
    }

    @Override
    public boolean addAll(Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        Object[] vals = c.toArray();
        boolean result = false;
        for (int i = 0; i < vals.length; ++i) {
            result |= this.add(vals[i]);
        }
        if (result) {
            ++this.modCount;
        }
        return result;
    }

    public boolean addAll(int index, Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        Object[] vals = c.toArray();
        int i = vals.length;
        while (--i >= 0) {
            this.add(index, vals[i]);
        }
        ++this.modCount;
        return true;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean isRemoved = false;
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            isRemoved |= this.remove(itr.next());
        }
        if (isRemoved) {
            ++this.modCount;
        }
        return isRemoved;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean isRemoved = false;
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            Object record = itr.next();
            if (c.contains(record)) continue;
            itr.remove();
            isRemoved = true;
        }
        if (isRemoved) {
            ++this.modCount;
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                this.clearInternal();
            }
        } else {
            this.clearInternal();
        }
    }

    private void clearInternal() {
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.remove(0);
            if (record == null) continue;
            record.setIndex(-1);
            record.setRecordList(null);
        }
        if (this.stockSearchResultMap != null) {
            this.stockSearchResultMap.clear();
        }
        if (this.stockSearchKeyResultMap != null) {
            this.stockSearchKeyResultMap.clear();
        }
        ++this.modCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.util.Collections$SynchronizedCollection");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Object mutex = this.records;
        try {
            Field field = clazz.getDeclaredField("mutex");
            field.setAccessible(true);
            mutex = field.get(this.records);
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        ArrayList list = null;
        try {
            Field field = clazz.getDeclaredField("c");
            field.setAccessible(true);
            list = (ArrayList)field.get(this.records);
        }
        catch (IllegalAccessException e) {
            return;
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (SecurityException e) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            list.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() throws PropertyGetException, PropertyValidateException {
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                return this.validateInternal();
            }
        }
        return this.validateInternal();
    }

    private boolean validateInternal() throws PropertyGetException, PropertyValidateException {
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            if (record.validate()) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return this.cloneRecordList();
    }

    public RecordList cloneSchema() {
        RecordList clone = null;
        try {
            clone = (RecordList)super.clone();
            clone.modCount = 0;
            List list = clone.records = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
            if (this.stockSearchConditionMap != null && this.stockSearchConditionMap.size() != 0) {
                clone.stockSearchConditionMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
                clone.stockSearchConditionMap.putAll(this.stockSearchConditionMap);
            }
            if (this.stockSearchKeyMap != null && this.stockSearchKeyMap.size() != 0) {
                clone.stockSearchKeyMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
                clone.stockSearchKeyMap.putAll(this.stockSearchKeyMap);
            }
            if (this.partUpdateOrderBy != null) {
                clone.partUpdateOrderBy = new int[this.partUpdateOrderBy.length];
                System.arraycopy(this.partUpdateOrderBy, 0, clone.partUpdateOrderBy, 0, this.partUpdateOrderBy.length);
            }
            if (this.partUpdateIsAsc != null) {
                clone.partUpdateIsAsc = new boolean[this.partUpdateIsAsc.length];
                System.arraycopy(this.partUpdateIsAsc, 0, clone.partUpdateIsAsc, 0, this.partUpdateIsAsc.length);
            }
            if (clone.stockSearchResultMap != null) {
                Map map = clone.stockSearchResultMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
            }
            if (clone.stockSearchKeyResultMap != null) {
                clone.stockSearchKeyResultMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
            }
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordList cloneRecordList() {
        RecordList recList = this.cloneSchema();
        if (this.size() == 0) {
            return recList;
        }
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                for (int i = 0; i < this.records.size(); ++i) {
                    Record rec = ((Record)this.records.get(i)).cloneRecord();
                    recList.addRecord(rec);
                }
            }
        } else {
            for (int i = 0; i < this.records.size(); ++i) {
                Record rec = ((Record)this.records.get(i)).cloneRecord();
                recList.addRecord(rec);
            }
        }
        return recList;
    }

    public void setPartUpdateSort(String[] orderBy, boolean[] isAsc) {
        int[] propertyIndexes = new int[orderBy.length];
        for (int i = 0; i < orderBy.length; ++i) {
            propertyIndexes[i] = this.recordSchema.getPropertyIndex(orderBy[i]);
            if (propertyIndexes[i] != -1) continue;
            throw new DataSetException("No such property " + orderBy[i]);
        }
        this.setPartUpdateSort(propertyIndexes, isAsc);
    }

    public void setPartUpdateSort(int[] orderBy, boolean[] isAsc) {
        if (orderBy == null || orderBy.length == 0) {
            throw new DataSetException("Property index array is empty.");
        }
        if (isAsc != null && orderBy.length != isAsc.length) {
            throw new DataSetException("Length of property index array and sort flag array is unmatch.");
        }
        int fieldSize = this.recordSchema.getPropertySize();
        for (int i = 0; i < orderBy.length; ++i) {
            if (orderBy[i] < fieldSize) continue;
            throw new DataSetException("No such property " + orderBy[i]);
        }
        this.partUpdateOrderBy = orderBy;
        this.partUpdateIsAsc = isAsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartUpdateRecords createPartUpdateRecords(PartUpdateRecords records, int updateType, boolean containsValue) throws DataSetException {
        if (this.isSynchronized) {
            PartUpdateRecords partUpdateRecords = records;
            synchronized (partUpdateRecords) {
                return this.createPartUpdateRecordsInternal(records, updateType, containsValue);
            }
        }
        return this.createPartUpdateRecordsInternal(records, updateType, containsValue);
    }

    private PartUpdateRecords createPartUpdateRecordsInternal(PartUpdateRecords records, int updateType, boolean containsValue) throws DataSetException {
        if (records == null) {
            records = new PartUpdateRecords();
        }
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            CodeMasterUpdateKey key = record.createCodeMasterUpdateKey();
            key.setUpdateType(updateType);
            if (containsValue) {
                records.addRecord(key, record);
                continue;
            }
            records.addRecord(key);
        }
        return records;
    }

    public PartUpdateRecords fillPartUpdateRecords(CodeMasterUpdateKey key) {
        PartUpdateRecords records = new PartUpdateRecords();
        records.addRecord(key);
        return this.fillPartUpdateRecords(records);
    }

    public PartUpdateRecords fillPartUpdateRecords(PartUpdateRecords records) {
        if (records == null || records.size() == 0 || !records.containsAdd() && !records.containsUpdate()) {
            return records;
        }
        records.setFilledRecord(true);
        Record rec = this.createRecord();
        CodeMasterUpdateKey[] keys = records.getKeyArray();
        for (int i = 0; i < keys.length; ++i) {
            CodeMasterUpdateKey key = keys[i];
            int updateType = key.getUpdateType();
            records.removeRecord(key);
            rec.setCodeMasterUpdateKey(key);
            key = rec.createCodeMasterUpdateKey(key);
            key.setUpdateType(updateType);
            if (key.isRemove()) {
                records.addRecord(key);
                continue;
            }
            Record searchRec = this.primaryKeySearch(rec);
            records.addRecord(key, searchRec);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartUpdate cloneAndUpdate(PartUpdateRecords records) {
        if (this.isSynchronized) {
            PartUpdateRecords partUpdateRecords = records;
            synchronized (partUpdateRecords) {
                return this.cloneAndUpdateInternal(records);
            }
        }
        return this.cloneAndUpdateInternal(records);
    }

    private PartUpdate cloneAndUpdateInternal(PartUpdateRecords records) {
        RecordList newRecList = this.cloneSchema();
        CodeMasterUpdateKey tmpKey = new CodeMasterUpdateKey();
        CodeMasterUpdateKey key = null;
        int imax = this.records.size();
        block6: for (int i = 0; i < imax; ++i) {
            Record oldRecord = (Record)this.records.get(i);
            tmpKey = oldRecord.createCodeMasterUpdateKey(tmpKey);
            key = records == null ? null : records.getKey(tmpKey);
            Record newRecord = null;
            if (key == null) {
                newRecord = oldRecord.cloneRecord();
            } else {
                switch (key.getUpdateType()) {
                    case 1: 
                    case 2: {
                        newRecord = (Record)records.removeRecord(key);
                        break;
                    }
                    default: {
                        records.removeRecord(key);
                        continue block6;
                    }
                }
            }
            if (newRecord == null) continue;
            newRecList.addRecord(newRecord);
        }
        if (records != null && records.size() != 0) {
            for (Map.Entry entry : records.getRecords().entrySet()) {
                switch (((CodeMasterUpdateKey)entry.getKey()).getUpdateType()) {
                    case 1: 
                    case 2: {
                        Record record = (Record)entry.getValue();
                        if (record == null) break;
                        newRecList.addRecord(record);
                        break;
                    }
                }
            }
        }
        if (this.partUpdateOrderBy != null && this.partUpdateOrderBy.length != 0) {
            newRecList.sort(this.partUpdateOrderBy, this.partUpdateIsAsc);
        }
        return newRecList;
    }

    protected static void writeInt(ObjectOutput out, int val) throws IOException {
        if (val >= -128 && val <= 127) {
            out.writeByte(1);
            out.writeByte((byte)val);
        } else if (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
            out.writeByte(2);
            out.writeShort((short)val);
        } else {
            out.writeByte(3);
            out.writeInt(val);
        }
    }

    protected static int readInt(ObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                return in.readByte();
            }
            case 2: {
                return in.readShort();
            }
        }
        return in.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                this.writeExternalInternal(out);
            }
        } else {
            this.writeExternalInternal(out);
        }
    }

    private void writeExternalInternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.schema);
        out.writeObject(this.recordClass);
        out.writeBoolean(this.isSynchronized);
        if (this.stockSearchConditionMap == null || this.stockSearchConditionMap.size() == 0) {
            RecordList.writeInt(out, 0);
        } else {
            RecordList.writeInt(out, this.stockSearchConditionMap.size());
            for (Map.Entry entry : this.stockSearchConditionMap.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(((Expression)entry.getValue()).getExpression());
            }
        }
        if (this.stockSearchKeyMap == null || this.stockSearchKeyMap.size() == 0) {
            RecordList.writeInt(out, 0);
        } else {
            RecordList.writeInt(out, this.stockSearchKeyMap.size());
            for (Map.Entry entry : this.stockSearchKeyMap.entrySet()) {
                out.writeObject(entry.getKey());
                ((RecordKeyCondition)entry.getValue()).writeExternal(out);
            }
        }
        out.writeObject(this.partUpdateOrderBy);
        out.writeObject(this.partUpdateIsAsc);
        RecordList.writeInt(out, this.records.size());
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            record.writeExternalValues(out);
        }
        if (this.stockSearchConditionMap != null && this.stockSearchConditionMap.size() != 0) {
            Iterator entries = this.stockSearchResultMap.entrySet().iterator();
            RecordList.writeInt(out, this.stockSearchResultMap.size());
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                out.writeObject(entry.getKey());
                List recList = (List)entry.getValue();
                RecordList.writeInt(out, recList.size());
                for (int i = 0; i < recList.size(); ++i) {
                    RecordList.writeInt(out, ((Record)recList.get(i)).getIndex());
                }
            }
        }
        if (this.stockSearchKeyMap != null && this.stockSearchKeyMap.size() != 0) {
            Iterator entries = this.stockSearchKeyResultMap.entrySet().iterator();
            RecordList.writeInt(out, this.stockSearchKeyResultMap.size());
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                out.writeObject(entry.getKey());
                Map map = (Map)entry.getValue();
                RecordList.writeInt(out, map.size());
                for (Map.Entry ent : map.entrySet()) {
                    out.writeObject(ent.getKey());
                    List recList = (List)ent.getValue();
                    RecordList.writeInt(out, recList.size());
                    for (int i = 0; i < recList.size(); ++i) {
                        RecordList.writeInt(out, ((Record)recList.get(i)).getIndex());
                    }
                }
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int j;
        Object name;
        int i;
        int i2;
        int size;
        this.name = (String)in.readObject();
        this.schema = (String)in.readObject();
        this.recordClass = (Class)in.readObject();
        this.isSynchronized = in.readBoolean();
        if (this.schema != null) {
            this.recordSchema = RecordSchema.getInstance(this.schema);
        }
        if ((size = RecordList.readInt(in)) > 0) {
            this.stockSearchConditionMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
            try {
                for (i2 = 0; i2 < size; ++i2) {
                    this.stockSearchConditionMap.put(in.readObject(), ExpressionFactory.createExpression((String)((String)in.readObject())));
                }
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        if ((size = RecordList.readInt(in)) > 0) {
            this.stockSearchKeyMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
            for (i2 = 0; i2 < size; ++i2) {
                this.stockSearchKeyMap.put(in.readObject(), new RecordKeyCondition(in));
            }
        }
        this.partUpdateOrderBy = (int[])in.readObject();
        this.partUpdateIsAsc = (boolean[])in.readObject();
        int recSize = RecordList.readInt(in);
        List list = this.records = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
        if (this.recordSchema != null) {
            for (i = 0; i < recSize; ++i) {
                Record record = this.createRecord();
                record.readExternalValues(in);
                record.setIndex(i);
                record.setRecordList(this);
                this.records.add(record);
            }
        }
        if (this.stockSearchConditionMap != null) {
            this.stockSearchResultMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
            size = RecordList.readInt(in);
            for (i = 0; i < size; ++i) {
                name = in.readObject();
                List<Record> recList = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
                int listSize = RecordList.readInt(in);
                for (j = 0; j < listSize; ++j) {
                    int index = RecordList.readInt(in);
                    recList.add(this.getRecord(index));
                }
                this.stockSearchResultMap.put(name, recList);
            }
        }
        if (this.stockSearchKeyMap != null) {
            this.stockSearchKeyResultMap = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
            size = RecordList.readInt(in);
            for (i = 0; i < size; ++i) {
                name = in.readObject();
                int mapSize = RecordList.readInt(in);
                Map map = this.isSynchronized ? Collections.synchronizedMap(new HashMap()) : new HashMap();
                for (j = 0; j < mapSize; ++j) {
                    Object key = in.readObject();
                    List<Record> recList = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
                    int listSize = RecordList.readInt(in);
                    for (int k = 0; k < listSize; ++k) {
                        int index = RecordList.readInt(in);
                        recList.add(this.getRecord(index));
                    }
                    map.put(key, recList);
                }
                this.stockSearchKeyResultMap.put(name, map);
            }
        }
    }

    protected static class RecordKeyCondition
    implements Externalizable {
        private static final long serialVersionUID = 2501333319162543622L;
        protected String[] propertyNames;
        protected int[] propertyIndexes;

        public RecordKeyCondition(String[] names) {
            this.propertyNames = names;
        }

        public RecordKeyCondition(int[] indexes) {
            this.propertyIndexes = indexes;
        }

        public RecordKeyCondition(ObjectInput in) throws IOException, ClassNotFoundException {
            this.readExternal(in);
        }

        public Object createKey(Record record) {
            ArrayList<Object> key = null;
            if (this.propertyNames != null) {
                for (int i = 0; i < this.propertyNames.length; ++i) {
                    Object val = null;
                    try {
                        val = record.getProperty(this.propertyNames[i]);
                    }
                    catch (PropertyGetException e) {
                        key = null;
                        break;
                    }
                    if (key == null) {
                        key = new ArrayList<Object>();
                    }
                    key.add(val);
                }
                return key;
            }
            if (this.propertyIndexes != null) {
                for (int i = 0; i < this.propertyIndexes.length; ++i) {
                    Object val = null;
                    try {
                        val = record.getProperty(this.propertyIndexes[i]);
                    }
                    catch (PropertyGetException e) {
                        key = null;
                        break;
                    }
                    if (key == null) {
                        key = new ArrayList();
                    }
                    key.add(val);
                }
                return key;
            }
            return key;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            if (this.propertyNames != null) {
                out.writeByte(1);
                RecordList.writeInt(out, this.propertyNames.length);
                for (int i = 0; i < this.propertyNames.length; ++i) {
                    out.writeObject(this.propertyNames[i]);
                }
            } else if (this.propertyIndexes != null) {
                out.writeByte(2);
                RecordList.writeInt(out, this.propertyIndexes.length);
                for (int i = 0; i < this.propertyIndexes.length; ++i) {
                    RecordList.writeInt(out, this.propertyIndexes[i]);
                }
            } else {
                out.writeByte(0);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte type = in.readByte();
            int size = 0;
            switch (type) {
                case 1: {
                    size = RecordList.readInt(in);
                    this.propertyNames = new String[size];
                    for (int i = 0; i < size; ++i) {
                        this.propertyNames[i] = (String)in.readObject();
                    }
                    break;
                }
                case 2: {
                    size = RecordList.readInt(in);
                    this.propertyIndexes = new int[size];
                    for (int i = 0; i < size; ++i) {
                        this.propertyIndexes[i] = RecordList.readInt(in);
                    }
                    break;
                }
            }
        }
    }

    protected static class RecordComparator
    implements Comparator {
        private String[] propNames;
        private boolean[] isAsc;

        public RecordComparator(String[] propNames) {
            this(propNames, null);
        }

        public RecordComparator(String[] propNames, boolean[] isAsc) {
            if (propNames == null || propNames.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            if (isAsc != null && propNames.length != isAsc.length) {
                throw new IllegalArgumentException("Length of property index array and sort flag array is unmatch.");
            }
            this.propNames = propNames;
            this.isAsc = isAsc;
        }

        public RecordComparator(RecordSchema recordSchema, int[] propIndexes) {
            this(recordSchema, propIndexes, null);
        }

        public RecordComparator(RecordSchema recordSchema, int[] propIndexes, boolean[] isAsc) {
            if (recordSchema == null) {
                throw new IllegalArgumentException("Schema not initalize.");
            }
            if (propIndexes == null || propIndexes.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            if (isAsc != null && propIndexes.length != isAsc.length) {
                throw new IllegalArgumentException("Length of column name array and sort flag array is unmatch.");
            }
            this.propNames = new String[propIndexes.length];
            for (int i = 0; i < propIndexes.length; ++i) {
                this.propNames[i] = recordSchema.getPropertyName(propIndexes[i]);
                if (this.propNames != null) continue;
                throw new IllegalArgumentException("Property not found : " + propIndexes[i]);
            }
            if (this.propNames == null || this.propNames.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            this.isAsc = isAsc;
        }

        public int compare(Object o1, Object o2) {
            Record rd1 = (Record)o1;
            Record rd2 = (Record)o2;
            if (rd1 == null && rd2 == null) {
                return 0;
            }
            if (rd1 != null && rd2 == null) {
                return 1;
            }
            if (rd1 == null && rd2 != null) {
                return -1;
            }
            for (int i = 0; i < this.propNames.length; ++i) {
                Object val1 = rd1.getProperty(this.propNames[i]);
                Object val2 = rd2.getProperty(this.propNames[i]);
                if (val1 != null && val2 == null) {
                    return this.isAsc == null || this.isAsc[i] ? 1 : -1;
                }
                if (val1 == null && val2 != null) {
                    return this.isAsc == null || this.isAsc[i] ? -1 : 1;
                }
                if (val1 == null || val2 == null) continue;
                int comp = 0;
                comp = val1 instanceof Comparable ? ((Comparable)val1).compareTo(val2) : val1.hashCode() - val2.hashCode();
                if (comp == 0) continue;
                return this.isAsc == null || this.isAsc[i] ? comp : -1 * comp;
            }
            return 0;
        }
    }

    protected class RecordListIterator
    extends RecordIterator
    implements ListIterator {
        private static final long serialVersionUID = 1979810413080499078L;

        public RecordListIterator(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = RecordList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                RecordList.this.set(this.lastRet, o);
                this.expectedModCount = RecordList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object o) {
            this.checkForComodification();
            try {
                RecordList.this.add(this.cursor++, o);
                this.lastRet = -1;
                this.expectedModCount = RecordList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected class RecordIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = 200743372396432511L;
        protected int cursor = 0;
        protected int lastRet = -1;
        protected int expectedModCount;

        protected RecordIterator() {
            this.expectedModCount = RecordList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != RecordList.this.size();
        }

        public Object next() {
            this.checkForComodification();
            try {
                Object next = RecordList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                RecordList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = RecordList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (RecordList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

