/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.ossc.nimbus.beans.StringArrayEditor;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.NimbusEntityResolver;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DataSetCodeGenerator {
    private static final String USAGE_RESOURCE = "jp/ossc/nimbus/beans/dataset/DataSetCodeGeneratorUsage.txt";
    private DataSetsMetaData dataSetsData;
    private boolean isValidate = true;
    private String encoding;

    private DataSetCodeGenerator() {
    }

    public File[] generate(File definition, File outDir) {
        LinkedHashMap files = new LinkedHashMap();
        try {
            InputSource inputSource = new InputSource(new FileInputStream(definition));
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setValidating(this.isValidate);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            NimbusEntityResolver resolver = new NimbusEntityResolver();
            builder.setEntityResolver(resolver);
            MyErrorHandler handler = new MyErrorHandler();
            builder.setErrorHandler(handler);
            Document doc = builder.parse(inputSource);
            if (handler.isError()) {
                ServiceManagerFactory.getLogger().write("DSCG_00004", definition);
                return new File[0];
            }
            this.dataSetsData = new DataSetsMetaData();
            this.dataSetsData.importXML(doc.getDocumentElement());
            this.dataSetsData.generate(outDir, files);
            return files.values().toArray(new File[files.size()]);
        }
        catch (Exception e) {
            ServiceManagerFactory.getLogger().write("DSCG_00004", definition, (Throwable)e);
            return files.values().toArray(new File[files.size()]);
        }
    }

    private static String toArrayClassName(Class clazz) {
        Class<?> componentType = clazz.getComponentType();
        if (componentType == null) {
            return clazz.getName();
        }
        if (componentType.isPrimitive()) {
            if (Boolean.TYPE.equals(componentType)) {
                return "boolean[]";
            }
            if (Byte.TYPE.equals(componentType)) {
                return "byte[]";
            }
            if (Short.TYPE.equals(componentType)) {
                return "short[]";
            }
            if (Integer.TYPE.equals(componentType)) {
                return "int[]";
            }
            if (Long.TYPE.equals(componentType)) {
                return "long[]";
            }
            if (Float.TYPE.equals(componentType)) {
                return "float[]";
            }
            if (Double.TYPE.equals(componentType)) {
                return "double[]";
            }
            if (Character.TYPE.equals(componentType)) {
                return "char[]";
            }
            return componentType.getName() + "[]";
        }
        return componentType.getName() + "[]";
    }

    private static String toPrimitiveClassName(Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            return "boolean";
        }
        if (Byte.TYPE.equals(clazz)) {
            return "byte";
        }
        if (Short.TYPE.equals(clazz)) {
            return "short";
        }
        if (Integer.TYPE.equals(clazz)) {
            return "int";
        }
        if (Long.TYPE.equals(clazz)) {
            return "long";
        }
        if (Float.TYPE.equals(clazz)) {
            return "float";
        }
        if (Double.TYPE.equals(clazz)) {
            return "double";
        }
        if (Character.TYPE.equals(clazz)) {
            return "char";
        }
        return clazz.getName();
    }

    private static void usage() {
        try {
            System.out.println(DataSetCodeGenerator.getResourceString(USAGE_RESOURCE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceString(String name) throws IOException {
        InputStream is = DataSetCodeGenerator.class.getClassLoader().getResourceAsStream(name);
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = null;
        String separator = System.getProperty("line.separator");
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buf.append(line).append(separator);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return DataSetCodeGenerator.unicodeConvert(buf.toString());
    }

    private static String unicodeConvert(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c;
            if ((c = str.charAt(i++)) == '\\') {
                if ((c = str.charAt(i++)) == 'u') {
                    int value = 0;
                    block12: for (int j = 0; j < 4; ++j) {
                        c = str.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + (c - 48);
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + (c - 97);
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + (c - 65);
                                continue block12;
                            }
                            default: {
                                throw new IllegalArgumentException("Failed to convert unicode : " + c);
                            }
                        }
                    }
                    buf.append((char)value);
                    continue;
                }
                switch (c) {
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-help")) {
            DataSetCodeGenerator.usage();
            return;
        }
        boolean option = false;
        String key = null;
        File dest = new File(".");
        String encoding = null;
        boolean verbose = false;
        boolean validate = true;
        ArrayList<File> definitionFiles = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            if (option) {
                if (key.equals("-d")) {
                    dest = new File(args[i]);
                } else if (key.equals("-validate")) {
                    validate = Boolean.valueOf(args[i]);
                } else if (key.equals("-encoding")) {
                    encoding = args[i];
                }
                option = false;
                key = null;
                continue;
            }
            if (args[i].equals("-d")) {
                option = true;
                key = args[i];
                continue;
            }
            if (args[i].equals("-validate")) {
                option = true;
                key = args[i];
                continue;
            }
            if (args[i].equals("-encoding")) {
                option = true;
                key = args[i];
                continue;
            }
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            definitionFiles.add(new File(args[i]));
        }
        DataSetCodeGenerator generator = new DataSetCodeGenerator();
        generator.isValidate = validate;
        generator.encoding = encoding;
        for (int i = 0; i < definitionFiles.size(); ++i) {
            File[] files = generator.generate((File)definitionFiles.get(i), dest);
            if (!verbose) continue;
            for (int j = 0; j < files.length; ++j) {
                System.out.println(files[j]);
            }
        }
        Thread.sleep(500L);
    }

    static {
        NimbusEntityResolver.registerDTD("-//Nimbus//DTD Nimbus DataSet generation 1.0//JA", "jp/ossc/nimbus/beans/dataset/dataset_1_0.dtd");
    }

    private static class Utility
    extends jp.ossc.nimbus.core.Utility {
        private static final String CREATE_METHOD_PREFIX = "create";
        private static final String GET_METHOD_PREFIX = "get";
        private static final String SET_METHOD_PREFIX = "set";

        private Utility() {
        }

        public static String replaceProperty(DataSetsMetaData metaData, String str) {
            PropertyMetaData propData;
            String result = str;
            if ((result = Utility.replaceSystemProperty(result)) == null || metaData.properties == null) {
                return result;
            }
            int startIndex = result.indexOf("${");
            if (startIndex == -1) {
                return result;
            }
            int endIndex = result.indexOf("}");
            if (endIndex == -1 || startIndex > endIndex) {
                return result;
            }
            String propStr = result.substring(startIndex + "${".length(), endIndex);
            String prop = null;
            if (propStr != null && propStr.length() != 0 && (propData = (PropertyMetaData)metaData.properties.get(propStr)) != null) {
                prop = propData.getValue();
            }
            if (prop == null) {
                return result.substring(0, endIndex + "}".length()) + Utility.replaceProperty(metaData, result.substring(endIndex + "}".length()));
            }
            if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + "}".length())).indexOf("${") != -1) {
                return Utility.replaceProperty(metaData, result);
            }
            return result;
        }

        public static String escapeLineSeparator(String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            if (str.indexOf("\r\n") != -1) {
                str = str.replaceAll("\r\n", "\\\\n");
            }
            if (str.indexOf("\n") != -1) {
                str = str.replaceAll("\n", "\\\\n");
            }
            if (str.indexOf("\r") != -1) {
                str = str.replaceAll("\r", "\\\\n");
            }
            return str;
        }

        public static String createCreaterName(String property) {
            StringBuffer result = new StringBuffer(property);
            int len = result.length();
            if (len != 0 && !Character.isUpperCase(result.charAt(0))) {
                char capital = Character.toUpperCase(result.charAt(0));
                result.deleteCharAt(0).insert(0, capital);
            }
            return result.insert(0, CREATE_METHOD_PREFIX).toString();
        }

        public static String createGetterName(String property) {
            StringBuffer result = new StringBuffer(property);
            int len = result.length();
            if (len != 0 && !Character.isUpperCase(result.charAt(0))) {
                char capital = Character.toUpperCase(result.charAt(0));
                result.deleteCharAt(0).insert(0, capital);
            }
            return result.insert(0, GET_METHOD_PREFIX).toString();
        }

        public static String createSetterName(String property) {
            StringBuffer result = new StringBuffer(property);
            int len = result.length();
            if (len != 0 && !Character.isUpperCase(result.charAt(0))) {
                char capital = Character.toUpperCase(result.charAt(0));
                result.deleteCharAt(0).insert(0, capital);
            }
            return result.insert(0, SET_METHOD_PREFIX).toString();
        }
    }

    private class DataSetMetaData
    extends MetaData
    implements CodeGenerator {
        private static final long serialVersionUID = 6664682114622861929L;
        public static final String TAG_NAME = "dataSet";
        public static final String ATTRIBUTE_NAME_CODE = "code";
        public static final String ATTRIBUTE_NAME_NAME = "name";
        public static final String ATTRIBUTE_NAME_EXTENDS = "extends";
        public static final String ATTRIBUTE_NAME_ABSTRACT = "abstract";
        public static final String ATTRIBUTE_NAME_SYNCHRONIZED = "synchronized";
        public String packageName;
        public String className;
        public String name;
        public String superClass;
        public boolean isAbstract;
        public Map headers;
        public Map recordLists;
        public Map nestedRecords;
        public Map nestedRecordLists;
        public boolean isSynchronized;

        public DataSetMetaData(MetaData parent) {
            super(parent);
            this.superClass = DataSet.class.getName();
            this.isSynchronized = true;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            String code;
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("Root tag must be dataSet : " + element.getTagName());
            }
            this.className = code = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, DataSetMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_CODE));
            if (code.indexOf(46) != -1) {
                this.className = code.substring(code.lastIndexOf(46) + 1);
                this.packageName = code.substring(0, code.lastIndexOf(46));
            }
            this.superClass = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, DataSetMetaData.getOptionalAttribute(element, ATTRIBUTE_NAME_EXTENDS, this.superClass));
            this.isAbstract = DataSetMetaData.getOptionalBooleanAttribute(element, ATTRIBUTE_NAME_ABSTRACT);
            this.name = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, DataSetMetaData.getOptionalAttribute(element, ATTRIBUTE_NAME_NAME));
            this.isSynchronized = DataSetMetaData.getOptionalBooleanAttribute(element, ATTRIBUTE_NAME_SYNCHRONIZED);
            Iterator headerElements = DataSetMetaData.getChildrenByTagName(element, "header");
            while (headerElements.hasNext()) {
                if (this.headers == null) {
                    this.headers = new LinkedHashMap();
                }
                HeaderMetaData headerData = new HeaderMetaData(this);
                headerData.importXML((Element)headerElements.next());
                if (this.headers.containsKey(headerData.name)) {
                    throw new DeploymentException("Header is duplicated : " + headerData.name);
                }
                this.headers.put(headerData.name, headerData);
            }
            Iterator recordListElements = DataSetMetaData.getChildrenByTagName(element, "recordList");
            while (recordListElements.hasNext()) {
                if (this.recordLists == null) {
                    this.recordLists = new LinkedHashMap();
                }
                RecordListMetaData recordListData = new RecordListMetaData(this);
                recordListData.importXML((Element)recordListElements.next());
                if (this.recordLists.containsKey(recordListData.name)) {
                    throw new DeploymentException("RecordList is duplicated : " + recordListData.name);
                }
                this.recordLists.put(recordListData.name, recordListData);
            }
            Iterator nestedRecordElements = DataSetMetaData.getChildrenByTagName(element, "nestedRecord");
            while (nestedRecordElements.hasNext()) {
                if (this.nestedRecords == null) {
                    this.nestedRecords = new LinkedHashMap();
                }
                NestedRecordMetaData nestedRecordData = new NestedRecordMetaData(this);
                nestedRecordData.importXML((Element)nestedRecordElements.next());
                if (this.nestedRecords.containsKey(nestedRecordData.name)) {
                    throw new DeploymentException("NestedRecord is duplicated : " + nestedRecordData.name);
                }
                this.nestedRecords.put(nestedRecordData.name, nestedRecordData);
            }
            Iterator nestedRecordListElements = DataSetMetaData.getChildrenByTagName(element, "nestedRecordList");
            while (nestedRecordListElements.hasNext()) {
                if (this.nestedRecordLists == null) {
                    this.nestedRecordLists = new LinkedHashMap();
                }
                NestedRecordListMetaData nestedRecordListData = new NestedRecordListMetaData(this);
                nestedRecordListData.importXML((Element)nestedRecordListElements.next());
                if (this.nestedRecordLists.containsKey(nestedRecordListData.name)) {
                    throw new DeploymentException("NestedRecordList is duplicated : " + nestedRecordListData.name);
                }
                this.nestedRecordLists.put(nestedRecordListData.name, nestedRecordListData);
            }
        }

        @Override
        public File getFile(File dir) {
            String filePath = null;
            filePath = this.packageName == null ? this.className + ".java" : this.packageName.replaceAll("\\.", "/") + '/' + this.className + ".java";
            return new File(dir, filePath);
        }

        @Override
        public void writeCode(PrintWriter pw) {
            if (this.packageName != null) {
                pw.println("package " + this.packageName + ';');
            }
            pw.println();
            pw.print("public ");
            if (this.isAbstract) {
                pw.print("abstract ");
            }
            pw.println("class " + this.className + " extends " + this.superClass + "{");
            pw.println("    ");
            if (this.headers != null) {
                for (String name : this.headers.keySet()) {
                    pw.println("    public static final String HEADER_" + name.toUpperCase() + " = \"" + name + "\";");
                }
            }
            if (this.recordLists != null) {
                for (String name : this.recordLists.keySet()) {
                    pw.println("    public static final String RECORD_LIST_" + name.toUpperCase() + " = \"" + name + "\";");
                }
            }
            if (this.nestedRecords != null) {
                for (String name : this.nestedRecords.keySet()) {
                    pw.println("    public static final String NESTED_RECORD_" + name.toUpperCase() + " = \"" + name + "\";");
                }
            }
            if (this.nestedRecordLists != null) {
                for (String name : this.nestedRecordLists.keySet()) {
                    pw.println("    public static final String NESTED_RECORD_LIST_" + name.toUpperCase() + " = \"" + name + "\";");
                }
            }
            pw.println("    public " + this.className + "(){");
            pw.println("        super(\"" + this.name + "\", " + this.isSynchronized + ");");
            if (this.headers != null) {
                for (HeaderMetaData headerData : this.headers.values()) {
                    if (headerData.schema != null) {
                        String tmpSchema = headerData.schema;
                        headerData.schema = null;
                        headerData.writeCode(pw);
                        headerData.schema = tmpSchema;
                        continue;
                    }
                    headerData.writeCode(pw);
                }
            }
            if (this.recordLists != null) {
                for (RecordListMetaData recordListData : this.recordLists.values()) {
                    if (recordListData.recordClassName != null) {
                        String tmpRecordCode = recordListData.recordClassName;
                        recordListData.recordClassName = null;
                        recordListData.writeCode(pw);
                        recordListData.recordClassName = tmpRecordCode;
                        continue;
                    }
                    recordListData.writeCode(pw);
                }
            }
            if (this.nestedRecords != null) {
                for (NestedRecordMetaData nestedRecordData : this.nestedRecords.values()) {
                    nestedRecordData.writeCode(pw);
                }
            }
            if (this.nestedRecordLists != null) {
                for (NestedRecordListMetaData nestedRecordListData : this.nestedRecordLists.values()) {
                    nestedRecordListData.writeCode(pw);
                }
            }
            pw.println("    }");
            if (this.headers != null) {
                for (HeaderMetaData headerData : this.headers.values()) {
                    if (headerData.name == null) continue;
                    pw.println("    public " + headerData.getFullClassName() + " " + Utility.createGetterName(headerData.name + "Header") + "(){");
                    pw.println("        return (" + headerData.getFullClassName() + ")getHeader(HEADER_" + headerData.name.toUpperCase() + ");");
                    pw.println("    }");
                }
            }
            if (this.recordLists != null) {
                for (RecordListMetaData recordListData : this.recordLists.values()) {
                    if (recordListData.name == null) continue;
                    pw.println("    public " + recordListData.getFullClassName() + " " + Utility.createGetterName(recordListData.name + "RecordList") + "(){");
                    pw.println("        return (" + recordListData.getFullClassName() + ")getRecordList(RECORD_LIST_" + recordListData.name.toUpperCase() + ");");
                    pw.println("    }");
                }
            }
            if (this.nestedRecords != null) {
                for (NestedRecordMetaData nestedRecordData : this.nestedRecords.values()) {
                    pw.println("    public " + nestedRecordData.code + " " + Utility.createCreaterName(nestedRecordData.name + "NestedRecord") + "(){");
                    pw.println("        return (" + nestedRecordData.code + ")createNestedRecord(NESTED_RECORD_" + nestedRecordData.name.toUpperCase() + ");");
                    pw.println("    }");
                }
            }
            if (this.nestedRecordLists != null) {
                for (NestedRecordListMetaData nestedRecordListData : this.nestedRecordLists.values()) {
                    pw.println("    public " + nestedRecordListData.code + " " + Utility.createCreaterName(nestedRecordListData.name + "NestedRecordList") + "(){");
                    pw.println("        return (" + nestedRecordListData.code + ")createNestedRecordList(NESTED_RECORD_LIST_" + nestedRecordListData.name.toUpperCase() + ");");
                    pw.println("    }");
                }
            }
            pw.println("}");
        }
    }

    private class NestedRecordMetaData
    extends MetaData
    implements CodeGenerator {
        private static final long serialVersionUID = 5542852046600369680L;
        public static final String TAG_NAME = "nestedRecord";
        public static final String ATTRIBUTE_NAME_CODE = "code";
        public static final String ATTRIBUTE_NAME_NAME = "name";
        public String name;
        public String code;

        public NestedRecordMetaData(MetaData parent) {
            super(parent);
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("Root tag must be nestedRecord : " + element.getTagName());
            }
            this.code = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, NestedRecordMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_CODE));
            this.name = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, NestedRecordMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_NAME));
        }

        @Override
        public File getFile(File dir) {
            return null;
        }

        @Override
        public void writeCode(PrintWriter pw) {
            pw.println("        setNestedRecordClass(\"" + this.name + "\", " + this.code + ".class);");
        }
    }

    private class NestedRecordListMetaData
    extends MetaData
    implements CodeGenerator {
        private static final long serialVersionUID = -547306924656306470L;
        public static final String TAG_NAME = "nestedRecordList";
        public static final String ATTRIBUTE_NAME_CODE = "code";
        public static final String ATTRIBUTE_NAME_NAME = "name";
        public String name;
        public String code;

        public NestedRecordListMetaData(MetaData parent) {
            super(parent);
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("Root tag must be nestedRecordList : " + element.getTagName());
            }
            this.code = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, NestedRecordListMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_CODE));
            this.name = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, NestedRecordListMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_NAME));
        }

        @Override
        public File getFile(File dir) {
            return null;
        }

        @Override
        public void writeCode(PrintWriter pw) {
            pw.println("        setNestedRecordListClass(\"" + this.name + "\", " + this.code + ".class);");
        }
    }

    private class RecordListMetaData
    extends MetaData
    implements CodeGenerator {
        private static final long serialVersionUID = 8369293626987943298L;
        public static final String TAG_NAME = "recordList";
        public static final String TAG_NAME_STOCK_KEY = "stockKey";
        public static final String TAG_NAME_STOCK_CONDITION = "stockCondition";
        public static final String ATTRIBUTE_NAME_CODE = "code";
        public static final String ATTRIBUTE_NAME_EXTENDS = "extends";
        public static final String ATTRIBUTE_NAME_ABSTRACT = "abstract";
        public static final String ATTRIBUTE_NAME_RECORD_CODE = "recordCode";
        public static final String ATTRIBUTE_NAME_NAME = "name";
        public static final String ATTRIBUTE_NAME_SYNCHRONIZED = "synchronized";
        public String name;
        public String packageName;
        public String className;
        public String superClass;
        public boolean isAbstract;
        public String recordPackageName;
        public String recordClassName;
        public Map stockKeyMap;
        public Map stockConditionMap;
        public boolean isSynchronized;

        public RecordListMetaData(MetaData parent) {
            super(parent);
            this.superClass = RecordList.class.getName();
            this.isSynchronized = true;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            String recordCode;
            String code;
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("Root tag must be recordList : " + element.getTagName());
            }
            this.className = code = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, RecordListMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_CODE));
            if (code.indexOf(46) != -1) {
                this.className = code.substring(code.lastIndexOf(46) + 1);
                this.packageName = code.substring(0, code.lastIndexOf(46));
            }
            this.recordClassName = recordCode = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, this.getParent() instanceof DataSetsMetaData ? RecordListMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_RECORD_CODE) : RecordListMetaData.getOptionalAttribute(element, ATTRIBUTE_NAME_RECORD_CODE));
            if (recordCode != null && recordCode.indexOf(46) != -1) {
                this.recordClassName = recordCode.substring(recordCode.lastIndexOf(46) + 1);
                this.recordPackageName = recordCode.substring(0, recordCode.lastIndexOf(46));
            }
            this.superClass = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, RecordListMetaData.getOptionalAttribute(element, ATTRIBUTE_NAME_EXTENDS, this.superClass));
            this.isAbstract = RecordListMetaData.getOptionalBooleanAttribute(element, ATTRIBUTE_NAME_ABSTRACT);
            this.name = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, RecordListMetaData.getOptionalAttribute(element, ATTRIBUTE_NAME_NAME));
            this.isSynchronized = RecordListMetaData.getOptionalBooleanAttribute(element, ATTRIBUTE_NAME_SYNCHRONIZED);
            Iterator stockKeyElements = RecordListMetaData.getChildrenByTagName(element, TAG_NAME_STOCK_KEY);
            while (stockKeyElements.hasNext()) {
                Element stockKeyElement;
                if (this.stockKeyMap == null) {
                    this.stockKeyMap = new HashMap();
                }
                if ((stockKeyElement = (Element)stockKeyElements.next()) == null) continue;
                String stockKeyName = RecordListMetaData.getUniqueAttribute(stockKeyElement, ATTRIBUTE_NAME_NAME);
                String stockKeyStr = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, RecordListMetaData.getElementContent(stockKeyElement));
                StringArrayEditor editor = new StringArrayEditor();
                editor.setAsText(stockKeyStr);
                String[] stockKey = (String[])editor.getValue();
                this.stockKeyMap.put(stockKeyName, stockKey);
            }
            Iterator stockConditionElements = RecordListMetaData.getChildrenByTagName(element, TAG_NAME_STOCK_CONDITION);
            while (stockConditionElements.hasNext()) {
                Element stockConditionElement;
                if (this.stockConditionMap == null) {
                    this.stockConditionMap = new HashMap();
                }
                if ((stockConditionElement = (Element)stockConditionElements.next()) == null) continue;
                String stockConditionName = RecordListMetaData.getUniqueAttribute(stockConditionElement, ATTRIBUTE_NAME_NAME);
                String stockCondition = Utility.escapeLineSeparator(Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, RecordListMetaData.getElementContent(stockConditionElement)));
                this.stockConditionMap.put(stockConditionName, stockCondition);
            }
        }

        @Override
        public File getFile(File dir) {
            String filePath = null;
            filePath = this.packageName == null ? this.className + ".java" : this.packageName.replaceAll("\\.", "/") + '/' + this.className + ".java";
            return new File(dir, filePath);
        }

        public String getFullClassName() {
            return this.packageName == null ? this.className : this.packageName + '.' + this.className;
        }

        public String getFullRecordClassName() {
            return this.recordPackageName == null ? this.recordClassName : this.recordPackageName + '.' + this.recordClassName;
        }

        @Override
        public void writeCode(PrintWriter pw) {
            if (this.recordClassName == null) {
                pw.println("        setRecordListClass(\"" + this.name + "\", " + this.getFullClassName() + ".class);");
            } else {
                if (this.packageName != null) {
                    pw.println("package " + this.packageName + ';');
                }
                pw.println();
                pw.print("public ");
                if (this.isAbstract) {
                    pw.print("abstract ");
                }
                pw.println("class " + this.className + " extends " + this.superClass + "{");
                pw.println("    public " + this.className + "(){");
                pw.println("        this(\"" + this.name + "\");");
                pw.println("    }");
                pw.println("    ");
                pw.println("    public " + this.className + "(String name){");
                pw.println("        super(name, " + this.getFullRecordClassName() + ".class" + ", " + this.isSynchronized + ");");
                if (this.stockKeyMap != null) {
                    for (Map.Entry entry : this.stockKeyMap.entrySet()) {
                        pw.print("        setStockKeySearch(\"" + entry.getKey() + "\", new String[]{");
                        String[] props = (String[])entry.getValue();
                        int imax = props.length;
                        for (int i = 0; i < imax; ++i) {
                            pw.print(props[i] == null ? "null" : '\"' + props[i] + '\"');
                            if (i == imax - 1) continue;
                            pw.print(", ");
                        }
                        pw.println("});");
                    }
                }
                if (this.stockConditionMap != null) {
                    for (Map.Entry entry : this.stockConditionMap.entrySet()) {
                        pw.println("        setStockSearchCondition(\"" + entry.getKey() + "\", " + (entry.getValue() == null ? "null)" : '\"' + (String)entry.getValue() + "\")"));
                    }
                }
                pw.println("    }");
                pw.println("    ");
                pw.println("    public " + this.getFullRecordClassName() + ' ' + Utility.createCreaterName(this.recordClassName) + "(){");
                pw.println("        return (" + this.getFullRecordClassName() + ")createRecord();");
                pw.println("    }");
                pw.println("}");
            }
        }
    }

    private class HeaderMetaData
    extends MetaData
    implements CodeGenerator {
        private static final long serialVersionUID = 7980846939747068932L;
        public static final String TAG_NAME = "header";
        public static final String TAG_NAME_SCHEMA = "schema";
        public static final String ATTRIBUTE_NAME_CODE = "code";
        public static final String ATTRIBUTE_NAME_EXTENDS = "extends";
        public static final String ATTRIBUTE_NAME_ABSTRACT = "abstract";
        public static final String ATTRIBUTE_NAME_NAME = "name";
        public static final String ATTRIBUTE_NAME_TYPE = "type";
        public String name;
        public String packageName;
        public String className;
        public String superClass;
        public boolean isAbstract;
        public String schema;
        public String schemaType;

        public HeaderMetaData(MetaData parent) {
            super(parent);
            this.superClass = Header.class.getName();
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            Element schemaElement;
            String code;
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("Root tag must be header : " + element.getTagName());
            }
            this.className = code = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, HeaderMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_CODE));
            if (code.indexOf(46) != -1) {
                this.className = code.substring(code.lastIndexOf(46) + 1);
                this.packageName = code.substring(0, code.lastIndexOf(46));
            }
            this.superClass = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, HeaderMetaData.getOptionalAttribute(element, ATTRIBUTE_NAME_EXTENDS, this.superClass));
            this.isAbstract = HeaderMetaData.getOptionalBooleanAttribute(element, ATTRIBUTE_NAME_ABSTRACT);
            this.name = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, HeaderMetaData.getOptionalAttribute(element, ATTRIBUTE_NAME_NAME));
            Element element2 = schemaElement = this.getParent() instanceof DataSetsMetaData ? HeaderMetaData.getUniqueChild(element, TAG_NAME_SCHEMA) : HeaderMetaData.getOptionalChild(element, TAG_NAME_SCHEMA);
            if (schemaElement != null) {
                this.schema = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, HeaderMetaData.getElementContent(schemaElement));
                this.schemaType = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, HeaderMetaData.getOptionalAttribute(schemaElement, ATTRIBUTE_NAME_TYPE, "set"));
            }
        }

        @Override
        public File getFile(File dir) {
            String filePath = null;
            filePath = this.packageName == null ? this.className + ".java" : this.packageName.replaceAll("\\.", "/") + '/' + this.className + ".java";
            return new File(dir, filePath);
        }

        public String getFullClassName() {
            return this.packageName == null ? this.className : this.packageName + '.' + this.className;
        }

        @Override
        public void writeCode(PrintWriter pw) {
            if (this.schema == null) {
                pw.println("        setHeaderClass(\"" + this.name + "\", " + this.getFullClassName() + ".class);");
            } else {
                int i;
                if (this.packageName != null) {
                    pw.println("package " + this.packageName + ';');
                }
                pw.println();
                pw.print("public ");
                if (this.isAbstract) {
                    pw.print("abstract ");
                }
                pw.println("class " + this.className + " extends " + this.superClass + "{");
                RecordSchema recordSchema = RecordSchema.getInstance(this.schema);
                for (i = 0; i < recordSchema.getPropertySize(); ++i) {
                    PropertySchema propSchema = recordSchema.getPropertySchema(i);
                    pw.println("    public static final String " + propSchema.getName().toUpperCase() + " = \"" + propSchema.getName() + "\";");
                    pw.println("    public static final int " + propSchema.getName().toUpperCase() + "_INDEX = " + i + ";");
                }
                pw.println("    ");
                pw.println("    public " + this.className + "(){");
                if ("set".equals(this.schemaType)) {
                    pw.println("        super(\"" + this.name + "\", \"" + Utility.escapeLineSeparator(this.schema) + "\");");
                } else if ("replace".equals(this.schemaType)) {
                    if (this.name != null) {
                        pw.println("        setName(\"" + this.name + "\");");
                    }
                    pw.println("        replaceSchema(\"" + Utility.escapeLineSeparator(this.schema) + "\");");
                } else if ("append".equals(this.schemaType)) {
                    if (this.name != null) {
                        pw.println("        setName(\"" + this.name + "\");");
                    }
                    pw.println("        appendSchema(\"" + Utility.escapeLineSeparator(this.schema) + "\");");
                }
                pw.println("    }");
                pw.println("    ");
                pw.println("    public " + this.className + "(String name){");
                if ("set".equals(this.schemaType)) {
                    pw.println("        super(name, \"" + Utility.escapeLineSeparator(this.schema) + "\");");
                } else if ("replace".equals(this.schemaType)) {
                    pw.println("        setName(name);");
                    pw.println("        replaceSchema(\"" + Utility.escapeLineSeparator(this.schema) + "\");");
                } else if ("append".equals(this.schemaType)) {
                    pw.println("        setName(name);");
                    pw.println("        appendSchema(\"" + Utility.escapeLineSeparator(this.schema) + "\");");
                }
                pw.println("    }");
                pw.println("    ");
                int imax = recordSchema.getPropertySize();
                for (i = 0; i < imax; ++i) {
                    PropertySchema propSchema = recordSchema.getPropertySchema(i);
                    if (propSchema.getType().isPrimitive()) {
                        pw.println("    public " + DataSetCodeGenerator.toPrimitiveClassName(propSchema.getType()) + " " + Utility.createGetterName(propSchema.getName()) + "(){");
                        if (Boolean.TYPE.equals(propSchema.getType())) {
                            pw.println("        return getBooleanProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                        } else if (Byte.TYPE.equals(propSchema.getType())) {
                            pw.println("        return getByteProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                        } else if (Short.TYPE.equals(propSchema.getType())) {
                            pw.println("        return getShortProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                        } else if (Integer.TYPE.equals(propSchema.getType())) {
                            pw.println("        return getIntProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                        } else if (Long.TYPE.equals(propSchema.getType())) {
                            pw.println("        return getLongProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                        } else if (Float.TYPE.equals(propSchema.getType())) {
                            pw.println("        return getFloatProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                        } else if (Double.TYPE.equals(propSchema.getType())) {
                            pw.println("        return getDoubleProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                        } else if (Character.TYPE.equals(propSchema.getType())) {
                            pw.println("        Character c = ((Character)getProperty(" + propSchema.getName().toUpperCase() + "_INDEX));");
                            pw.println("        return c == null ? (char)0 : c.charValue();");
                        }
                    } else if (propSchema.getType().isArray()) {
                        pw.println("    public " + DataSetCodeGenerator.toArrayClassName(propSchema.getType()) + " " + Utility.createGetterName(propSchema.getName()) + "(){");
                        pw.println("        return (" + DataSetCodeGenerator.toArrayClassName(propSchema.getType()) + ")getProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                    } else {
                        pw.println("    public " + propSchema.getType().getName() + " " + Utility.createGetterName(propSchema.getName()) + "(){");
                        pw.println("        return (" + propSchema.getType().getName() + ")getProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                    }
                    pw.println("    }");
                    pw.println("    ");
                    if (propSchema.getType().isPrimitive()) {
                        pw.println("    public void " + Utility.createSetterName(propSchema.getName()) + "(" + DataSetCodeGenerator.toPrimitiveClassName(propSchema.getType()) + " val){");
                    } else if (propSchema.getType().isArray()) {
                        pw.println("    public void " + Utility.createSetterName(propSchema.getName()) + "(" + DataSetCodeGenerator.toArrayClassName(propSchema.getType()) + " val){");
                    } else {
                        pw.println("    public void " + Utility.createSetterName(propSchema.getName()) + "(" + propSchema.getType().getName() + " val){");
                    }
                    pw.println("        setProperty(" + propSchema.getName().toUpperCase() + "_INDEX, val);");
                    pw.println("    }");
                    pw.println("    ");
                }
                pw.println("}");
            }
        }
    }

    private class RecordMetaData
    extends MetaData
    implements CodeGenerator {
        private static final long serialVersionUID = 5515496152289298757L;
        public static final String TAG_NAME = "record";
        public static final String TAG_NAME_SCHEMA = "schema";
        public static final String ATTRIBUTE_NAME_CODE = "code";
        public static final String ATTRIBUTE_NAME_EXTENDS = "extends";
        public static final String ATTRIBUTE_NAME_ABSTRACT = "abstract";
        public static final String ATTRIBUTE_NAME_TYPE = "type";
        public String packageName;
        public String className;
        public String superClass;
        public boolean isAbstract;
        public String schema;
        public String schemaType;

        public RecordMetaData(MetaData parent) {
            super(parent);
            this.superClass = Record.class.getName();
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            String code;
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("Root tag must be record : " + element.getTagName());
            }
            this.className = code = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, RecordMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_CODE));
            if (code.indexOf(46) != -1) {
                this.className = code.substring(code.lastIndexOf(46) + 1);
                this.packageName = code.substring(0, code.lastIndexOf(46));
            }
            this.superClass = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, RecordMetaData.getOptionalAttribute(element, ATTRIBUTE_NAME_EXTENDS, this.superClass));
            this.isAbstract = RecordMetaData.getOptionalBooleanAttribute(element, ATTRIBUTE_NAME_ABSTRACT);
            Element schemaElement = RecordMetaData.getUniqueChild(element, TAG_NAME_SCHEMA);
            this.schema = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, RecordMetaData.getElementContent(schemaElement));
            this.schemaType = Utility.replaceProperty(DataSetCodeGenerator.this.dataSetsData, RecordMetaData.getOptionalAttribute(schemaElement, ATTRIBUTE_NAME_TYPE, "set"));
        }

        @Override
        public File getFile(File dir) {
            String filePath = null;
            filePath = this.packageName == null ? this.className + ".java" : this.packageName.replaceAll("\\.", "/") + '/' + this.className + ".java";
            return new File(dir, filePath);
        }

        @Override
        public void writeCode(PrintWriter pw) {
            int i;
            if (this.packageName != null) {
                pw.println("package " + this.packageName + ';');
            }
            pw.println();
            pw.print("public ");
            if (this.isAbstract) {
                pw.print("abstract ");
            }
            pw.println("class " + this.className + " extends " + this.superClass + "{");
            RecordSchema recordSchema = RecordSchema.getInstance(this.schema);
            for (i = 0; i < recordSchema.getPropertySize(); ++i) {
                PropertySchema propSchema = recordSchema.getPropertySchema(i);
                pw.println("    public static final String " + propSchema.getName().toUpperCase() + " = \"" + propSchema.getName() + "\";");
                pw.println("    public static final int " + propSchema.getName().toUpperCase() + "_INDEX = " + i + ";");
            }
            pw.println("    ");
            pw.println("    public " + this.className + "(){");
            if ("set".equals(this.schemaType)) {
                pw.println("        super(\"" + Utility.escapeLineSeparator(this.schema) + "\");");
            } else if ("replace".equals(this.schemaType)) {
                pw.println("        replaceSchema(\"" + Utility.escapeLineSeparator(this.schema) + "\");");
            } else if ("append".equals(this.schemaType)) {
                pw.println("        appendSchema(\"" + Utility.escapeLineSeparator(this.schema) + "\");");
            }
            pw.println("    }");
            pw.println("    ");
            int imax = recordSchema.getPropertySize();
            for (i = 0; i < imax; ++i) {
                PropertySchema propSchema = recordSchema.getPropertySchema(i);
                if (propSchema.getType().isPrimitive()) {
                    pw.println("    public " + DataSetCodeGenerator.toPrimitiveClassName(propSchema.getType()) + " " + Utility.createGetterName(propSchema.getName()) + "(){");
                    if (Boolean.TYPE.equals(propSchema.getType())) {
                        pw.println("        return getBooleanProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                    } else if (Byte.TYPE.equals(propSchema.getType())) {
                        pw.println("        return getByteProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                    } else if (Short.TYPE.equals(propSchema.getType())) {
                        pw.println("        return getShortProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                    } else if (Integer.TYPE.equals(propSchema.getType())) {
                        pw.println("        return getIntProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                    } else if (Long.TYPE.equals(propSchema.getType())) {
                        pw.println("        return getLongProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                    } else if (Float.TYPE.equals(propSchema.getType())) {
                        pw.println("        return getFloatProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                    } else if (Double.TYPE.equals(propSchema.getType())) {
                        pw.println("        return getDoubleProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                    } else if (Character.TYPE.equals(propSchema.getType())) {
                        pw.println("        Character c = ((Character)getProperty(" + propSchema.getName().toUpperCase() + "_INDEX));");
                        pw.println("        return c == null ? (char)0 : c.charValue();");
                    }
                } else if (propSchema.getType().isArray()) {
                    pw.println("    public " + DataSetCodeGenerator.toArrayClassName(propSchema.getType()) + " " + Utility.createGetterName(propSchema.getName()) + "(){");
                    pw.println("        return (" + DataSetCodeGenerator.toArrayClassName(propSchema.getType()) + ")getProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                } else {
                    pw.println("    public " + propSchema.getType().getName() + " " + Utility.createGetterName(propSchema.getName()) + "(){");
                    pw.println("        return (" + propSchema.getType().getName() + ")getProperty(" + propSchema.getName().toUpperCase() + "_INDEX);");
                }
                pw.println("    }");
                pw.println("    ");
                if (propSchema.getType().isPrimitive()) {
                    pw.println("    public void " + Utility.createSetterName(propSchema.getName()) + "(" + DataSetCodeGenerator.toPrimitiveClassName(propSchema.getType()) + " val){");
                } else if (propSchema.getType().isArray()) {
                    pw.println("    public void " + Utility.createSetterName(propSchema.getName()) + "(" + DataSetCodeGenerator.toArrayClassName(propSchema.getType()) + " val){");
                } else {
                    pw.println("    public void " + Utility.createSetterName(propSchema.getName()) + "(" + propSchema.getType().getName() + " val){");
                }
                pw.println("        setProperty(" + propSchema.getName().toUpperCase() + "_INDEX, val);");
                pw.println("    }");
                pw.println("    ");
            }
            pw.println("}");
        }
    }

    private static interface CodeGenerator {
        public File getFile(File var1);

        public void writeCode(PrintWriter var1);
    }

    private class PropertyMetaData
    extends jp.ossc.nimbus.core.PropertyMetaData {
        private static final long serialVersionUID = 7835225760732994370L;
        public static final String TAG_NAME = "property";

        public PropertyMetaData(MetaData parent) {
            super(parent);
        }

        @Override
        protected String getTagName() {
            return TAG_NAME;
        }
    }

    private class DataSetsMetaData
    extends MetaData {
        private static final long serialVersionUID = 3876649968668319651L;
        public static final String TAG_NAME = "dataSets";
        public Map properties;
        public List records;
        public List headers;
        public List recordLists;
        public List dataSets;

        @Override
        public void importXML(Element element) throws DeploymentException {
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("Root tag must be dataSets : " + element.getTagName());
            }
            Iterator propertyElements = DataSetsMetaData.getChildrenByTagName(element, "property");
            while (propertyElements.hasNext()) {
                if (this.properties == null) {
                    this.properties = new LinkedHashMap();
                }
                PropertyMetaData propertyData = new PropertyMetaData(this);
                propertyData.importXML((Element)propertyElements.next());
                if (this.properties.containsKey(propertyData.getName())) {
                    throw new DeploymentException("Property is duplicated : " + propertyData.getName());
                }
                this.properties.put(propertyData.getName(), propertyData);
            }
            Iterator recordElements = DataSetsMetaData.getChildrenByTagName(element, "record");
            while (recordElements.hasNext()) {
                if (this.records == null) {
                    this.records = new ArrayList();
                }
                RecordMetaData recordData = new RecordMetaData(this);
                recordData.importXML((Element)recordElements.next());
                this.records.add(recordData);
            }
            Iterator headerElements = DataSetsMetaData.getChildrenByTagName(element, "header");
            while (headerElements.hasNext()) {
                if (this.headers == null) {
                    this.headers = new ArrayList();
                }
                HeaderMetaData headerData = new HeaderMetaData(this);
                headerData.importXML((Element)headerElements.next());
                this.headers.add(headerData);
            }
            Iterator recordListElements = DataSetsMetaData.getChildrenByTagName(element, "recordList");
            while (recordListElements.hasNext()) {
                if (this.recordLists == null) {
                    this.recordLists = new ArrayList();
                }
                RecordListMetaData recordListData = new RecordListMetaData(this);
                recordListData.importXML((Element)recordListElements.next());
                this.recordLists.add(recordListData);
            }
            Iterator dataSetElements = DataSetsMetaData.getChildrenByTagName(element, "dataSet");
            while (dataSetElements.hasNext()) {
                if (this.dataSets == null) {
                    this.dataSets = new ArrayList();
                }
                DataSetMetaData dataSetData = new DataSetMetaData(this);
                dataSetData.importXML((Element)dataSetElements.next());
                this.dataSets.add(dataSetData);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeCode(File file, CodeGenerator generator, Map files) throws Exception {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (files.containsKey(file)) {
                ServiceManagerFactory.getLogger().write("DSCG_00005", file);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            generator.writeCode(pw);
            pw.flush();
            String source = sw.toString();
            try (FileOutputStream fos = new FileOutputStream(file);){
                OutputStreamWriter osw = DataSetCodeGenerator.this.encoding == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, DataSetCodeGenerator.this.encoding);
                osw.write(source, 0, source.length());
                osw.flush();
            }
            files.put(file, file);
        }

        public void generate(File outDir, Map files) throws Exception {
            File file;
            MetaData data;
            int i;
            if (this.records != null) {
                for (i = 0; i < this.records.size(); ++i) {
                    data = (RecordMetaData)this.records.get(i);
                    file = ((RecordMetaData)data).getFile(outDir);
                    this.writeCode(file, (CodeGenerator)((Object)data), files);
                }
            }
            if (this.headers != null) {
                for (i = 0; i < this.headers.size(); ++i) {
                    data = (HeaderMetaData)this.headers.get(i);
                    file = ((HeaderMetaData)data).getFile(outDir);
                    this.writeCode(file, (CodeGenerator)((Object)data), files);
                }
            }
            if (this.recordLists != null) {
                for (i = 0; i < this.recordLists.size(); ++i) {
                    data = (RecordListMetaData)this.recordLists.get(i);
                    file = ((RecordListMetaData)data).getFile(outDir);
                    this.writeCode(file, (CodeGenerator)((Object)data), files);
                }
            }
            if (this.dataSets != null) {
                for (i = 0; i < this.dataSets.size(); ++i) {
                    data = (DataSetMetaData)this.dataSets.get(i);
                    file = ((DataSetMetaData)data).getFile(outDir);
                    this.writeCode(file, (CodeGenerator)((Object)data), files);
                    if (((DataSetMetaData)data).headers != null) {
                        for (HeaderMetaData headerData : ((DataSetMetaData)data).headers.values()) {
                            if (headerData.schema == null) continue;
                            file = headerData.getFile(outDir);
                            this.writeCode(file, headerData, files);
                        }
                    }
                    if (((DataSetMetaData)data).recordLists == null) continue;
                    for (RecordListMetaData recordListData : ((DataSetMetaData)data).recordLists.values()) {
                        if (recordListData.recordClassName == null) continue;
                        file = recordListData.getFile(outDir);
                        this.writeCode(file, recordListData, files);
                    }
                }
            }
        }
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private boolean isError;

        private MyErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            ServiceManagerFactory.getLogger().write("DSCG_00001", (Object)e.getMessage());
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.isError = true;
            ServiceManagerFactory.getLogger().write("DSCG_00002", (Object)e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.isError = true;
            ServiceManagerFactory.getLogger().write("DSCG_00003", (Object)e.getMessage());
        }

        public boolean isError() {
            return this.isError;
        }
    }
}

