/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import jp.ossc.nimbus.beans.Utility;

public class ShortEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -6292923961921734360L;

    @Override
    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        this.setValue(new Short(ShortEditor.toShort(text, true)));
    }

    public static final short toShort(String text, boolean replace) throws NumberFormatException {
        String str = replace ? Utility.replaceSystemProperty(text) : text;
        int shortValue = 0;
        try {
            shortValue = Short.parseShort(str);
        }
        catch (NumberFormatException e) {
            if ("MAX_VALUE".equals(str)) {
                shortValue = Short.MAX_VALUE;
            }
            if ("MIN_VALUE".equals(str)) {
                shortValue = Short.MIN_VALUE;
            }
            int index = str.lastIndexOf(".");
            if (index > 0 && index != str.length() - 1) {
                String className = str.substring(0, index);
                String fieldName = str.substring(index + 1);
                try {
                    Class clazz = Utility.convertStringToClass(className);
                    shortValue = clazz.getField(fieldName).getShort(null);
                }
                catch (ClassNotFoundException e2) {
                    throw e;
                }
                catch (NoSuchFieldException e2) {
                    throw e;
                }
                catch (SecurityException e2) {
                    throw e;
                }
                catch (IllegalArgumentException e2) {
                    throw e;
                }
                catch (IllegalAccessException e2) {
                    throw e;
                }
            }
            throw e;
        }
        return (short)shortValue;
    }

    @Override
    public String getAsText() {
        Short val = (Short)this.getValue();
        return val == null ? null : val.toString();
    }
}

