/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;

public class PropertyAccess {
    private boolean isIgnoreNullProperty = false;
    private Map propertyCache = Collections.synchronizedMap(new HashMap());
    private static PropertyAccess instance;
    private static PropertyAccess instanceForIgnoreNullProperty;

    public static synchronized PropertyAccess getInstance(boolean isIgnoreNullProperty) {
        if (isIgnoreNullProperty) {
            if (instance == null) {
                instance = new PropertyAccess(){

                    @Override
                    public void setIgnoreNullProperty(boolean isIgnore) {
                    }
                };
            }
            return instance;
        }
        if (instanceForIgnoreNullProperty == null) {
            instanceForIgnoreNullProperty = new PropertyAccess(){

                @Override
                public void setIgnoreNullProperty(boolean isIgnore) {
                }
            };
            PropertyAccess.instanceForIgnoreNullProperty.isIgnoreNullProperty = true;
        }
        return instanceForIgnoreNullProperty;
    }

    public void setIgnoreNullProperty(boolean isIgnore) {
        if (this == instance || this == instanceForIgnoreNullProperty) {
            return;
        }
        this.isIgnoreNullProperty = isIgnore;
    }

    public boolean isIgnoreNullProperty() {
        return this.isIgnoreNullProperty;
    }

    public Object get(Object target, String prop) throws IllegalArgumentException, NoSuchPropertyException, InvocationTargetException {
        return this.getProperty(prop).getProperty(target);
    }

    public void set(Object target, String prop, Object value) throws IllegalArgumentException, NoSuchPropertyException, InvocationTargetException {
        this.getProperty(prop).setProperty(target, value);
    }

    public Property getProperty(String prop) throws IllegalArgumentException {
        Property property = (Property)this.propertyCache.get(prop);
        if (property == null) {
            property = PropertyFactory.createProperty(prop);
            property.setIgnoreNullProperty(this.isIgnoreNullProperty);
            Property exists = this.propertyCache.put(prop, property);
            if (exists != null) {
                property = exists;
            }
        }
        return property;
    }

    public void clear() {
        this.propertyCache.clear();
    }
}

