/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import jp.ossc.nimbus.beans.Utility;

public class PropertiesEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -8656653312703767785L;
    private static final String EMPTY = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        String tmpText = Utility.replaceSystemProperty(Utility.xmlComentOut(text));
        int length = tmpText.length();
        if (tmpText == null || length == 0) {
            this.setValue(new Properties());
            return;
        }
        if (tmpText.indexOf("\\u") != -1) {
            tmpText = Utility.unicodeConvert(tmpText);
        }
        StringReader sr = new StringReader(tmpText);
        BufferedReader br = new BufferedReader(sr, length);
        Properties result = new Properties();
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                int index = (line = Utility.trim(line)).indexOf(61);
                if (index == -1) continue;
                String name = line.substring(0, index);
                String value = null;
                value = index == line.length() - 1 ? EMPTY : line.substring(index + 1);
                result.setProperty(name, value);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sr.close();
        }
        this.setValue(result);
    }

    @Override
    public String getAsText() {
        Properties prop = (Properties)this.getValue();
        if (prop == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        Enumeration<?> names = prop.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            writer.print(name);
            writer.print('=');
            writer.print(prop.getProperty(name));
            if (!names.hasMoreElements()) continue;
            writer.println();
        }
        return sw.toString();
    }
}

