/*
 * Created on 2006/11/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.preference;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

import netwatcher.ssh2.model.JSchControl;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;

public class SSH2PreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	private static String DSA = "DSA";

	private static String RSA = "RSA";

	private Label targetLabel;

	private Label userNameLabel;

	private Label hostLabel;

	private Label passwordLabel;

	private Label passphraseLabel;

	private Text targetText;

	private Text userNameText;

	private Text hostText;

	private Text passwordText;

	private Text passphraseText;

	private Button userAuthSaveButton;

	private Button keyGenerateDSA;

	private Button keyGenerateRSA;

	private Button keyLoad;

	private Button saveKeyPair;

	private Label keyCommentLabel;

	private Text keyCommentText;

	private Label keyFingerPrintLabel;

	private Text keyFingerPrintText;

	private Label keyPassphrase1Label;

	private Text keyPassphrase1Text;

	private Label keyPassphrase2Label;

	private Text keyPassphrase2Text;

	private Label publicKeylabel;

	private Text publicKeyText;

	private KeyPair kpair = null;

	private String kpairComment;

	private TableViewer viewer;

	private Button removeHostKeyButton;

	private JSch jsch;

	public SSH2PreferencePage() {
		jsch = JSchControl.getInstance().getJsch();
		setDescription("Configuration options for SSH2:");

	}

	protected Control createContents(Composite parent) {

		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);

		TabFolder tabFolder = new TabFolder(container, SWT.NONE);
		tabFolder.setLayoutData(new GridData(GridData.FILL_BOTH));

		TabItem tabItem = new TabItem(tabFolder, SWT.NONE);
		tabItem.setText("&Key Management");
		tabItem.setControl(createKeyManagementPage(tabFolder));

		tabItem = new TabItem(tabFolder, SWT.NONE);
		tabItem.setText("Kno&wnHosts");
		tabItem.setControl(createHostKeyManagementPage(tabFolder));

		tabItem = new TabItem(tabFolder, SWT.NONE);
		tabItem.setText("&User Auth");
		tabItem.setControl(createUserAuthManagementPage(tabFolder));

		initControls();

		Dialog.applyDialogFont(parent);
		return container;
	}

	private Control createUserAuthManagementPage(Composite parent) {
		int columnSpan = 3;
		Composite group = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		group.setLayout(layout);
		GridData gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		group.setLayoutData(gd);

		userNameLabel = new Label(group, SWT.NONE);
		userNameLabel.setText("user");
		gd = new GridData();
		gd.horizontalSpan = 1;
		userNameLabel.setLayoutData(gd);

		userNameText = new Text(group, SWT.SINGLE | SWT.BORDER);
		userNameText.setText("");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		userNameText.setLayoutData(gd);

		hostLabel = new Label(group, SWT.NONE);
		hostLabel.setText("host");
		gd = new GridData();
		gd.horizontalSpan = 1;
		hostLabel.setLayoutData(gd);

		hostText = new Text(group, SWT.SINGLE | SWT.BORDER);
		hostText.setText("");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		hostText.setLayoutData(gd);

		targetLabel = new Label(group, SWT.NONE);
		targetLabel.setText("user@host");
		gd = new GridData();
		gd.horizontalSpan = 1;
		targetLabel.setLayoutData(gd);

		targetText = new Text(group, SWT.SINGLE | SWT.BORDER);
		targetText.setText("");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		targetText.setLayoutData(gd);
		targetText.setText("@");
		targetText.setEnabled(false);

		passwordLabel = new Label(group, SWT.NONE);
		passwordLabel.setText("password");
		gd = new GridData();
		gd.horizontalSpan = 1;
		passwordLabel.setLayoutData(gd);

		passwordText = new Text(group, SWT.SINGLE | SWT.BORDER);
		passwordText.setText("");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		passwordText.setLayoutData(gd);

		passphraseLabel = new Label(group, SWT.NONE);
		passphraseLabel.setText("passphrase");
		gd = new GridData();
		gd.horizontalSpan = 1;
		passphraseLabel.setLayoutData(gd);

		passphraseText = new Text(group, SWT.SINGLE | SWT.BORDER);
		passphraseText.setText("");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		passphraseText.setLayoutData(gd);

		userAuthSaveButton = new Button(group, SWT.NULL);
		userAuthSaveButton.setText("Save");
		gd = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		gd.horizontalSpan = 1;
		userAuthSaveButton.setLayoutData(gd);
		userAuthSaveButton.setEnabled(false);
		userNameText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				String user = userNameText.getText();
				String host = hostText.getText();

				targetText.setText(user + "@" + host);
				userAuthSaveButton.setEnabled(true);
			}
		});

		hostText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				String user = userNameText.getText();
				String host = hostText.getText();

				targetText.setText(user + "@" + host);
			}
		});

		userAuthSaveButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				String target = targetText.getText();
				String password = passwordText.getText();
				String passphrase = passphraseText.getText();
				String home = SSH2Preference.RESOURCE_SSH2_DIR + "/" + target;

				File _home = new File(home);

				if (!_home.exists()) {
					if (!MessageDialog
							.openConfirm(getShell(), "Confirmation",
									" does not exsit.\nAre you sure you want to create it?")) {
						return;
					}
					if (!_home.mkdirs()) {
						setErrorMessage("Failed to create " + home);
						return;
					}
				}
				String filePath = home + "/" + SSH2Preference.USER_HOST_AUTH;
				SSH2UserAuthManagerOutputControl.getInstance()
						.saveResourceXMLInfo(filePath, target, password,
								passphrase);
			}
		});

		return group;
	}

	/*
	 * Key Management Page TabItem𐶐܂B
	 * 
	 * @param parent @return Control
	 */
	private Control createKeyManagementPage(Composite parent) {
		int columnSpan = 3;
		Composite group = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		group.setLayout(layout);
		GridData gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		group.setLayoutData(gd);

		keyGenerateDSA = new Button(group, SWT.NULL);
		keyGenerateDSA.setText("G&enerate DSA key...");

		gd = new GridData();
		gd.horizontalSpan = 1;
		keyGenerateDSA.setLayoutData(gd);

		keyGenerateRSA = new Button(group, SWT.NULL);
		keyGenerateRSA.setText("Ge&nerate RSA key...");

		gd = new GridData();
		gd.horizontalSpan = 1;
		keyGenerateRSA.setLayoutData(gd);

		keyLoad = new Button(group, SWT.NULL);
		keyLoad.setText("&Load existing key...");

		gd = new GridData();
		gd.horizontalSpan = 1;
		keyLoad.setLayoutData(gd);

		publicKeylabel = new Label(group, SWT.NONE);
		publicKeylabel
				.setText("&You can paste this public key into the remote authorized_keys file:");

		gd = new GridData();
		gd.horizontalSpan = columnSpan;
		publicKeylabel.setLayoutData(gd);

		publicKeyText = new Text(group, SWT.MULTI | SWT.BORDER | SWT.V_SCROLL
				| SWT.WRAP);
		publicKeyText.setText("");
		publicKeyText.setEditable(false);
		gd = new GridData();
		gd.horizontalSpan = columnSpan;
		gd.horizontalAlignment = GridData.FILL;
		gd.verticalAlignment = GridData.FILL;
		gd.grabExcessHorizontalSpace = true;
		gd.grabExcessVerticalSpace = true;
		publicKeyText.setLayoutData(gd);

		keyFingerPrintLabel = new Label(group, SWT.NONE);
		keyFingerPrintLabel.setText("&Fingerprint:");

		keyFingerPrintText = new Text(group, SWT.SINGLE | SWT.BORDER);
		keyFingerPrintText.setFont(group.getFont());
		keyFingerPrintText.setEditable(false);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		keyFingerPrintText.setLayoutData(gd);

		keyCommentLabel = new Label(group, SWT.NONE);
		keyCommentLabel.setText("&Comment:");

		keyCommentText = new Text(group, SWT.SINGLE | SWT.BORDER);
		keyCommentText.setFont(group.getFont());
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		keyCommentText.setLayoutData(gd);

		keyCommentText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (kpair == null)
					return;
				try {
					ByteArrayOutputStream out = new ByteArrayOutputStream();
					kpair.writePublicKey(out, keyCommentText.getText());
					out.close();
					publicKeyText.setText(out.toString());
				} catch (IOException ee) {
				}
			}
		});

		keyPassphrase1Label = new Label(group, SWT.NONE);
		keyPassphrase1Label.setText("Passp&hrase:");

		keyPassphrase1Text = new Text(group, SWT.SINGLE | SWT.BORDER);
		keyPassphrase1Text.setFont(group.getFont());
		keyPassphrase1Text.setEchoChar('*');
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		keyPassphrase1Text.setLayoutData(gd);

		keyPassphrase2Label = new Label(group, SWT.NONE);
		keyPassphrase2Label.setText("C&onfirm passphrase:");

		keyPassphrase2Text = new Text(group, SWT.SINGLE | SWT.BORDER);
		keyPassphrase2Text.setFont(group.getFont());
		keyPassphrase2Text.setEchoChar('*');
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		keyPassphrase2Text.setLayoutData(gd);

		keyPassphrase1Text.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				String pass1 = keyPassphrase1Text.getText();
				String pass2 = keyPassphrase2Text.getText();
				if (kpair != null && pass1.equals(pass2)) {
					saveKeyPair.setEnabled(true);
				} else {
					saveKeyPair.setEnabled(false);
				}
				if (pass2.length() == 0) {
					setErrorMessage(null);
					return;
				}
				if (pass1.equals(pass2)) {
					setErrorMessage(null);
				} else {
					setErrorMessage("The passphrases entered do not match.");
				}
			}
		});

		keyPassphrase2Text.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				String pass1 = keyPassphrase1Text.getText();
				String pass2 = keyPassphrase2Text.getText();
				if (kpair != null && pass1.equals(pass2)) {
					saveKeyPair.setEnabled(true);
				} else {
					saveKeyPair.setEnabled(false);
				}
				if (pass2.length() < pass1.length()) {
					if (pass1.startsWith(pass2)) {
						setErrorMessage(null);
					} else {
						setErrorMessage("The passphrases entered do not match.");
					}
					return;
				}
				if (pass1.equals(pass2)) {
					setErrorMessage(null);
				} else {
					setErrorMessage("The passphrases entered do not match.");
				}
			}
		});

		keyPassphrase2Text.addFocusListener(new FocusListener() {
			public void focusGained(FocusEvent e) {
				String pass1 = keyPassphrase1Text.getText();
				String pass2 = keyPassphrase2Text.getText();
				if (pass2.length() < pass1.length()) {
					if (pass1.startsWith(pass2)) {
						setErrorMessage(null);
					} else {
						setErrorMessage("The passphrases entered do not match.");
					}
					return;
				}
				if (pass1.equals(pass2)) {
					setErrorMessage(null);
				} else {
					setErrorMessage("The passphrases entered do not match.");
				}
			}

			public void focusLost(FocusEvent e) {
				String pass1 = keyPassphrase1Text.getText();
				String pass2 = keyPassphrase2Text.getText();
				if (pass1.equals(pass2)) {
					setErrorMessage(null);
				} else {
					setErrorMessage("The passphrases entered do not match.");
				}
			}
		});

		saveKeyPair = new Button(group, SWT.NULL);
		saveKeyPair.setText("&Save Private Key...");

		gd = new GridData(GridData.HORIZONTAL_ALIGN_END);
		gd.horizontalSpan = columnSpan;
		saveKeyPair.setLayoutData(gd);

		SelectionAdapter keygenadapter = new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				boolean ok = true;
				String _type = "";

				try {
					int type = 0;
					if (e.widget == keyGenerateDSA) {
						type = KeyPair.DSA;
						_type = DSA;
					} else if (e.widget == keyGenerateRSA) {
						type = KeyPair.RSA;
						_type = RSA;
					} else {
						return;
					}

					final KeyPair[] _kpair = new KeyPair[1];
					final JSch _jsch = jsch;
					final int __type = type;
					final JSchException[] _e = new JSchException[1];
					BusyIndicator.showWhile(getShell().getDisplay(),
							new Runnable() {
								public void run() {
									try {
										_kpair[0] = KeyPair.genKeyPair(_jsch,
												__type);
									} catch (JSchException e) {
										_e[0] = e;
									}
								}
							});
					if (_e[0] != null) {
						throw _e[0];
					}
					kpair = _kpair[0];

					ByteArrayOutputStream out = new ByteArrayOutputStream();
					kpairComment = _type + "-1024";
					kpair.writePublicKey(out, kpairComment);
					out.close();
					publicKeyText.setText(out.toString());
					keyFingerPrintText.setText(kpair.getFingerPrint());
					keyCommentText.setText(kpairComment);
					keyPassphrase1Text.setText("");
					keyPassphrase2Text.setText("");
					updateControls();
				} catch (IOException ee) {
					ok = false;
				} catch (JSchException ee) {
					ok = false;
				}
				if (!ok) {
					MessageDialog.openError(getShell(), "Error",
							"The key was not generated.");
				}

			}
		};
		keyGenerateDSA.addSelectionListener(keygenadapter);
		keyGenerateRSA.addSelectionListener(keygenadapter);

		keyLoad.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				boolean ok = true;
				String home = SSH2Preference.RESOURCE_SSH2_DIR;
				FileDialog fd = new FileDialog(getShell(), SWT.OPEN);
				fd.setFilterPath(home);
				Object o = fd.open();
				if (o == null) { // cancel
					return;
				}
				String pkey = fd.getFileName();
				String pkeyab = (new File(fd.getFilterPath(), pkey))
						.getAbsolutePath();
				try {

					KeyPair _kpair = KeyPair.load(jsch, pkeyab);
					PassphrasePrompt prompt = null;
					while (_kpair.isEncrypted()) {
						if (prompt == null) {
							prompt = new PassphrasePrompt(
									"Enter passphrase for " + pkey);
						}
						Display.getDefault().syncExec(prompt);
						String passphrase = prompt.getPassphrase();
						if (passphrase == null)
							break;
						if (_kpair.decrypt(passphrase)) {
							break;
						}
						MessageDialog.openError(getShell(), "Error",
								"failed to decrypt " + pkey);
					}
					if (_kpair.isEncrypted()) {
						return;
					}
					kpair = _kpair;
					String _type = (kpair.getKeyType() == KeyPair.DSA) ? DSA
							: RSA;
					ByteArrayOutputStream out = new ByteArrayOutputStream();
					kpairComment = _type + "-1024";
					kpair.writePublicKey(out, kpairComment);
					out.close();
					publicKeyText.setText(out.toString());
					keyFingerPrintText.setText(kpair.getFingerPrint());
					keyCommentText.setText(kpairComment);
					keyPassphrase1Text.setText("");
					keyPassphrase2Text.setText("");
					updateControls();
				} catch (IOException ee) {
					ok = false;
				} catch (JSchException ee) {
					ok = false;
				}
				if (!ok) {
					MessageDialog.openError(getShell(), "Error",
							"failed to load given file.");
				}

			}
		});

		saveKeyPair.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (kpair == null)
					return;

				String pass = keyPassphrase1Text.getText();

				if (!pass.equals(keyPassphrase2Text.getText())) {
					MessageDialog.openError(getShell(), "Error",
							"The passphrases entered do not match.");
					// setErrorMessage("The passphrases entered do not match.");
					return;
				}

				if (pass.length() == 0) {

					if (!MessageDialog
							.openConfirm(
									getShell(),
									"Confirmation",
									"Are you sure you want to save this private key without the passpharse protection?")) {
						return;
					}

				}

				kpair.setPassphrase(pass);

				final String[] target = new String[1];
				final String title = "Save ssh key.";
				final String message = "Specify a target dir(in user@host format) where your public key should be saved.\nYour key will be stored in user@host";

				Display.getDefault().syncExec(new Runnable() {
					public void run() {
						Display display = Display.getCurrent();
						Shell shell = new Shell(display);
						ExportDialog dialog = new ExportDialog(shell, title,
								message);
						dialog.open();
						shell.dispose();
						target[0] = dialog.getTarget();
					}
				});
				if (target[0] == null) {
					return;
				}
				String user = "";
				String host = "";

				if (target[0].indexOf('@') > 0) {
					user = target[0].substring(0, target[0].indexOf('@'));
					host = target[0].substring(target[0].indexOf('@') + 1);
				}

				if (user.length() == 0 || host.length() == 0) {
					setErrorMessage(target[0] + " is not valid dir.");
					return;
				}

				String home = SSH2Preference.RESOURCE_SSH2_DIR + target[0];
				File _home = new File(home);
				if (!_home.exists()) {
					if (!MessageDialog
							.openConfirm(getShell(), "Confirmation",
									" does not exsit.\nAre you sure you want to create it?")) {
						return;
					}
					if (!_home.mkdirs()) {
						setErrorMessage("Failed to create " + home);
						return;
					}
				}

				FileDialog fd = new FileDialog(getShell(), SWT.SAVE);
				fd.setFilterPath("./" + home + "/");
				String file = (kpair.getKeyType() == KeyPair.RSA) ? "id_rsa"
						: "id_dsa";
				fd.setFileName(file);
				file = fd.open();
				if (file == null) { // cancel
					return;
				}

				if (new File(file).exists()) {
					if (!MessageDialog
							.openConfirm(
									getShell(),
									"Confirmation",
									file
											+ " has already existed.\nAre you sure you want to over write it?")) {
						return;
					}
				}

				boolean ok = true;
				try {
					kpair.writePrivateKey(file);
					kpair.writePublicKey(file + ".pub", kpairComment);
				} catch (Exception ee) {
					ok = false;
				}

				if (ok) {

					MessageDialog.openInformation(getShell(), "Information",
							"Successfully saved." + "\n" + "Private key: "
									+ file + "\n" + "Public key: " + file
									+ ".pub");

				}
			}
		});

		return group;
	}

	class TableLabelProvider extends LabelProvider implements
			ITableLabelProvider {

		public String getColumnText(Object element, int columnIndex) {
			HostKey entry = (HostKey) element;
			switch (columnIndex) {
			case 0:
				return entry.getHost();
			case 1:
				return entry.getType();
			case 2:
				return entry.getFingerPrint(jsch);
			default:
				return null;
			}
		}

		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}
	};

	private Control createHostKeyManagementPage(Composite parent) {
		int columnSpan = 3;
		Composite group = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		layout.numColumns = 2;
		group.setLayout(layout);
		GridData gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.verticalAlignment = GridData.FILL;
		group.setLayoutData(gd);

		Label label = new Label(group, SWT.NONE);
		label.setText("Host Keys included in known_hosts.");

		gd = new GridData();
		gd.horizontalSpan = 2;
		label.setLayoutData(gd);

		viewer = new TableViewer(group, SWT.MULTI | SWT.FULL_SELECTION
				| SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		Table table = viewer.getTable();
		new TableEditor(table);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		gd = new GridData(GridData.FILL_BOTH);
		gd.widthHint = convertWidthInCharsToPixels(30);

		gd.heightHint = 100;
		table.setLayoutData(gd);
		table.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				handleSelection();
			}
		});
		// Create the table columns
		new TableColumn(table, SWT.NULL);
		new TableColumn(table, SWT.NULL);
		new TableColumn(table, SWT.NULL);
		TableColumn[] columns = table.getColumns();

		columns[0].setText("Hostname");
		columns[1].setText("Type");
		columns[2].setText("Fingerprint");
		viewer.setColumnProperties(new String[] { "Hostname", "Type",
				"Fingerprint" });
		viewer.setLabelProvider(new TableLabelProvider());
		viewer.setContentProvider(new IStructuredContentProvider() {
			public void dispose() {
			}

			public void inputChanged(Viewer viewer, Object oldInput,
					Object newInput) {
			}

			public Object[] getElements(Object inputElement) {
				if (inputElement == null)
					return null;
				return (Object[]) inputElement;
			}
		});
		TableLayout tl = new TableLayout();
		tl.addColumnData(new ColumnWeightData(20));
		tl.addColumnData(new ColumnWeightData(10));
		tl.addColumnData(new ColumnWeightData(70));
		table.setLayout(tl);

		Composite buttons = new Composite(group, SWT.NULL);
		buttons.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
		layout = new GridLayout();
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		buttons.setLayout(layout);

		removeHostKeyButton = new Button(buttons, SWT.PUSH);
		removeHostKeyButton.setText("Remove");

		gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;

		removeHostKeyButton.setLayoutData(gd);
		removeHostKeyButton.setEnabled(false);
		removeHostKeyButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				removeHostKey();
			}
		});

		Dialog.applyDialogFont(parent);
		HostKey[] hostKey = jsch.getHostKeyRepository().getHostKey();
		if (hostKey != null) {
			for (int i = 0; i < hostKey.length; i++) {
				viewer.setInput(hostKey);
			}
		}
		handleSelection();

		return group;
	}

	private void handleSelection() {
		boolean empty = viewer.getSelection().isEmpty();
		removeHostKeyButton.setEnabled(!empty);
	}

	private void removeHostKey() {

		IStructuredSelection selection = (IStructuredSelection) viewer
				.getSelection();
		for (Iterator iterator = selection.iterator(); iterator.hasNext();) {
			HostKey hostkey = (HostKey) iterator.next();
			jsch.getHostKeyRepository().remove(hostkey.getHost(),
					hostkey.getType());
			// jsch.removeHostKey(hostkey.getHost(), hostkey.getType());

			viewer.remove(hostkey);
		}

	}

	private void updateControls() {

		boolean enable = (kpair != null);
		publicKeylabel.setEnabled(enable);
		publicKeyText.setEnabled(enable);
		keyFingerPrintLabel.setEnabled(enable);
		keyFingerPrintText.setEnabled(enable);
		keyCommentLabel.setEnabled(enable);
		keyCommentText.setEnabled(enable);
		keyPassphrase1Label.setEnabled(enable);
		keyPassphrase1Text.setEnabled(enable);
		keyPassphrase2Label.setEnabled(enable);
		keyPassphrase2Text.setEnabled(enable);

		saveKeyPair.setEnabled(enable);

	}

	public void init(IWorkbench workbench) {
		// super.init(workbench);
		// initControls();
	}

	public void initialize() {
		// initControls();
	}

	private void initControls() {

		updateControls();

	}

	public boolean performOk() {

		boolean result = super.performOk();
		if (result) {
			setErrorMessage(null);
			String home = SSH2Preference.RESOURCE_SSH2_DIR;
			File _home = new File(home);
			if (!_home.exists()) {
				MessageBox mb = new MessageBox(getShell(), SWT.YES | SWT.NO
						| SWT.ICON_QUESTION);
				mb.setText("Question");

				mb
						.setMessage(home
								+ " does not exist.\nAre you sure you want to create it?");

				if (mb.open() == SWT.YES) {
					if (!(_home.mkdirs())) {
						setErrorMessage("Failed to create " + home);
						return false;
					}
				}
			}

		}
		return result;
	}

	public void performApply() {

		super.performApply();

		setErrorMessage(null);

		String home = SSH2Preference.RESOURCE_SSH2_DIR;
		File _home = new File(home);
		if (!_home.exists()) {
			MessageBox mb = new MessageBox(getShell(), SWT.YES | SWT.NO
					| SWT.ICON_QUESTION);
			mb.setText("Question");
			mb.setMessage(home
					+ " does not exist.\nAre you sure you want to create it?");
			if (mb.open() == SWT.YES) {
				if (!(_home.mkdirs())) {
					setErrorMessage("Failed to create " + home);
					return;
				}
			}
		}

	}

	protected void performDefaults() {

		super.performDefaults();

		updateControls();

	}

	protected void createSpacer(Composite composite, int columnSpan) {
		Label label = new Label(composite, SWT.NONE);
		GridData gd = new GridData();
		gd.horizontalSpan = columnSpan;
		label.setLayoutData(gd);
	}
}

class ExportDialog extends Dialog {
	protected Text field;

	protected String target = null;

	protected String title = null;

	protected String message = null;

	public ExportDialog(Shell parentShell, String title, String message) {
		super(parentShell);
		this.title = title;
		this.message = message;
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(title);
	}

	public void create() {
		super.create();
		field.setFocus();
	}

	protected Control createDialogArea(Composite parent) {

		parent = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		parent.setLayout(layout);
		parent.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Composite main = new Composite(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 3;
		main.setLayout(layout);
		main.setLayoutData(new GridData(GridData.FILL_BOTH));

		if (message != null) {
			Label messageLabel = new Label(main, SWT.WRAP);
			messageLabel.setText(message);
			GridData data = new GridData(GridData.FILL_HORIZONTAL);
			data.horizontalSpan = 3;
			messageLabel.setLayoutData(data);
		}

		createTargetFields(main);
		Dialog.applyDialogFont(main);
		return main;
	}

	protected void createTargetFields(Composite parent) {
		new Label(parent, SWT.NONE).setText("Target site:"); //$NON-NLS-1$

		field = new Text(parent, SWT.BORDER);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = convertHorizontalDLUsToPixels(IDialogConstants.ENTRY_FIELD_WIDTH);
		data.horizontalSpan = 2;
		field.setLayoutData(data);
	}

	public String getTarget() {
		return target;
	}

	protected void okPressed() {
		String _target = field.getText();
		if (_target == null || _target.length() == 0) {
			return;
		}
		target = _target;
		super.okPressed();
	}

	protected void cancelPressed() {
		target = null;
		super.cancelPressed();
	}
}
