/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netwatcher.ssh2.info.Credentials;
import netwatcher.ssh2.info.SSHNodeInfo;
import netwatcher.ssh2.info.SSHNodeInfoControl;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;

public final class SSHCommandThread implements Runnable {
	// MO
	private static Logger logger = null;

	private int CHANNEL_INPUTSTREAM_BYTE_SIZE = 1024;
	
	private static final int TIMEOUT = 10 * 1000;
	private static final int SLEEP_TIME = 1000;
	
	private static Map ourSessionsPool = new Hashtable();

	private String userName;

	private String host;

	private Thread sshCommandThread;

	private ArrayList commandList;

	public SSHCommandThread() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	public void setUserHost(String userName, String host) {
		this.userName = userName;
		this.host = host;

	}

	public void setCommandList(ArrayList commandList) {
		this.commandList = commandList;
	}

	public void startTCPPortScanReceiveServer() {

		sshCommandThread = new Thread(this);
		sshCommandThread.setDaemon(true);
		sshCommandThread.start();
	}

	public void stopTCPPortScanReceiveServer() {
		if (sshCommandThread == null) {
			return;
		}

		// interrupt receive thread so it will die a natural death
		sshCommandThread.interrupt();

	}

	public void run() {

		getSession(userName + "@" + host);

	}

	public Session getSession(String target) {
		/*
		 * if ("".equals(credentials.getUserName()) || credentials.getUserName() ==
		 * null) { throw new SVNAuthenticationException("User name is required
		 * to establish svn+shh connection"); }
		 */

		SSHNodeInfo sshNodeInfo = SSHNodeInfoControl.getInstance().getSSHInfo(
				target);

		String userName = sshNodeInfo.getSessionInfo().getUserName();
		String host = sshNodeInfo.getSessionInfo().getHost();
		String password = sshNodeInfo.getSshUserInfo().getPassword();
		int port = sshNodeInfo.getSessionInfo().getPort();

		logger.info("userName : " + userName);
		logger.info("host : " + host);
		logger.info("password : " + password);
		logger.info("port : " + port);

		Credentials credentials = sshNodeInfo.getCredentials();

		String key = userName + ":" + host + ":" + port;
		Session session = (Session) ourSessionsPool.get(key);
		if (session != null && !session.isConnected()) {
			ourSessionsPool.remove(key);
			logger.info("SESSION " + key + " disposed");
			session = null;
		}
		try {
			if (session == null) {
				JSch jsch = JSchControl.getInstance().getJsch();

				setCredentials(jsch, credentials);

				session = jsch.getSession(userName, host, port);
			
				Hashtable table = new Hashtable();
				table.put("StrictHostKeyChecking", "no");
				
				if (credentials.getIdRSAKeyFile() != null) {
				table.put("server_host_key", "ssh-rsa");
				} else if (credentials.getIdDSAKeyFile() != null) {
				table.put("server_host_key", "ssh-dss");
				}
				session.setConfig(table);
				
				com.jcraft.jsch.UserInfo userInfo = sshNodeInfo
						.getSshUserInfo();
				session.setUserInfo(userInfo);

				session.setSocketFactory(SimpleSocketFactory.getInstance());
				logger.info("SESSION " + key + " created");

				session.setTimeout(TIMEOUT);
				session.connect();
				session.setTimeout(0);
				ourSessionsPool.put(key, session);

				logger.info("SESSION " + key + " connected");

				// ArrayList commandList = sshNodeInfo.getCommandList();
				execCommand(session, commandList);

				logger.info("ClientVersion : " + session.getClientVersion());
				logger.info("ServerVersion : " + session.getServerVersion());
				logger.info("Host : " + session.getHost());
				logger.info("UserName : " + session.getUserName());
				HostKey hostKey = session.getHostKey();
				logger.info("Type : " + hostKey.getType());
				logger.info("Host : " + hostKey.getHost());
				session.disconnect();

			} else {
				logger.info("SESSION " + key + " reused");
			}
			return session;

		} catch (JSchException e) {
			logger.warning("JSchException : " + e.getMessage());
			SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(
					"JSchException : " + e.getMessage() + System.getProperty("line.separator"));
			
			if (session != null && session.isConnected()) {
				session.disconnect();
				logger.info("DISCONNECTING: " + session);
			}
			logger.info("SESSION " + key + " diconnected");
			ourSessionsPool.remove(key);
			logger.info("SESSION " + key + " disposed");
			e.printStackTrace();
			// throw new SVNAuthenticationException(e);

		} finally {
			if (ourSessionsPool.size() > 0) {
				for (Iterator e = ourSessionsPool.values().iterator(); e
						.hasNext();) {
					session = (Session) (e.next());
					try {
						session.disconnect();
						logger.info("DISCONNECTING: " + session);
						// DebugLog.log("DISCONNECTING: " + session);
					} catch (Exception ee) {
						logger.warning("Exception : " + ee.getMessage());
					}
				}
				ourSessionsPool.clear();
			}
		}

		return null;
	}

	private void execCommand(Session session, ArrayList commandList)
			throws JSchException {
		// exec command remotely

		for (int commandNo = 0; commandNo < commandList.size(); commandNo++) {
			ChannelExec channel = (ChannelExec) session.openChannel("exec");


			channel.setCommand((String) commandList.get(commandNo));
			channel.connect();
			// System.out.println("command : " + commandNo + " " +
			// (String)commandList.get(commandNo));
			SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(
					(String) commandList.get(commandNo));

			SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(
					System.getProperty("line.separator"));
			SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(
					System.getProperty("line.separator"));
			try {
				// get stdout
				InputStream in = channel.getInputStream();
				byte[] tmp = new byte[CHANNEL_INPUTSTREAM_BYTE_SIZE];
				while (true) {
					while (in.available() > 0) {
						int i = in.read(tmp, 0, CHANNEL_INPUTSTREAM_BYTE_SIZE);
						if (i < 0)
							break;
						String message = new String(tmp, 0, i);
						SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(
								message);
					}
					if (channel.isClosed()) {
						logger.info("exit-status: "
								+ channel.getExitStatus());
						break;
					}
					try {
						Thread.sleep(SLEEP_TIME);
					} catch (Exception ee) {
						SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(
								ee.getMessage() + System.getProperty("line.separator"));
						logger.warning(ee.getMessage());
						ee.printStackTrace();
					}
				}
			} catch (Exception e) {
				SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(
						e.getMessage() + System.getProperty("line.separator"));
				logger.warning(e.getMessage());
				e.printStackTrace();
			}

			SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(
					System.getProperty("line.separator"));
			if (channel != null) {
				channel.disconnect();
			}
		}

	}

	private void setCredentials(JSch jsch, Credentials credentials) throws JSchException {


		String passphrase = credentials.getPassphrase();
		if (credentials.getIdRSAKeyFile() != null) {
			String id_rsaKey = credentials.getIdRSAKeyFile().getAbsolutePath();
			
			logger.info("private id_rsaKey : " + id_rsaKey);
			logger.info("passphrase : " + passphrase);

			if (id_rsaKey != null && passphrase != null) {
				jsch.addIdentity(id_rsaKey, passphrase);
			} else if (id_rsaKey != null) {
				jsch.addIdentity(id_rsaKey);
			}
		}
		

		if (credentials.getIdDSAKeyFile() != null) {
			String id_dsaKey = credentials.getIdDSAKeyFile().getAbsolutePath();

			logger.info("private id_dsaKey : " + id_dsaKey);
			logger.info("passphrase : " + passphrase);
			
			if (id_dsaKey != null && passphrase != null) {
				jsch.addIdentity(id_dsaKey, passphrase);
			} else if (id_dsaKey != null) {
				jsch.addIdentity(id_dsaKey);
			}
		}

		



	}

	public static void shutdown() {
		if (ourSessionsPool.size() > 0) {
			for (Iterator e = ourSessionsPool.values().iterator(); e.hasNext();) {
				Session session = (Session) (e.next());
				try {
					session.disconnect();
					// DebugLog.log("DISCONNECTING: " + session);
				} catch (Exception ee) {
				}
			}
			ourSessionsPool.clear();
		}
	}
}
