package netwatcher.ssh2.model;

import java.io.File;
import java.util.logging.Logger;

import netwatcher.ssh2.preference.SSH2Preference;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;

public class JSchControl {

	private JSch jsch;

	private static Logger logger;

	private JSchControl() {
		logger = Logger.getLogger(this.getClass().getName());
		jsch = new JSch();
		try {
			setKnownHostsFile(jsch);
		} catch (JSchException e) {
			logger.warning("JSchException : " + e.getMessage());
			e.printStackTrace();
		}
	}

	private void setKnownHostsFile(JSch jsch) throws JSchException {

		File sshDir = null;

		// new style - user passed
		File knownHostsFile = new File(SSH2Preference.RESOURCE_SSH2_DIR
				+ SSH2Preference.KNOWN_HOSTS_FILE);

		if (knownHostsFile != null) {
			logger.info("knownHostsFile.getAbsolutePath "
					+ knownHostsFile.getAbsolutePath());

			jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
		} else {
			if (sshDir == null) {
				sshDir = findSshDir();
			}
			// Load the known hosts file
			knownHostsFile = new File(sshDir, SSH2Preference.KNOWN_HOSTS_FILE);
			if (knownHostsFile.isFile() && knownHostsFile.canRead()) {
				jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
			}
		}

	}

	private static File findSshDir() {

		File sshDir = new File(SSH2Preference.RESOURCE_SSH2_DIR);
		if (sshDir.exists()) {
			return sshDir;
		}

		return new File("");
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static JSchControl getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final JSchControl RESOURCE = new JSchControl();
	}

	public JSch getJsch() {
		return jsch;
	}
}
