/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.editor;

import netwatcher.ssh2.model.SSHCommandMessageQueue;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;

public class EditorSSHCommandTimerProcessor implements Runnable {

	public static final int TIMER = 1000;

	private Display display;

	/* IEditorSite */
	private IEditorSite editorSite;

	private Text moniterText;

	private Button commandButton;

	public EditorSSHCommandTimerProcessor() {
		// nothing
	}

	public void run() {
		if (editorSite.getPage().isPartVisible(editorSite.getPart())) {
			String message = SSHCommandMessageQueue.getInstance()
					.popPortScanInfo();
			while (message != null) {
				commandButton.setEnabled(true);
				moniterText.append(message);
				message = SSHCommandMessageQueue.getInstance()
						.popPortScanInfo();
			}
		}
		// ^C}[p
		display.timerExec(TIMER, this);
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static EditorSSHCommandTimerProcessor getInstance() {
		return SingletonResource.TIMER_POCESSOR;
	}

	/**
	 * TimersDisplayZbg܂B
	 * 
	 * @param display
	 *            TimersDisplay
	 */
	public void setDisplay(Display display) {
		this.display = display;
	}

	public void setMonitorText(IEditorSite editorSite, Text moniterText,
			Button commandButton) {
		this.editorSite = editorSite;
		this.moniterText = moniterText;
		this.commandButton = commandButton;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final EditorSSHCommandTimerProcessor TIMER_POCESSOR = new EditorSSHCommandTimerProcessor();
	}
}
