/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.gui.action;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netwatcher.ssh2.gui.treenode.ISSHUserHostTreeNode;
import netwatcher.ssh2.gui.treenode.SSHNodeTree;
import netwatcher.ssh2.gui.treenode.SSHNodeTreeGroup;
import netwatcher.ssh2.gui.treeview.AbstractSSHNodeTreeView;
import netwatcher.ssh2.gui.treeview.SSHNodeTreeViewSorter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class ActionBuilderNodeTree
extends Action {
    private static Logger logger = null;
    private HashMap nodeIconImageMap = new HashMap();
    private TreeViewer nodeListTreeViewer;
    private AbstractSSHNodeTreeView nodeTreeView;
    private SubStatusLineManager statusLineManager;
    private Composite parentComposite;
    private SSHNodeTreeGroup nodeTreeGroupRoot;
    private Image fileObjImage;
    private HashMap groupMap = new HashMap();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private IAction reloadNodeTreeDatabase = new ActionReloadNodeTreeDatabase();
    private IAction sortNodeTreeDatabase = new ActionSortNodeTreeDatabase();

    public ActionBuilderNodeTree() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.createNodeIconImage();
    }

    public ActionBuilderNodeTree(AbstractSSHNodeTreeView nodeTreeView, TreeViewer nodeListTreeViewer, Composite parentComposite, SSHNodeTreeGroup nodeTreeGroupRoot) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.nodeTreeView = nodeTreeView;
        this.nodeListTreeViewer = nodeListTreeViewer;
        this.parentComposite = parentComposite;
        this.nodeTreeGroupRoot = nodeTreeGroupRoot;
        this.createNodeIconImage();
    }

    public TreeViewer getViewer() {
        return this.nodeListTreeViewer;
    }

    public IAction actionReloadNodeTreeDatabase() {
        return this.reloadNodeTreeDatabase;
    }

    public IAction actionSortNodeTreeDatabase() {
        return this.sortNodeTreeDatabase;
    }

    public void createNodeTree(final boolean isSortDirectionTreeView) {
        File fleDir = new File("resources/ssh2/");
        File[] fileList = fleDir.listFiles();
        if (fileList != null) {
            int fileCount = 0;
            while (fileCount < fileList.length) {
                if (fileList[fileCount].isDirectory()) {
                    SSHNodeTreeGroup nodetreeGroup = null;
                    String group = fileList[fileCount].getName();
                    if (this.groupMap.containsKey(group)) {
                        nodetreeGroup = (SSHNodeTreeGroup)this.groupMap.get(group);
                    } else {
                        nodetreeGroup = new SSHNodeTreeGroup(group);
                        this.nodeTreeGroupRoot.addChild(nodetreeGroup);
                        this.groupMap.put(group, nodetreeGroup);
                    }
                    this.nodeTreeGroupRoot.addChild(nodetreeGroup);
                    File[] userHostFileList = fileList[fileCount].listFiles();
                    int userHostCount = 0;
                    while (userHostCount < userHostFileList.length) {
                        if (userHostFileList[userHostCount].isFile()) {
                            nodetreeGroup.addChild(new SSHNodeTree(fileList[fileCount].getName(), userHostFileList[userHostCount].getName(), userHostFileList[userHostCount], this.fileObjImage));
                        } else {
                            SSHNodeTreeGroup commandGroup = new SSHNodeTreeGroup(userHostFileList[userHostCount].getName());
                            nodetreeGroup.addChild(commandGroup);
                            File[] cmdFileList = userHostFileList[userHostCount].listFiles();
                            int cmdCount = 0;
                            while (cmdCount < cmdFileList.length) {
                                if (cmdFileList[cmdCount].isFile()) {
                                    commandGroup.addChild(new SSHNodeTree(fileList[fileCount].getName(), cmdFileList[cmdCount].getName(), cmdFileList[cmdCount], this.fileObjImage));
                                }
                                ++cmdCount;
                            }
                        }
                        ++userHostCount;
                    }
                } else if (fileList[fileCount].getName().equals("known_hosts")) {
                    this.nodeTreeGroupRoot.addChild(new SSHNodeTree(fileList[fileCount].getName(), fileList[fileCount].getName(), fileList[fileCount], this.fileObjImage));
                }
                ++fileCount;
            }
        }
        this.nodeListTreeViewer.setSorter((ViewerSorter)new SSHNodeTreeViewSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name2;
                String name1;
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                if (viewer == null || !(viewer instanceof ContentViewer)) {
                    name1 = e1.toString();
                    name2 = e2.toString();
                } else {
                    IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                    if (prov instanceof ILabelProvider) {
                        ILabelProvider lprov = (ILabelProvider)prov;
                        name1 = lprov.getText(e1);
                        name2 = lprov.getText(e2);
                    } else {
                        name1 = e1.toString();
                        name2 = e2.toString();
                    }
                }
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                if (isSortDirectionTreeView) {
                    return this.collator.compare(name1, name2);
                }
                return this.collator.compare(name2, name1);
            }
        });
        this.nodeListTreeViewer.expandAll();
        this.nodeListTreeViewer.refresh();
    }

    protected void setStatusLine(int groupNo, int nodeNo) {
        this.statusLineManager = (SubStatusLineManager)this.nodeTreeView.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        this.statusLineManager.setMessage("Node Tree View Group count=" + groupNo + " Node count=" + nodeNo);
    }

    public ISSHUserHostTreeNode getNodeBase() {
        IStructuredSelection selectElement = (IStructuredSelection)this.getViewer().getSelection();
        ISSHUserHostTreeNode node = (ISSHUserHostTreeNode)selectElement.getFirstElement();
        if (node == null) {
            node = (ISSHUserHostTreeNode)this.getViewer().getInput();
        }
        return node;
    }

    public SSHNodeTreeGroup setNodeGroupBase(ISSHUserHostTreeNode node) {
        SSHNodeTreeGroup baseNodeGroup = null;
        if (node != null) {
            baseNodeGroup = node.getParent();
        }
        if (node instanceof SSHNodeTreeGroup) {
            baseNodeGroup = (SSHNodeTreeGroup)node;
        }
        return baseNodeGroup;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        HashMap list = this.nodeIconImageMap;
        Iterator it = null;
        for (String key : list.keySet()) {
            Image nodeIconImage = (Image)list.get(key);
            if (nodeIconImage == null) continue;
            nodeIconImage.dispose();
        }
    }

    private void createNodeIconImage() {
        String sshNodeFileImageName = "icons/file_obj.gif";
        this.fileObjImage = null;
        Display display = this.parentComposite.getDisplay();
        URL url = null;
        url = this.bundle.getEntry(sshNodeFileImageName);
        if (url == null) {
            logger.severe("Not found icon file : " + sshNodeFileImageName);
        } else {
            try {
                this.fileObjImage = new Image((Device)display, url.openStream());
            }
            catch (IOException e) {
                logger.warning("Abort create image " + e.getMessage() + " for " + sshNodeFileImageName);
                e.printStackTrace();
            }
        }
    }

    protected abstract class AbstractNodeAction
    extends Action {
        protected AbstractNodeAction() {
        }

        public final void run() {
            SSHNodeTreeGroup baseNodeGroup = null;
            ISSHUserHostTreeNode node = ActionBuilderNodeTree.this.getNodeBase();
            baseNodeGroup = ActionBuilderNodeTree.this.setNodeGroupBase(node);
            this.doTask(baseNodeGroup, node);
        }

        protected abstract void doTask(SSHNodeTreeGroup var1, ISSHUserHostTreeNode var2);

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeTree.this.bundle.getEntry("icons/reload.gif"));
        }

        public String getText() {
            return "Node Tree reload";
        }

        public String getToolTipText() {
            return "Node Tree reload";
        }
    }

    public final class ActionReloadNodeTreeDatabase
    extends AbstractNodeAction {
        protected void doTask(SSHNodeTreeGroup group, ISSHUserHostTreeNode node) {
            ActionBuilderNodeTree.this.nodeTreeGroupRoot.removeChildAll();
            ActionBuilderNodeTree.this.groupMap.clear();
            this.setNodeTree();
        }

        public void setNodeTree() {
            ActionBuilderNodeTree.this.createNodeTree(true);
        }
    }

    protected abstract class AbstractNodeSortAction
    extends AbstractNodeAction {
        protected AbstractNodeSortAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeTree.this.bundle.getEntry("icons/sort_obj.gif"));
        }

        public String getText() {
            return "Sort Node Tree";
        }

        public String getToolTipText() {
            return "Sort Node Tree";
        }
    }

    protected final class ActionSortNodeTreeDatabase
    extends AbstractNodeSortAction {
        private String sortDirection0 = "asc";
        private String sortDirection1 = "asc";
        private boolean isSortToggle = true;

        protected ActionSortNodeTreeDatabase() {
        }

        protected void doTask(SSHNodeTreeGroup group, ISSHUserHostTreeNode node) {
            if (this.isSortToggle) {
                this.sortDirection0 = "asc";
                this.sortDirection1 = "asc";
                this.isSortToggle = false;
            } else {
                this.sortDirection0 = "desc";
                this.sortDirection1 = "desc";
                this.isSortToggle = true;
            }
            Iterator it = null;
            for (String groupName : ActionBuilderNodeTree.this.groupMap.keySet()) {
                SSHNodeTreeGroup nodeTreeGroup = (SSHNodeTreeGroup)ActionBuilderNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                SSHNodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                if (node instanceof SSHNodeTreeGroup) {
                    parentNodeTreeGroup = (SSHNodeTreeGroup)node;
                }
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderNodeTree.this.nodeTreeGroupRoot.removeChildAll();
            ActionBuilderNodeTree.this.groupMap.clear();
            this.setNodeTree();
        }

        protected void setNodeTree() {
            ActionBuilderNodeTree.this.createNodeTree(this.isSortToggle);
        }
    }
}

