package monalipse.server.giko;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class ThreadReference
{
	public static final int REFERENCE_BOARD = 1;
	public static final int REFERENCE_THREAD = 2;

	private static final String[] BBS_DOMAINS = new String[]{"2ch.net", "machibbs.com", "bbspink.com"};
	
	private int type;
	private URL boardURL;
	private String id;
	
	public ThreadReference(URL boardURL)
	{
		type = REFERENCE_BOARD;
		this.boardURL = boardURL;
		id = "";
	}
	
	public ThreadReference(URL boardURL, String id)
	{
		type = REFERENCE_THREAD;
		this.boardURL = boardURL;
		this.id = id;
	}
	
	public int getReferenceType()
	{
		return type;
	}
	
	public URL getBoardURL()
	{
		return boardURL;
	}
	
	public String getID()
	{
		return id;
	}

	public static ThreadReference of(URL url)
	{
		if(url.getProtocol().equals("http"))
		{
			for(int i = 0; i < BBS_DOMAINS.length; i++)
			{
				if(url.getHost().endsWith(BBS_DOMAINS[i]))
				{
					String readCgi = "/test/read.cgi";
					String kako = "/kako/";
					String html = ".html";
					String bbs = "bbs=";
					String key = "key=";
					String indexHtml = "index.html";
					String dir = url.getFile();
					String boardURL = null;
					String id = null;
					if(dir.startsWith(readCgi))
					{
						dir = dir.substring(readCgi.length(), dir.length());
						int s = dir.indexOf('/', 1);
						if(s == -1)
						{
							StringTokenizer tk = new StringTokenizer(dir, "?&");
							while(tk.hasMoreTokens())
							{
								String t = tk.nextToken().toLowerCase();
								if(t.indexOf(bbs) != -1)
									boardURL = "http://" + url.getHost() + "/" + t.substring(t.indexOf(bbs) + bbs.length(), t.length()) + "/";
								else if(t.indexOf(key) != -1)
									id = t.substring(t.indexOf(key) + key.length(), t.length()) + ".dat";
							}
						}
						else
						{
							boardURL = "http://" + url.getHost() + dir.substring(0, s + 1);
							int t = dir.indexOf('/', s + 1);
							if(t == -1)
								t = dir.length();
							id = dir.substring(s + 1, t) + ".dat";
						}
					}
					else if(dir.indexOf(kako) != -1 && dir.endsWith(html))
					{
						boardURL = "http://" + url.getHost() + dir.substring(0, dir.indexOf(kako) + 1);
						int h = dir.indexOf(html);
						int t = dir.lastIndexOf('/', h);
						if(t == -1)
							return null;
						id = dir.substring(t + 1, h) + ".dat";
					}
					else if(dir.endsWith("/") || dir.endsWith(indexHtml))
					{
						StringTokenizer tk = new StringTokenizer(dir, "/");
						if(tk.hasMoreTokens())
						{
							String board = tk.nextToken();
							if(board.indexOf('.') == -1)
								boardURL = "http://" + url.getHost() + "/" + board + "/";
						}
					}

					if(boardURL != null)
					{
						try
						{
							if(id == null)
								return new ThreadReference(new URL(boardURL));
							else
								return new ThreadReference(new URL(boardURL), id);
						}
						catch (MalformedURLException e)
						{
						}
					}
				}
			}
		}
		return null;
	}
}
