package monalipse.server;

import java.net.URL;
import java.util.List;

import monalipse.utils.CancelableRunner;
import monalipse.views.IBBSReference;
import monalipse.widgets.ColoredText;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;

public interface IThreadContentProvider extends IBBSReference
{
	public IBBSBoard getBoard();
	public URL getURL();
	public IFolder getLogFolder();
	public IFile getLogFile();
	public String getID();
	public String getName();
	public int getIndex();
	public int getResponseCountHint();
	public int getCachedCount();
	public IResponseEnumeration getResponses(CancelableRunner.ICancelableProgressMonitor monitor, int sequence, int rangeStart);
	public IResponseEnumeration updateResponses(CancelableRunner.ICancelableProgressMonitor monitor, IWorkbenchWindow workbenchWindow, int sequence, int rangeStart);
	public boolean submitResponse(CancelableRunner.ICancelableProgressMonitor monitor, String name, String mail, String body);
	public void prefetchToolTip(ColoredText.ToolTipTarget target);
	public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, ColoredText.ToolTipTarget target, String sourceTitle);
	public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, String selection, String sourceTitle);
	public String getResponses(List lineReceiver, int start, int end);
	public boolean hasNewResponses();
	public boolean threadChanged(IResourceChangeEvent event);
}
