/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import monalipse.MonalipsePlugin;
import monalipse.server.IBBSBoard;
import monalipse.server.IBBSServer;
import monalipse.server.IThreadContentProvider;
import monalipse.server.giko.GikoServer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class BBSServerManager {
    private static Map instances = new HashMap();
    private static IBBSServer[] servers = new IBBSServer[0];

    private static void ensureProjectRetarget() {
        if (servers.length != 0) {
            return;
        }
        IProject project = MonalipsePlugin.getProject();
        if (project != null) {
            BBSServerManager.ensureProjectRetarget(project);
        }
    }

    private static void ensureProjectRetarget(IProject project) {
        ArrayList<GikoServer> list = new ArrayList<GikoServer>();
        GikoServer server = new GikoServer();
        server.initialize(project.getFolder(server.getTargetName()));
        list.add(server);
        servers = new IBBSServer[list.size()];
        list.toArray(servers);
    }

    public static IThreadContentProvider getThreadContentProviderOf(URL url) {
        IBBSBoard board = BBSServerManager.getBoardOf(url);
        if (board == null) {
            return null;
        }
        return board.getThreadOf(url);
    }

    public static IBBSBoard getBoardOf(URL url) {
        BBSServerManager.ensureProjectRetarget();
        int i = 0;
        while (i < servers.length) {
            IBBSBoard board = servers[i].getBoardOf(url);
            if (board != null) {
                return board;
            }
            ++i;
        }
        return null;
    }

    public static URL getURLOf(IFile file) {
        BBSServerManager.ensureProjectRetarget();
        int i = 0;
        while (i < servers.length) {
            URL url = servers[i].getURLOf(file);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    public static IBBSServer getInstanceOf(String target) {
        BBSServerManager.ensureProjectRetarget();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getTargetName().equals(target)) {
                return servers[i];
            }
            ++i;
        }
        return null;
    }
}

