/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.WebForm;
import java.io.IOException;
import org.w3c.dom.Node;

public class SubmitButton
extends FormControl {
    public static SubmitButton UNNAMED_BUTTON = new SubmitButton();
    private final String _id;
    private final boolean _isImageButton;
    private boolean _pressed;
    private int _x;
    private int _y;
    private String[] _value = new String[1];

    public String getValue() {
        return this.getValueAttribute();
    }

    public String getID() {
        return this._id;
    }

    public boolean isImageButton() {
        return this._isImageButton;
    }

    public String[] getValues() {
        return this.isDisabled() || !this._pressed ? FormControl.NO_VALUE : this.toArray(this.getValueAttribute());
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (this._pressed && !this.isDisabled() && this.getName().length() > 0) {
            if (this.getValueAttribute().length() > 0) {
                processor.addParameter(this.getName(), this.getValueAttribute(), characterSet);
            }
            if (this._isImageButton) {
                processor.addParameter(String.valueOf(this.getName()) + ".x", Integer.toString(this._x), characterSet);
                processor.addParameter(String.valueOf(this.getName()) + ".y", Integer.toString(this._y), characterSet);
            }
        }
    }

    public String toString() {
        return "Submit with " + this.getName() + "=" + this.getValue();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getValue().hashCode();
    }

    public boolean equals(Object o) {
        return this.getClass().equals(o.getClass()) && this.equals((SubmitButton)o);
    }

    SubmitButton(WebForm form, Node node) {
        super(node);
        this._isImageButton = NodeUtils.getNodeAttribute(node, "type").equalsIgnoreCase("image");
        this._id = NodeUtils.getNodeAttribute(node, "id");
    }

    public void setPressed(boolean pressed) {
        this._pressed = pressed;
    }

    public void setLocation(int x, int y) {
        this._x = x;
        this._y = y;
    }

    private SubmitButton() {
        this._id = "";
        this._isImageButton = false;
    }

    private String[] toArray(String value) {
        this._value[0] = value;
        return this._value;
    }

    private boolean equals(SubmitButton button) {
        return this.getName().equals(button.getName()) && (this.getName().length() == 0 || this.getValue().equals(button.getValue()));
    }
}

