/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeUtils {
    private static final char NBSP = '\u00a0';

    NodeUtils() {
    }

    public static NodeList getElementsByTagName(Node root, String tagName) {
        if (root instanceof Document) {
            return ((Document)root).getElementsByTagName(tagName);
        }
        if (root instanceof Element) {
            return ((Element)root).getElementsByTagName(tagName);
        }
        throw new RuntimeException("root is neither an Element nor a Document");
    }

    public static int getAttributeValue(Node node, String attributeName, int defaultValue) {
        NamedNodeMap nnm = node.getAttributes();
        Node attribute = nnm.getNamedItem(attributeName);
        if (attribute == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attribute.getNodeValue());
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static String getNodeAttribute(Node node, String attributeName) {
        return NodeUtils.getNodeAttribute(node, attributeName, "");
    }

    public static String getNodeAttribute(Node node, String attributeName, String defaultValue) {
        Node attribute = node.getAttributes().getNamedItem(attributeName);
        return attribute == null ? defaultValue : attribute.getNodeValue();
    }

    static boolean isNodeAttributePresent(Node node, String attributeName) {
        return node.getAttributes().getNamedItem(attributeName) != null;
    }

    public static String asText(NodeList rootNodes) {
        StringBuffer sb = new StringBuffer(2048);
        Stack<String> pendingNodes = new Stack<String>();
        NodeUtils.pushNodeList(rootNodes, pendingNodes);
        while (!pendingNodes.empty()) {
            Object pending = pendingNodes.pop();
            if (pending instanceof String) {
                sb.append(pending);
                continue;
            }
            Node node = (Node)pending;
            if (node.getNodeType() == 3) {
                sb.append(NodeUtils.convertNBSP(node.getNodeValue()));
            } else {
                if (node.getNodeType() != 1) continue;
                if (node.getNodeName().equalsIgnoreCase("p")) {
                    sb.append("\n");
                } else if (node.getNodeName().equalsIgnoreCase("tr")) {
                    sb.append("\n");
                    pendingNodes.push(" |");
                } else if (node.getNodeName().equalsIgnoreCase("td")) {
                    sb.append(" | ");
                } else if (node.getNodeName().equalsIgnoreCase("th")) {
                    sb.append(" | ");
                } else if (node.getNodeName().equalsIgnoreCase("img") && HttpUnitOptions.getImagesTreatedAsAltText()) {
                    sb.append(NodeUtils.getNodeAttribute(node, "alt"));
                }
            }
            NodeUtils.pushNodeList(node.getChildNodes(), pendingNodes);
        }
        return sb.toString();
    }

    private static String convertNBSP(String text) {
        if (text == null) {
            return "";
        }
        return text.replace('\u00a0', ' ');
    }

    private static void pushNodeList(NodeList nl, Stack stack) {
        if (nl != null) {
            int i = nl.getLength() - 1;
            while (i >= 0) {
                stack.push(nl.item(i));
                --i;
            }
        }
    }
}

