/*
 * Decompiled with CFR 0.152.
 */
package JGints;

import JGints.AngularInts;
import JGints.AtomicCenter;
import JGints.BasisFunction;
import JGints.NestedFunctionsDerivs;
import JGints.OverlapIntegrals;
import JGints.RadialPartOfBasisFunction;
import JGints.RealWignerAdapt;
import JGints.SphericalHarmonics;
import Jama.Matrix;
import Polynom3D.Polynom3D;
import ProgramOptions.ProgTimer;
import java.io.PrintStream;
import moldenio.MOLDEN_IO;

public class JGints {
    public BasisFunction[] basis;
    public RadialPartOfBasisFunction[] RadialParts;
    public AtomicCenter[] centers;
    public double[][] ylm_norms2;
    public Polynom3D[][] ylm;
    public double[][] OverlapMatrix;
    PrintStream out = System.out;
    final int[][] P2moldenP = new int[][]{{0}, {1, -1, 0}, {-2, -1, 0, 1, 2}, {-3, -2, -1, 0, 1, 2, 3}, {-4, -3, -2, -1, 0, 1, 2, 3, 4}};
    final int[][] moldenP2P = new int[][]{{0}, {0, 1, -1}, {-2, -1, 0, 1, 2}, {-3, -2, -1, 0, 1, 2, 3}, {-4, -3, -2, -1, 0, 1, 2, 3, 4}};
    private BasisFunction tmp = new BasisFunction(0, 0, null, 0);
    private Polynom3D YLM1;
    private Polynom3D YLM2;
    private OverlapIntegrals OI = new OverlapIntegrals();
    private NestedFunctionsDerivs derivComputer = new NestedFunctionsDerivs();

    private double[] ThetaPhi(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = dArray2[i] - dArray[i];
        }
        double[] dArray4 = new double[]{Math.atan2(Math.sqrt(dArray3[1] * dArray3[1] + dArray3[0] * dArray3[0]), dArray3[2]), Math.atan2(dArray3[1], dArray3[0])};
        return dArray4;
    }

    double[][] Wigner2MOLDEN(double[][] dArray, int n) {
        double[][] dArray2 = new double[2 * n + 1][2 * n + 1];
        for (int i = -n; i <= n; ++i) {
            for (int j = -n; j <= n; ++j) {
                dArray2[n + i][n + j] = dArray[n + this.moldenP2P[n][n + i]][n + this.moldenP2P[n][n + j]];
            }
        }
        return dArray2;
    }

    double[][] WignerTranspose(double[][] dArray, int n) {
        double[][] dArray2 = new double[2 * n + 1][2 * n + 1];
        for (int i = -n; i <= n; ++i) {
            for (int j = -n; j <= n; ++j) {
                dArray2[n + i][n + j] = dArray[n + j][n + i];
            }
        }
        return dArray2;
    }

    public double BasicOverlapInt(double d, int n, double d2, int n2, double d3, int n3, double d4, int n4, int n5) {
        double d5 = 0.0;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        dArray[2] = d2;
        dArray2[2] = d4;
        try {
            boolean bl = false;
            if (bl) {
                this.tmp.additional_r_power = n2;
                this.tmp.L = n;
                this.tmp.m = this.P2moldenP[n][n + n5];
                this.YLM1 = this.tmp.Get_YLM_with_Additional_r_power(this.tmp, false);
                this.tmp.additional_r_power = n4;
                this.tmp.L = n3;
                this.tmp.m = this.P2moldenP[n3][n3 + n5];
                this.YLM2 = this.tmp.Get_YLM_with_Additional_r_power(this.tmp, false);
            }
            if (bl) {
                d5 = this.OI.BS_BS_Overlap(d, this.YLM1, dArray, d3, this.YLM2, dArray2);
            }
            int n6 = n + n3 + 2 * n2 + 2 * n4;
            double d6 = d + d3;
            double d7 = (d * d2 + d3 * d4) / d6;
            double d8 = 0.0;
            d8 = Math.exp(-d * d3 * (d4 - d2) * (d4 - d2) / d6);
            double d9 = Math.sqrt(d6);
            double[][] dArray3 = AngularInts.evaluate(n, n3, n5, n2 / 2, n4 / 2, d, d3, d4 - d2);
            double d10 = 0.0;
            d10 = dArray3[0][0] * d8;
            if (bl && Math.abs(d5 / d10 - 1.0) > 1.0E-10 && n2 + n4 == 0) {
                this.out.printf("TRUE = %.20E,  NEW = %.20E%n", d5, d10);
            }
            if (n2 > 0 || n4 > 0) {
                double[][] dArray4 = this.derivComputer.prefactorExponentDerivs(n2 / 2, n4 / 2, d4 - d2, d, d3);
                double[][] dArray5 = this.derivComputer.exponentialDerivs(dArray4, n2 / 2, n4 / 2);
                double[][] dArray6 = this.derivComputer.productDerivs(dArray5, dArray3, 1.0, n2 / 2, n4 / 2);
                d10 = dArray6[n2 / 2][n4 / 2];
                if ((n2 / 2 + n4 / 2) % 2 == 1) {
                    d10 = -d10;
                }
                if (bl && Math.abs(d5 / d10 - 1.0) > 1.0E-10) {
                    this.out.printf("TRUE = %.20E,  NEW = %.20E -- L1 = %d, L2 = %d ,m = %d ", d5, d10, n, n3, n5);
                    this.out.printf("--- d1 = %f,  d2 = %f %n", (double)n2 / 2.0, (double)n4 / 2.0);
                }
            }
            d5 = d10;
        }
        catch (Exception exception) {
            this.out.println("Exception in BasicOverlapInt: " + exception.toString());
            exception.printStackTrace();
        }
        return d5;
    }

    public void Build_Ovarlap_Matrix_PURE() {
        double d;
        int n;
        int n2;
        double d2;
        double d3;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.RadialParts.length;
        int n11 = 0;
        int n12 = 0;
        int[][] nArrayArray = new int[n10][];
        int[] nArray = new int[n10];
        for (n9 = 0; n9 < this.basis.length; ++n9) {
            int n13 = this.basis[n9].RadialPart_ID;
            nArray[n13] = nArray[n13] + 1;
        }
        for (n9 = 0; n9 < n10; ++n9) {
            nArrayArray[n9] = new int[nArray[n9]];
            nArray[n9] = 0;
        }
        int n14 = 0;
        while (n14 < this.basis.length) {
            n9 = this.basis[n14].RadialPart_ID;
            nArrayArray[n9][nArray[n9]] = n14++;
            int n15 = n9;
            nArray[n15] = nArray[n15] + 1;
        }
        nArray = null;
        int[][] nArrayArray2 = new int[this.centers.length][];
        int[] nArray2 = new int[this.centers.length];
        for (n8 = 0; n8 < n10; ++n8) {
            int n16 = this.RadialParts[n8].CenterID - 1;
            nArray2[n16] = nArray2[n16] + 1;
        }
        for (n8 = 0; n8 < this.centers.length; ++n8) {
            nArrayArray2[n8] = new int[nArray2[n8]];
            nArray2[n8] = 0;
        }
        for (n7 = 0; n7 < n10; ++n7) {
            n8 = this.RadialParts[n7].CenterID - 1;
            nArrayArray2[n8][nArray2[n8]] = n7;
            int n17 = n8;
            nArray2[n17] = nArray2[n17] + 1;
            if (this.RadialParts[n7].Addit_r_power > 2 * n12) {
                n12 = this.RadialParts[n7].Addit_r_power / 2;
            }
            if (this.RadialParts[n7].LUsedWith <= n11) continue;
            n11 = this.RadialParts[n7].LUsedWith;
        }
        nArray2 = null;
        int n18 = n12 + 1;
        AngularInts.zetaEffCoefs = NestedFunctionsDerivs.xSqrtNInvDerivs(2 * n11 + 2 * n11 + 3, n18 + n18);
        AngularInts.Cnk = Polynom3D.ensure_Cnk_enough(n18);
        AngularInts.Ank = NestedFunctionsDerivs.ensure_Ank_enough(n11);
        this.tmp.Quick_YLM = this.ylm;
        this.OverlapMatrix = new double[this.basis.length][this.basis.length];
        for (n6 = 0; n6 < this.centers.length; ++n6) {
            for (n5 = n6 + 1; n5 < this.centers.length; ++n5) {
                int n19;
                int n20;
                int n21;
                double[] dArray = (double[])this.centers[n6].R0.clone();
                double[] dArray2 = (double[])this.centers[n5].R0.clone();
                for (int i = 0; i < 3; ++i) {
                    int n22 = i;
                    dArray2[n22] = dArray2[n22] - dArray[i];
                    dArray[i] = 0.0;
                }
                double[] dArray3 = this.ThetaPhi(dArray, dArray2);
                double[] dArray4 = new double[]{0.0, 0.0, 0.0};
                double d4 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
                double[] dArray5 = new double[]{0.0, 0.0, d4};
                double[][][] dArray6 = RealWignerAdapt.create_sincos(dArray3[0], dArray3[1]);
                int n23 = 0;
                for (n21 = 0; n21 < nArrayArray2[n6].length; ++n21) {
                    if (this.RadialParts[nArrayArray2[n6][n21]].LUsedWith <= n23) continue;
                    n23 = this.RadialParts[nArrayArray2[n6][n21]].LUsedWith;
                }
                n21 = 0;
                for (n20 = 0; n20 < nArrayArray2[n5].length; ++n20) {
                    if (this.RadialParts[nArrayArray2[n5][n20]].LUsedWith <= n21) continue;
                    n21 = this.RadialParts[nArrayArray2[n5][n20]].LUsedWith;
                }
                n20 = n23;
                if (n21 > n20) {
                    n20 = n21;
                }
                double[][][] dArrayArray = new double[n20 + 1][][];
                for (n19 = 0; n19 <= n20; ++n19) {
                    dArrayArray[n19] = RealWignerAdapt.Wigner(dArray6, n19);
                    dArrayArray[n19] = this.WignerTranspose(dArrayArray[n19], n19);
                }
                for (n19 = 0; n19 < nArrayArray2[n6].length; ++n19) {
                    n7 = nArrayArray2[n6][n19];
                    n4 = this.RadialParts[n7].LUsedWith;
                    for (int i = 0; i < nArrayArray2[n5].length; ++i) {
                        int n24;
                        int n25;
                        int n26;
                        n3 = nArrayArray2[n5][i];
                        int n27 = this.RadialParts[n3].LUsedWith;
                        int n28 = n4;
                        if (n27 < n28) {
                            n28 = n27;
                        }
                        double[] dArray7 = new double[2 * n28 + 1];
                        for (n26 = 0; n26 < this.RadialParts[n7].Exponents.length; ++n26) {
                            d3 = this.RadialParts[n7].Exponents[n26];
                            d2 = this.RadialParts[n7].Coefs[n26];
                            for (n25 = 0; n25 < this.RadialParts[n3].Exponents.length; ++n25) {
                                double d5 = this.RadialParts[n3].Exponents[n25];
                                for (n24 = -n28; n24 <= n28; ++n24) {
                                    int n29 = n28 + n24;
                                    dArray7[n29] = dArray7[n29] + this.BasicOverlapInt(d3, n4, dArray4[2], this.RadialParts[n7].Addit_r_power, d5, n27, dArray5[2], this.RadialParts[n3].Addit_r_power, n24) * d2 * this.RadialParts[n3].Coefs[n25];
                                }
                            }
                        }
                        for (n26 = 0; n26 < nArrayArray[n7].length; ++n26) {
                            n2 = nArrayArray[n7][n26];
                            n25 = n4 + this.moldenP2P[n4][n4 + this.basis[n2].m];
                            for (n24 = 0; n24 < nArrayArray[n3].length; ++n24) {
                                n = nArrayArray[n3][n24];
                                int n30 = n27 + this.moldenP2P[n27][n27 + this.basis[n].m];
                                d = 0.0;
                                for (int j = -n28; j <= n28; ++j) {
                                    d += dArray7[n28 + j] * dArrayArray[n4][n25][n4 + j] * dArrayArray[n27][n30][n27 + j];
                                }
                                this.OverlapMatrix[n2][n] = d;
                                this.OverlapMatrix[n][n2] = d;
                            }
                        }
                        dArray7 = null;
                    }
                }
            }
        }
        for (int i = 0; i < this.centers.length; ++i) {
            for (int j = 0; j < nArrayArray2[i].length; ++j) {
                n7 = nArrayArray2[i][j];
                n4 = this.RadialParts[n7].LUsedWith;
                double d6 = 0.0;
                n6 = this.RadialParts[n7].Addit_r_power;
                for (int k = j; k < nArrayArray2[i].length; ++k) {
                    int n31;
                    int n32;
                    n3 = nArrayArray2[i][k];
                    if (this.RadialParts[n3].LUsedWith != n4) continue;
                    n5 = this.RadialParts[n3].Addit_r_power;
                    d6 = 0.0;
                    for (n32 = 0; n32 < this.RadialParts[n7].Coefs.length; ++n32) {
                        d3 = this.RadialParts[n7].Exponents[n32];
                        d2 = this.RadialParts[n7].Coefs[n32];
                        for (n31 = 0; n31 < this.RadialParts[n3].Coefs.length; ++n31) {
                            double d7 = this.RadialParts[n3].Coefs[n31];
                            d6 += OverlapIntegrals.primitive_int_1D_Sphr(2 + 2 * n4 + n6 + n5, d3 + this.RadialParts[n3].Exponents[n31]) * d2 * d7;
                        }
                    }
                    for (n32 = 0; n32 < nArrayArray[n7].length; ++n32) {
                        n2 = nArrayArray[n7][n32];
                        n31 = this.basis[n2].m;
                        for (int i2 = 0; i2 < nArrayArray[n3].length; ++i2) {
                            n = nArrayArray[n3][i2];
                            if (this.basis[n].m != n31) continue;
                            this.OverlapMatrix[n2][n] = d = d6 * this.ylm_norms2[n4][n4 + n31] * Math.PI * 4.0;
                            this.OverlapMatrix[n][n2] = d;
                        }
                    }
                }
            }
        }
    }

    public void ImportBasisFromMolden(MOLDEN_IO mOLDEN_IO) {
        this.basis = mOLDEN_IO.Basis;
        this.centers = mOLDEN_IO.Centers;
        this.RadialParts = mOLDEN_IO.RadialParts;
    }

    private void _Naive(Polynom3D[][] polynom3DArray) {
        double d;
        ProgTimer progTimer = new ProgTimer();
        Matrix matrix = new Matrix(this.basis.length, this.basis.length);
        for (int i = 0; i < this.basis.length; ++i) {
            for (int j = i; j < this.basis.length; ++j) {
                this.basis[i].Quick_YLM = polynom3DArray;
                try {
                    d = this.basis[i].OverlapWith(this.basis[j]);
                    matrix.set(i, j, d);
                    matrix.set(j, i, d);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        progTimer.Stop();
        progTimer.Print();
        this.out.println("========================");
        Matrix matrix2 = new Matrix(this.OverlapMatrix);
        Matrix matrix3 = matrix.minus(matrix2);
        d = 0.0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.basis.length; ++i) {
            for (int j = 0; j < this.basis.length; ++j) {
                if (!(Math.abs(matrix3.get(i, j)) > d)) continue;
                d = Math.abs(matrix3.get(i, j));
                n = i;
                n2 = j;
            }
        }
        this.out.printf("%.20E:  %.20f v.s. %.20f%n", d, matrix.get(n, n2), matrix2.get(n, n2));
    }

    public void _test() throws Exception {
        MOLDEN_IO mOLDEN_IO = new MOLDEN_IO();
        mOLDEN_IO.Allow_additional_r_power = true;
        mOLDEN_IO.Load_From_MOLDEN("M:\\abInitio\\JANPA\\tests_my\\conf_462_gRJ_vQz_CART_C2P.molden");
        mOLDEN_IO.CoordsToAU();
        this.ylm = SphericalHarmonics.Get_Quick_YLM_Norm4PI();
        this.ylm_norms2 = SphericalHarmonics.Get_Quick_YLM_Norm2(this.ylm);
        mOLDEN_IO.UnNormalizePrimitives(this.ylm_norms2);
        this.ImportBasisFromMolden(mOLDEN_IO);
        this.tmp.Quick_YLM = this.ylm;
        ProgTimer progTimer = new ProgTimer();
        progTimer.Start();
        this.Build_Ovarlap_Matrix_PURE();
        progTimer.Stop();
        progTimer.Print();
        this.out.println("Naive method...");
        this._Naive(this.ylm);
    }

    private double[][] rot_vec(double[] dArray) {
        double d;
        double[][] dArray2 = new double[3][3];
        dArray2[0][0] = dArray[1];
        dArray2[0][1] = -dArray[0];
        dArray2[0][2] = 0.0;
        dArray2[1][1] = d = Math.sqrt(dArray[1] * dArray[1] + dArray[0] * dArray[0]);
        dArray2[1][2] = dArray[2];
        dArray2[1][0] = Math.atan2(d, dArray[2]);
        double[] dArray3 = dArray2[0];
        dArray3[0] = dArray3[0] / d;
        double[] dArray4 = dArray2[0];
        dArray4[1] = dArray4[1] / d;
        return dArray2;
    }

    private double[] rotate_vec_to_new(double[] dArray, double[] dArray2) {
        double[][] dArray3 = this.rot_vec(dArray2);
        double d = dArray3[1][2];
        double d2 = dArray3[1][1];
        double[] dArray4 = new double[3];
        double d3 = dArray3[0][0];
        double d4 = dArray3[0][1];
        double d5 = dArray[0] * d3 + dArray[1] * d4;
        dArray4[0] = dArray[0] * d + (1.0 - d) * d3 * d5 - d2 * (d4 * dArray[2] - 0.0 * dArray[1]);
        dArray4[1] = dArray[1] * d + (1.0 - d) * d4 * d5 - d2 * (0.0 * dArray[0] - d3 * dArray[2]);
        dArray4[2] = dArray[2] * d + (1.0 - d) * 0.0 * d5 - d2 * (d3 * dArray[1] - d4 * dArray[0]);
        return dArray4;
    }

    private double[] rotate_vec_from_new(double[] dArray, double[] dArray2) {
        double[][] dArray3 = this.rot_vec(dArray2);
        double d = dArray3[1][2];
        double d2 = dArray3[1][1];
        double[] dArray4 = new double[3];
        double d3 = dArray3[0][0];
        double d4 = dArray3[0][1];
        double d5 = dArray[0] * d3 + dArray[1] * d4;
        dArray4[0] = dArray[0] * d + (1.0 - d) * d3 * d5 + d2 * (d4 * dArray[2] - 0.0 * dArray[1]);
        dArray4[1] = dArray[1] * d + (1.0 - d) * d4 * d5 + d2 * (0.0 * dArray[0] - d3 * dArray[2]);
        dArray4[2] = dArray[2] * d + (1.0 - d) * 0.0 * d5 + d2 * (d3 * dArray[1] - d4 * dArray[0]);
        return dArray4;
    }

    private void print_vec(double[] dArray) {
        for (int i = 0; i < 3; ++i) {
            this.out.printf("%.5f\t", dArray[i]);
        }
        this.out.println();
    }

    private double[] nZ(double[] dArray, double[] dArray2) {
        int n;
        double[] dArray3 = new double[3];
        double d = 0.0;
        for (n = 0; n < 3; ++n) {
            dArray3[n] = dArray2[n] - dArray[n];
            d += dArray3[n] * dArray3[n];
        }
        d = Math.sqrt(d);
        n = 0;
        while (n < 3) {
            int n2 = n++;
            dArray3[n2] = dArray3[n2] / d;
        }
        return dArray3;
    }

    private double[] ThetaPhi_2_n(double[] dArray) {
        double[] dArray2 = new double[]{Math.sin(dArray[0]) * Math.cos(dArray[1]), Math.sin(dArray[0]) * Math.sin(dArray[1]), Math.cos(dArray[0])};
        return dArray2;
    }

    private double Overlap(BasisFunction basisFunction, BasisFunction basisFunction2) throws Exception {
        int n;
        for (int i = 0; i < 3; ++i) {
            int n2 = i;
            basisFunction2.R0[n2] = basisFunction2.R0[n2] - basisFunction.R0[i];
            basisFunction.R0[i] = 0.0;
        }
        double[] dArray = this.ThetaPhi(basisFunction.R0, basisFunction2.R0);
        double[] dArray2 = this.ThetaPhi_2_n(dArray);
        double[][][] dArray3 = RealWignerAdapt.create_sincos(dArray[0], dArray[1]);
        double[][] dArray4 = RealWignerAdapt.Wigner(dArray3, basisFunction.L);
        double[][] dArray5 = RealWignerAdapt.Wigner(dArray3, basisFunction2.L);
        dArray4 = this.WignerTranspose(dArray4, basisFunction.L);
        dArray5 = this.WignerTranspose(dArray5, basisFunction2.L);
        double[] dArray6 = this.rotate_vec_from_new(basisFunction.R0, dArray2);
        double[] dArray7 = this.rotate_vec_from_new(basisFunction2.R0, dArray2);
        BasisFunction basisFunction3 = new BasisFunction(basisFunction);
        basisFunction3.R0 = dArray6;
        basisFunction3.OI = new OverlapIntegrals();
        BasisFunction basisFunction4 = new BasisFunction(basisFunction2);
        basisFunction4.R0 = dArray7;
        int n3 = basisFunction.L;
        if (basisFunction2.L < n3) {
            n3 = basisFunction2.L;
        }
        double[] dArray8 = new double[2 * n3 + 1];
        for (n = -n3; n <= n3; ++n) {
            basisFunction3.m = this.P2moldenP[basisFunction.L][basisFunction.L + n];
            basisFunction4.m = this.P2moldenP[basisFunction2.L][basisFunction2.L + n];
            dArray8[n3 + n] = basisFunction3.OverlapWith(basisFunction4);
        }
        n = basisFunction.L + this.moldenP2P[basisFunction.L][basisFunction.L + basisFunction.m];
        int n4 = basisFunction2.L + this.moldenP2P[basisFunction2.L][basisFunction2.L + basisFunction2.m];
        double d = 0.0;
        for (int i = -n3; i <= n3; ++i) {
            d += dArray8[n3 + i] * dArray4[n][basisFunction.L + i] * dArray5[n4][basisFunction2.L + i];
        }
        return d;
    }

    private void ___aaa() throws Exception {
        Object object;
        Object object2;
        int n;
        MOLDEN_IO mOLDEN_IO = new MOLDEN_IO();
        mOLDEN_IO.Load_From_MOLDEN("Z:\\DNA_software\\twfn\\OpenNAO\\CONVERTERS\\ORCA\\kr3_avtz_spher_ORCA_m2m.molden");
        mOLDEN_IO.CoordsToAU();
        Polynom3D[][] polynom3DArray = SphericalHarmonics.Get_Quick_YLM();
        double[][] dArray = SphericalHarmonics.Get_Quick_YLM_Norm2(polynom3DArray);
        mOLDEN_IO.UnNormalizePrimitives(dArray);
        for (n = 0; n < mOLDEN_IO.Basis.length; ++n) {
            this.out.printf("%d  at center %d  L = %d %n", n, mOLDEN_IO.Basis[n].Center_ID, mOLDEN_IO.Basis[n].L);
        }
        for (n = 0; n < mOLDEN_IO.Basis.length; ++n) {
            for (int i = n + 1; i < mOLDEN_IO.Basis.length; ++i) {
                double d;
                if (mOLDEN_IO.Basis[n].Center_ID == mOLDEN_IO.Basis[i].Center_ID || mOLDEN_IO.Basis[n].L < 1 || mOLDEN_IO.Basis[i].L < 1) continue;
                object2 = mOLDEN_IO.Basis[n];
                object = mOLDEN_IO.Basis[i];
                ((BasisFunction)object2).Quick_YLM = polynom3DArray;
                ((BasisFunction)object).Quick_YLM = polynom3DArray;
                ((BasisFunction)object2).OI = new OverlapIntegrals();
                double d2 = ((BasisFunction)object2).OverlapWith((BasisFunction)object);
                if (!(Math.abs((d2 - (d = this.Overlap((BasisFunction)object2, (BasisFunction)object))) / d2) > 1.0E-12) || !(Math.abs(d2 - d) > 1.0E-15)) continue;
                this.out.printf("EXACT = %.20f   NEW = %.20f,  DIFF = %.3E%n", d2, d, d2 - d);
            }
        }
        BasisFunction basisFunction = mOLDEN_IO.Basis[82];
        BasisFunction basisFunction2 = mOLDEN_IO.Basis[28];
        basisFunction.OI = new OverlapIntegrals();
        this.out.printf("EXACT = %n%.20f%n", basisFunction.OverlapWith(basisFunction2));
        this.out.printf("NEW = %n%.20f%n", this.Overlap(basisFunction, basisFunction2));
        basisFunction.Quick_YLM = polynom3DArray;
        basisFunction2.Quick_YLM = polynom3DArray;
        object2 = basisFunction.R0;
        object = basisFunction2.R0;
        double[] dArray2 = this.ThetaPhi((double[])object2, (double[])object);
        double[] dArray3 = this.ThetaPhi_2_n(dArray2);
        double[] dArray4 = new double[]{(double)(object2[0] + 0.2 * object[0]), (double)(object2[1] + 0.3 * object[1]), (double)(object2[2] + 0.3 * object[2])};
        int n2 = 0;
        for (int i = 0; i < 10000; ++i) {
            dArray4[0] = Math.random() * 10.0;
            dArray4[1] = Math.random() * 10.0;
            dArray4[2] = Math.random() * 10.0;
            dArray2 = new double[]{Math.random() * Math.PI, Math.random() * 2.0 * Math.PI};
            dArray3 = this.ThetaPhi_2_n(dArray2);
            double[] dArray5 = this.rotate_vec_to_new(dArray4, dArray3);
            int n3 = (int)(Math.random() * 2.0) + 1;
            int n4 = (int)(Math.random() * (double)(n3 + 1));
            if (Math.random() > 0.5) {
                n4 = -n4;
            }
            double d = polynom3DArray[n3][n4 += n3].EvaluateAtPoint(dArray4);
            double[][] dArray6 = RealWignerAdapt.Wigner(RealWignerAdapt.create_sincos(dArray2[0], dArray2[1]), n3);
            dArray6 = this.Wigner2MOLDEN(dArray6, n3);
            double d3 = 0.0;
            for (int j = 0; j < 2 * n3 + 1; ++j) {
                d3 += dArray6[n4][j] * polynom3DArray[n3][j].EvaluateAtPoint(dArray5);
            }
            if (Math.abs((d - d3) / d) > 1.0E-12) {
                this.out.printf("L = %d; M = %d; r[0] = %.20f; r[1] = %.20f; r[2] = %.20f;%n // ref = %.20f v = %.20f%n", n3, n4, dArray4[0], dArray4[1], dArray4[2], d, d3);
                continue;
            }
            ++n2;
        }
        this.out.println("PASSED = " + n2);
        this.out.println();
    }
}

