/*
 * Decompiled with CFR 0.152.
 */
package CLPO;

import CLPO.AtomicHybrids;
import CLPO.Blossom;
import CLPO.LOdescription;
import CLPO.PairEdge;
import JGints.AtomicCenter;
import JGints.BasisFunction;
import Jama.Matrix;
import MatrixHelper.CS96_SimultDiag;
import MatrixHelper.EigenEngine;
import MatrixHelper.Sorter;
import java.io.PrintStream;
import onpa.ono_options;
import onpa.printout;

public class PropertyOptimizedOrbitals {
    private Matrix SDS_NAO;
    private int nAtoms = 0;
    private int[][] NAOs_at_center;
    private int nNAOs = 0;
    private AtomicHybrids[] hybridsOfAtoms;
    private PrintStream out = System.out;
    private Matrix[][] DAB;
    public LOdescription LPO_descript;
    public LOdescription CLPO_descript;
    private ono_options options;
    private AtomicCenter[] Centers;
    private boolean opt_Lewis_mode = false;
    private int optimizeHybrids_nItersDone = -1;
    private double target_function_conv_thresh = 1.0E-5;
    private int Opt_Max_Iter = 10000;

    private int[][] get_NAOs_at_centers(BasisFunction[] basisFunctionArray) {
        int n;
        int[][] nArray = new int[this.nAtoms][1];
        for (n = 0; n < basisFunctionArray.length; ++n) {
            int[] nArray2 = nArray[basisFunctionArray[n].Center_ID - 1];
            nArray2[0] = nArray2[0] + 1;
        }
        for (n = 0; n < this.nAtoms; ++n) {
            nArray[n] = new int[nArray[n][0]];
        }
        n = 0;
        while (n < basisFunctionArray.length) {
            int n2 = basisFunctionArray[n].Center_ID - 1;
            int[] nArray3 = nArray[n2];
            int n3 = nArray[n2].length - 1;
            nArray3[n3] = nArray3[n3] + 1;
            nArray[n2][var5_5] = n++;
        }
        return nArray;
    }

    private Matrix[][] diatomic_Submatrices() {
        Matrix[][] matrixArray = new Matrix[this.nAtoms][];
        for (int i = 0; i < this.nAtoms; ++i) {
            matrixArray[i] = new Matrix[i + 1];
            for (int j = 0; j <= i; ++j) {
                matrixArray[i][j] = this.SDS_NAO.getMatrix(this.NAOs_at_center[i], this.NAOs_at_center[j]);
            }
        }
        return matrixArray;
    }

    private Matrix dihybridMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = this.DAB_dot_h(n, n, n2);
        Matrix matrix2 = this.DAB_dot_h(n3, n3, n4);
        Matrix matrix3 = this.DAB_dot_h(n, n3, n4);
        double d = this.hybridsOfAtoms[n].hybridScalarMul(n2, matrix);
        double d2 = this.hybridsOfAtoms[n3].hybridScalarMul(n4, matrix2);
        double d3 = this.hybridsOfAtoms[n].hybridScalarMul(n2, matrix3);
        Matrix matrix4 = new Matrix(2, 2);
        matrix4.set(0, 0, d);
        matrix4.set(0, 1, d3);
        matrix4.set(1, 0, d3);
        matrix4.set(1, 1, d2);
        return matrix4;
    }

    private void _printHybridStatTable(boolean bl, boolean bl2, double d) {
        this.out.printf(" AtomA (VecId) AtomB (VecId) occupancy     Dij%n", new Object[0]);
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            for (int j = 0; j < this.hybridsOfAtoms[i].nValidHybrids; ++j) {
                Matrix matrix = this.hybridsOfAtoms[i].getHybrid(j);
                int n3 = this.hybridsOfAtoms[i].friendAtomIndex[j];
                int n4 = this.hybridsOfAtoms[i].friendHybridIndex[j];
                if (bl && n3 != -1 || bl2 && n3 == -1) continue;
                double d4 = matrix.transpose().times(this.DAB[i][i]).times(matrix).get(0, 0);
                if (d4 < d) {
                    d3 += d4;
                    ++n2;
                    continue;
                }
                ++n;
                d2 += d4;
                this.out.printf(" %5d (%5d) %5d (%5d) %9.5f ", i + 1, j + 1, n3 == -1 ? -1 : n3 + 1, n4 == -1 ? -1 : n4 + 1, d4);
                if (n3 != -1) {
                    this.out.printf("%7.3f%n", matrix.transpose().times(this.DAB_dot_h(i, n3, n4)).get(0, 0));
                    continue;
                }
                this.out.printf("%7s%n", "n/a");
            }
        }
        if (d > 0.0) {
            this.out.printf("Total: %.3f electrons = %.3f electrons in %d printed items %nand %.3f electrons in %d items (each having occupancy below threshold = %.4f)%n", d2 + d3, d2, n, d3, n2, d);
        } else {
            this.out.printf("Total: %.3f electrons in %d printed items %n", d2, n);
        }
        this.out.println();
    }

    private Matrix DAB_dot_h(int n, int n2, int n3) {
        int n4;
        Matrix matrix;
        boolean bl = false;
        if (n2 <= n) {
            matrix = this.DAB[n][n2];
            n4 = matrix.getRowDimension();
        } else {
            matrix = this.DAB[n2][n];
            bl = true;
            n4 = matrix.getColumnDimension();
        }
        Matrix matrix2 = new Matrix(n4, 1);
        int n5 = this.hybridsOfAtoms[n2].U.getRowDimension();
        for (int i = 0; i < n4; ++i) {
            int n6;
            double d = 0.0;
            if (!bl) {
                for (n6 = 0; n6 < n5; ++n6) {
                    d += matrix.get(i, n6) * this.hybridsOfAtoms[n2].U.get(n6, n3);
                }
            } else {
                for (n6 = 0; n6 < n5; ++n6) {
                    d += matrix.get(n6, i) * this.hybridsOfAtoms[n2].U.get(n6, n3);
                }
            }
            matrix2.set(i, 0, d);
        }
        return matrix2;
    }

    private Matrix grad_DNLO_sq(int n, double[] dArray) {
        Matrix matrix = this.hybridsOfAtoms[n].U;
        int n2 = matrix.getColumnDimension();
        int n3 = matrix.getRowDimension();
        Matrix matrix2 = new Matrix(n3, n2);
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            Matrix matrix3 = this.DAB_dot_h(n, n, i);
            double d2 = this.hybridsOfAtoms[n].hybridScalarMul(i, matrix3);
            int n4 = this.hybridsOfAtoms[n].friendAtomIndex[i];
            if (n4 == -1) {
                for (int j = 0; j < n3; ++j) {
                    matrix2.set(j, i, matrix3.get(j, 0) * d2);
                }
                d += d2 * d2;
                continue;
            }
            Matrix matrix4 = this.DAB_dot_h(n, n4, this.hybridsOfAtoms[n].friendHybridIndex[i]);
            double d3 = this.hybridsOfAtoms[n].hybridScalarMul(i, matrix4);
            for (int j = 0; j < n3; ++j) {
                matrix2.set(j, i, matrix3.get(j, 0) * d2 + matrix4.get(j, 0) * d3);
            }
            d += d2 * d2 + d3 * d3;
        }
        if (dArray != null) {
            dArray[0] = d;
        }
        return matrix2;
    }

    private Matrix grad_DNLO_occ2(int n, double[] dArray) {
        Matrix matrix = this.hybridsOfAtoms[n].U;
        int n2 = matrix.getColumnDimension();
        int n3 = matrix.getRowDimension();
        Matrix matrix2 = new Matrix(n3, n2);
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            Matrix matrix3 = this.DAB_dot_h(n, n, i);
            double d2 = this.hybridsOfAtoms[n].hybridScalarMul(i, matrix3);
            int n4 = this.hybridsOfAtoms[n].friendAtomIndex[i];
            if (n4 == -1) {
                double d3 = d2;
                for (int j = 0; j < n3; ++j) {
                    matrix2.set(j, i, matrix2.get(j, i) + matrix3.get(j, 0) * d3);
                }
                d += d2 * d2;
                continue;
            }
            int n5 = this.hybridsOfAtoms[n].friendHybridIndex[i];
            Matrix matrix4 = this.DAB_dot_h(n, n4, n5);
            double d4 = this.hybridsOfAtoms[n].hybridScalarMul(i, matrix4);
            Matrix matrix5 = this.DAB_dot_h(n4, n4, n5);
            double d5 = this.hybridsOfAtoms[n4].hybridScalarMul(n5, matrix5);
            double d6 = Math.sqrt((d2 - d5) * (d2 - d5) + 4.0 * d4 * d4);
            double d7 = 0.5 * (d2 + d5 + d6);
            double d8 = d7 * 0.5 * (1.0 + (d2 - d5) / d6);
            double d9 = d7 * d4 / d6;
            for (int j = 0; j < n3; ++j) {
                matrix2.set(j, i, matrix2.get(j, i) + matrix3.get(j, 0) * d8 + matrix4.get(j, 0) * d9);
            }
            d += d7 * d7 / 2.0;
        }
        if (dArray != null) {
            dArray[0] = d;
        }
        return matrix2;
    }

    private Matrix grad_DNLO(int n, double[] dArray) {
        if (!this.opt_Lewis_mode) {
            return this.grad_DNLO_sq(n, dArray);
        }
        return this.grad_DNLO_occ2(n, dArray);
    }

    private double optimizeHybrids() {
        int n = 0;
        Matrix[] matrixArray = new Matrix[this.nAtoms];
        for (int i = 0; i < this.nAtoms; ++i) {
            this.hybridsOfAtoms[i].backup_U();
        }
        Matrix[] matrixArray2 = new Matrix[this.nAtoms];
        for (int i = 0; i < this.nAtoms; ++i) {
            matrixArray2[i] = this.hybridsOfAtoms[i].U.transpose().times(this.DAB[i][i]).times(this.hybridsOfAtoms[i].U);
        }
        double[][] dArray = new double[2][2];
        double[] dArray2 = new double[]{0.0};
        double d = -1.0;
        this.out.println("Iterative optimization of atomic hybrids");
        this.out.printf("           Target                 Total        max.atomic       Total        max.atomic     Nxt.step%n", new Object[0]);
        this.out.printf("  Itr.    function    new-old  ||Unew-U||^2   ||unew-u||^2   ||Dnew-D||^2   ||dnew-d||^2     lambda %n", new Object[0]);
        double d2 = 0.0;
        boolean bl = true;
        while (true) {
            int n2;
            this.optimizeHybrids_nItersDone = ++n;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            for (n2 = 0; n2 < this.nAtoms; ++n2) {
                matrixArray[n2] = this.grad_DNLO(n2, dArray2);
                d3 += dArray2[0];
                d4 += Math.abs(matrixArray[n2].transpose().times(this.hybridsOfAtoms[n2].U).trace());
                d5 += matrixArray[n2].times(matrixArray[n2].transpose()).trace();
                Matrix matrix = matrixArray[n2].transpose().times(this.hybridsOfAtoms[n2].U);
                d5 -= matrix.times(matrix).trace();
            }
            d4 /= (double)this.nNAOs;
            this.out.printf("%5d %12.4f   %+8.1e", n, d3, n == 1 ? d3 : d3 - d);
            if (d3 > d) {
                d2 = 1.0E-16 * d4;
                bl = true;
                for (n2 = 0; n2 < this.nAtoms; ++n2) {
                    this.hybridsOfAtoms[n2].backup_U();
                }
                if (d3 - d < this.target_function_conv_thresh) {
                    this.out.printf("    << Converged! (threshold = %.2e) >>%n", this.target_function_conv_thresh);
                    this.out.println("Optimization of hybrids finished");
                    return d3;
                }
                d = d3;
            } else {
                for (n2 = 0; n2 < this.nAtoms; ++n2) {
                    this.hybridsOfAtoms[n2].restore_U();
                }
                if (d - d3 < this.target_function_conv_thresh) {
                    this.out.println("    << No step can be taken >>");
                    this.out.println("Optimization of hybrids finished");
                    return d;
                }
                d2 = bl ? d4 : (d2 *= 2.0);
                bl = false;
            }
            if (n >= this.Opt_Max_Iter) {
                this.out.println("    << Maximum number of iterations reached >>");
                this.out.println("Optimization of hybrids finished");
                for (n2 = 0; n2 < this.nAtoms; ++n2) {
                    this.hybridsOfAtoms[n2].restore_U();
                }
                return d;
            }
            for (n2 = 0; n2 < dArray.length; ++n2) {
                for (int i = 0; i < dArray[n2].length; ++i) {
                    dArray[n2][i] = 0.0;
                }
            }
            for (n2 = 0; n2 < this.nAtoms; ++n2) {
                Matrix matrix = EigenEngine.symmetrOrth(matrixArray[n2].plus(this.hybridsOfAtoms[n2].U.times(d2)));
                double d8 = matrix.minus(this.hybridsOfAtoms[n2].U).normF();
                double[] dArray3 = dArray[0];
                dArray3[0] = dArray3[0] + d8;
                int n3 = this.hybridsOfAtoms[n2].NAO_indices.length;
                if (d8 / (double)n3 > dArray[0][1]) {
                    dArray[0][1] = d8 / (double)n3;
                }
                Matrix matrix2 = matrix.transpose().times(this.DAB[n2][n2]).times(matrix);
                d8 = matrixArray2[n2].minus(matrix2).normF();
                matrixArray2[n2] = matrix2;
                double[] dArray4 = dArray[1];
                dArray4[0] = dArray4[0] + d8;
                if (d8 > dArray[1][1]) {
                    dArray[1][1] = d8;
                }
                this.hybridsOfAtoms[n2].U = matrix;
            }
            this.out.printf("%12.6f  %13.7f %12.5f    %13.7f   ", dArray[0][0], dArray[0][1], dArray[1][0], dArray[1][1]);
            if (bl) {
                this.out.printf("%10s%n", "(none)");
                continue;
            }
            this.out.printf("%10.2e%n", 1.0 / d2);
        }
    }

    private int[][] getGlobalHybridIndices() {
        int[][] nArrayArray = new int[this.nAtoms][];
        int n = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            int[] nArray = this.hybridsOfAtoms[i].NAO_indices;
            nArrayArray[i] = new int[nArray.length];
            for (int j = 0; j < this.hybridsOfAtoms[i].nValidHybrids; ++j) {
                nArrayArray[i][j] = n++;
            }
        }
        return nArrayArray;
    }

    private Matrix SDS_in_hybrid_basis(int[][] nArray, LOdescription lOdescription) {
        int n = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            n += this.hybridsOfAtoms[i].nValidHybrids;
        }
        Matrix matrix = new Matrix(n, n);
        for (int i = 0; i < this.nAtoms; ++i) {
            int[] nArray2 = this.hybridsOfAtoms[i].NAO_indices;
            if (lOdescription != null) {
                for (int j = 0; j < this.hybridsOfAtoms[i].nValidHybrids; ++j) {
                    Matrix matrix2 = this.hybridsOfAtoms[i].U.getMatrix(0, nArray2.length - 1, j, j);
                    int n2 = nArray[i][j];
                    lOdescription.NAO_to_Hybrids.setMatrix(nArray2, n2, n2, matrix2);
                }
            }
            Matrix matrix3 = this.hybridsOfAtoms[i].U.transpose().times(this.DAB[i][i]).times(this.hybridsOfAtoms[i].U);
            matrix.setMatrix(nArray2, nArray2, matrix3.times(0.5));
            for (int j = 0; j < i; ++j) {
                int[] nArray3 = this.hybridsOfAtoms[j].NAO_indices;
                Matrix matrix4 = this.hybridsOfAtoms[i].U.transpose().times(this.DAB[i][j]).times(this.hybridsOfAtoms[j].U);
                matrix.setMatrix(nArray2, nArray3, matrix4);
            }
        }
        matrix = matrix.plus(matrix.transpose());
        return matrix;
    }

    private void printBondMatrix(int[][] nArray) {
        int n;
        this.out.println("Number of two-center(2C) BD orbitals for each pair of atoms");
        this.out.printf("%10s", "Centr. A/B");
        for (n = 0; n < this.nAtoms; ++n) {
            this.out.printf("%10d", n + 1);
        }
        this.out.println();
        for (n = 0; n < this.nAtoms; ++n) {
            int n2;
            this.out.printf("%7d   ", n + 1);
            for (n2 = 0; n2 < n; ++n2) {
                this.out.printf("%10s", "");
            }
            this.out.printf(" (%7d)", nArray[n][n]);
            for (n2 = n + 1; n2 < this.nAtoms; ++n2) {
                this.out.printf("%10d", nArray[n][n2]);
            }
            this.out.println();
        }
    }

    private int[][] numBonds() {
        int n;
        int n2;
        int[][] nArray = new int[this.nAtoms][this.nAtoms];
        for (n2 = 0; n2 < this.nAtoms; ++n2) {
            for (n = 0; n < this.hybridsOfAtoms[n2].nValidHybrids; ++n) {
                int n3 = this.hybridsOfAtoms[n2].friendAtomIndex[n];
                if (n3 == -1) continue;
                int[] nArray2 = nArray[n2];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + 1;
            }
        }
        for (n2 = 0; n2 < this.nAtoms; ++n2) {
            nArray[n2][n2] = 0;
            for (n = 0; n < this.nAtoms; ++n) {
                if (n == n2) continue;
                int[] nArray3 = nArray[n2];
                int n5 = n2;
                nArray3[n5] = nArray3[n5] + nArray[n2][n];
            }
        }
        return nArray;
    }

    private void CS_Guess() {
        int n;
        Matrix[] matrixArray = new Matrix[this.nAtoms];
        for (n = 0; n < this.nAtoms; ++n) {
            int n2;
            Matrix[] matrixArray2 = new Matrix[this.nAtoms];
            for (n2 = 0; n2 < this.nAtoms; ++n2) {
                matrixArray2[n2] = n2 <= n ? this.DAB[n][n2].times(this.DAB[n][n2].transpose()) : this.DAB[n2][n].transpose().times(this.DAB[n2][n]);
            }
            n2 = this.NAOs_at_center[n].length * 100;
            int[] nArray = new int[]{n2};
            matrixArray[n] = CS96_SimultDiag.simult_diag(matrixArray2, nArray, null);
            if (nArray[0] >= n2) {
                this.out.printf("Warning (non-critical): simultaneous diag. did not converge when generating initial AO-to-AHO guess for atom %d%n", n + 1);
            }
            this.hybridsOfAtoms[n].U = matrixArray[n];
        }
        for (n = 0; n < this.nAtoms; ++n) {
            this.hybridsOfAtoms[n].nValidHybrids = this.hybridsOfAtoms[n].NAO_indices.length;
        }
    }

    private void CS_Guess2() {
        int n;
        Matrix[] matrixArray = new Matrix[this.nAtoms];
        for (n = 0; n < this.nAtoms; ++n) {
            Matrix[] matrixArray2 = new Matrix[this.nAtoms];
            Matrix matrix = this.DAB[n][n].eig().getV();
            for (int i = 0; i < this.nAtoms; ++i) {
                Matrix matrix2;
                if (i <= n) {
                    matrix2 = matrix.transpose().times(this.DAB[n][i]);
                    matrixArray2[i] = matrix2.times(matrix2.transpose());
                    continue;
                }
                matrix2 = this.DAB[i][n].times(matrix);
                matrixArray2[i] = matrix2.transpose().times(matrix2);
            }
            matrixArray[n] = CS96_SimultDiag.simult_diag(matrixArray2, null, matrix);
            this.hybridsOfAtoms[n].U = matrixArray[n];
        }
        for (n = 0; n < this.nAtoms; ++n) {
            this.hybridsOfAtoms[n].nValidHybrids = this.hybridsOfAtoms[n].NAO_indices.length;
        }
    }

    private void CS_Guess3() {
        int n;
        Matrix[] matrixArray = new Matrix[this.nAtoms];
        for (n = 0; n < this.nAtoms; ++n) {
            int n2;
            int n3;
            Matrix[] matrixArray2 = new Matrix[this.nAtoms];
            for (n3 = 0; n3 < this.nAtoms; ++n3) {
                matrixArray2[n3] = n3 <= n ? this.DAB[n][n3].times(this.DAB[n][n3].transpose()) : this.DAB[n3][n].transpose().times(this.DAB[n3][n]);
            }
            n3 = this.NAOs_at_center[n].length;
            Matrix matrix = new Matrix(n3, n3);
            for (int i = 0; i < this.nAtoms; ++i) {
                for (n2 = 0; n2 < n3; ++n2) {
                    for (int j = 0; j < n3; ++j) {
                        matrix.set(n2, j, matrix.get(n2, j) + matrixArray2[i].get(n2, j) * matrixArray2[i].get(j, j));
                    }
                }
            }
            matrix.plusEquals(Matrix.identity(n3, n3).times(1.0));
            Matrix matrix2 = EigenEngine.symmetrOrth(matrix);
            for (n2 = 0; n2 < this.nAtoms; ++n2) {
                Matrix matrix3;
                if (n2 <= n) {
                    matrix3 = matrix2.transpose().times(this.DAB[n][n2]);
                    matrixArray2[n2] = matrix3.times(matrix3.transpose());
                    continue;
                }
                matrix3 = this.DAB[n2][n].times(matrix2);
                matrixArray2[n2] = matrix3.transpose().times(matrix3);
            }
            matrixArray[n] = CS96_SimultDiag.simult_diag(matrixArray2, null, matrix2);
            this.hybridsOfAtoms[n].U = matrixArray[n];
        }
        for (n = 0; n < this.nAtoms; ++n) {
            this.hybridsOfAtoms[n].nValidHybrids = this.hybridsOfAtoms[n].NAO_indices.length;
        }
    }

    double reconnectHybrids(Matrix matrix, int[][] nArray, boolean bl) {
        int n;
        int n2;
        int n3;
        double d = this.options.maxClpoBondIonicityThreshold.get_double();
        this.out.println("Finding an optimal hybrid pairing...");
        boolean bl2 = false;
        int[][] nArrayArray = new int[this.nNAOs][];
        int n4 = this.nNAOs * (2 * this.nNAOs - 1) / 2;
        if (this.opt_Lewis_mode) {
            n4 += this.nNAOs;
        }
        PairEdge[] pairEdgeArray = new PairEdge[n4];
        int n5 = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            for (int j = 0; j < this.hybridsOfAtoms[i].NAO_indices.length; ++j) {
                this.hybridsOfAtoms[i].friendAtomIndex[j] = -1;
                this.hybridsOfAtoms[i].friendHybridIndex[j] = -1;
                int n6 = nArray[i][j];
                nArrayArray[n6] = new int[]{i, j};
                double d2 = matrix.get(n6, n6);
                if (this.opt_Lewis_mode) {
                    pairEdgeArray[n5++] = new PairEdge(n6, this.nNAOs + n6, d2 * d2);
                }
                for (n3 = 0; n3 < this.nAtoms; ++n3) {
                    if (n3 == i) continue;
                    for (n2 = 0; n2 < this.hybridsOfAtoms[n3].NAO_indices.length; ++n2) {
                        int n7 = nArray[n3][n2];
                        if (n7 > n6) continue;
                        double d3 = matrix.get(n7, n7);
                        double d4 = matrix.get(n6, n7);
                        double d5 = 0.5 * (d2 + d3 + Math.sqrt((d2 - d3) * (d2 - d3) + 4.0 * d4 * d4));
                        double d6 = d2 + d3 - d5;
                        int n8 = n = d5 > 1.0 && d6 < 1.0 && Math.cos(Math.atan2(2.0 * d4, Math.abs(d2 - d3))) < d ? 1 : 0;
                        if (!bl && n == 0) continue;
                        pairEdgeArray[n5++] = this.opt_Lewis_mode ? new PairEdge(n6, n7, d5 * d5) : new PairEdge(n6, n7, d4 * d4);
                    }
                }
            }
        }
        double d7 = 0.0;
        if (n5 == 0) {
            return 0.0;
        }
        PairEdge[] pairEdgeArray2 = new PairEdge[n5];
        System.arraycopy(pairEdgeArray, 0, pairEdgeArray2, 0, n5);
        pairEdgeArray = pairEdgeArray2;
        Blossom blossom = new Blossom(pairEdgeArray);
        int[] nArray2 = blossom.maxWeightMatching();
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            this.out.printf("%5d", n3);
        }
        this.out.println();
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            this.out.printf("%5d", nArray2[n3]);
        }
        this.out.println();
        for (n3 = 0; n3 < nArray2.length && n3 < this.nNAOs; ++n3) {
            double d8;
            n2 = nArray2[n3];
            if (n2 >= this.nNAOs || n2 == -1) {
                d8 = matrix.get(n3, n3);
                if (bl2) {
                    this.out.printf("1C   subset: %7s (%5s), occ = %7.3f %n", String.format("%s%d", this.Centers[nArrayArray[n3][0]].Name, nArrayArray[n3][0] + 1), String.format("ho %d", nArrayArray[n3][1] + 1), d8);
                }
                d7 += d8 * d8;
                continue;
            }
            if (n3 >= n2) continue;
            d8 = matrix.get(n3, n3);
            double d9 = matrix.get(n3, n2);
            double d10 = matrix.get(n2, n2);
            int n9 = nArrayArray[n3][0];
            int n10 = nArrayArray[n3][1];
            int n11 = nArrayArray[n2][0];
            n = nArrayArray[n2][1];
            this.hybridsOfAtoms[n9].friendAtomIndex[n10] = n11;
            this.hybridsOfAtoms[n9].friendHybridIndex[n10] = n;
            this.hybridsOfAtoms[n11].friendAtomIndex[n] = n9;
            this.hybridsOfAtoms[n11].friendHybridIndex[n] = n10;
            double d11 = 0.5 * (d8 + d10 + Math.sqrt((d8 - d10) * (d8 - d10) + 4.0 * d9 * d9));
            d7 = this.opt_Lewis_mode ? (d7 += d11 * d11) : (d7 += d8 * d8 + 2.0 * d9 * d9 + d10 * d10);
            if (!bl2) continue;
            this.out.printf("  2C subset: %7s (%5s) -- %7s (%5s), d11 = \t %.3f \t d12 = \t%7.3f \t d22 = \t %.3f \t Io = %.3f \t bd_occ = %.3f \t nb_occ = \t %.3f %n", String.format("%s%d", this.Centers[nArrayArray[n3][0]].Name, nArrayArray[n3][0] + 1), String.format("h%d", nArrayArray[n3][1] + 1), String.format("%s%d", this.Centers[nArrayArray[n2][0]].Name, nArrayArray[n2][0] + 1), String.format("h%d", nArrayArray[n2][1] + 1), d8, d9, d10, Math.cos(Math.atan2(2.0 * d9, Math.abs(d8 - d10))), d11, d8 + d10 - d11);
        }
        return d7;
    }

    private Matrix createLOs(String string, LOdescription lOdescription) {
        int n;
        int[][] nArray = this.getGlobalHybridIndices();
        Matrix matrix = this.SDS_in_hybrid_basis(nArray, lOdescription);
        int n2 = 0;
        boolean[] blArray = new boolean[this.nNAOs];
        double d = this.options.RyOccPrintThreshold.get_double();
        this.out.println();
        this.out.printf("*** Summary of %s results%n", string);
        this.out.println();
        this.out.printf(" %5s\t%35s\t%9s\t%s%n", string, " D e s c r i p t i o n     ", "Occupancy", "Composition");
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        double d4 = 0.0;
        int n4 = 0;
        double d5 = 0.0;
        int n5 = 0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n6 = 0;
        for (n = 0; n < this.nAtoms; ++n) {
            for (int i = 0; i < this.hybridsOfAtoms[n].nValidHybrids; ++i) {
                int n7;
                int n8 = nArray[n][i];
                if (lOdescription != null) {
                    lOdescription.hostAtomOfHybrid[n8] = n;
                }
                if ((n7 = this.hybridsOfAtoms[n].friendAtomIndex[i]) == -1) {
                    double d8 = matrix.get(n8, n8);
                    boolean bl = blArray[n2] = d8 > 1.0;
                    if (lOdescription != null) {
                        lOdescription.LO_to_Hybrids.set(n2, n8, 1.0);
                        lOdescription.hybridsOfLO[n2] = new int[]{n8};
                    }
                    ++n2;
                    String string2 = String.format("%s%d", this.Centers[n].Name, n + 1);
                    String string3 = String.format("1.0 * h%d@%s", n8 + 1, string2);
                    if (d8 > 1.0) {
                        d3 += d8;
                        d2 += d8 * d8;
                        ++n3;
                        this.out.printf("%5d\t%-35s\t%-9.5f\t%s%n", n2, "(LP)  " + string2, d8, string3);
                        if (lOdescription == null) continue;
                        lOdescription.LO_labels[n2 - 1] = string2 + ":LP";
                        lOdescription.LO_types[n2 - 1] = 1;
                        continue;
                    }
                    d4 += d8;
                    ++n4;
                    if (lOdescription != null) {
                        lOdescription.LO_labels[n2 - 1] = string2 + ":RY";
                        lOdescription.LO_types[n2 - 1] = 0;
                    }
                    if (d8 > d) {
                        this.out.printf("%5d\t%35s\t%9.5f\t%s%n", n2, string2 + " (RY)", d8, string3);
                        continue;
                    }
                    d7 += d8;
                    ++n6;
                    continue;
                }
                int n9 = this.hybridsOfAtoms[n].friendHybridIndex[i];
                int n10 = nArray[n7][n9];
                if (n10 <= n8) continue;
                double d9 = matrix.get(n8, n8);
                double d10 = matrix.get(n8, n10);
                double d11 = matrix.get(n10, n10);
                Matrix matrix2 = new Matrix(2, 2);
                matrix2.set(0, 0, d9);
                matrix2.set(0, 1, d10);
                matrix2.set(1, 0, d10);
                matrix2.set(1, 1, d11);
                Object[] objectArray = Sorter.sorted_eigenData(matrix2.eig(), -1);
                double[] dArray = (double[])objectArray[0];
                d5 += dArray[0];
                d6 += dArray[1];
                Matrix matrix3 = (Matrix)objectArray[1];
                String string4 = String.format("%s%d-%s%d", this.Centers[n].Name, n + 1, this.Centers[n7].Name, n7 + 1);
                if (lOdescription != null) {
                    lOdescription.LO_to_Hybrids.set(n2, n8, matrix3.get(0, 0));
                    lOdescription.LO_to_Hybrids.set(n2, n10, matrix3.get(1, 0));
                    lOdescription.hybridsOfLO[n2] = new int[]{n8, n10};
                    lOdescription.LO_types[n2] = 2;
                    lOdescription.LO_labels[n2] = string4 + ":BD";
                }
                blArray[n2] = true;
                ++n2;
                if (lOdescription != null) {
                    lOdescription.LO_to_Hybrids.set(n2, n8, matrix3.get(0, 1));
                    lOdescription.LO_to_Hybrids.set(n2, n10, matrix3.get(1, 1));
                    lOdescription.hybridsOfLO[n2] = new int[]{n8, n10};
                    lOdescription.LO_types[n2] = 3;
                    lOdescription.LO_labels[n2] = string4 + ":NB";
                }
                String string5 = String.format("%s * (%7.4f) + %s * (%7.4f)", "h" + String.format("%d@%s%d", n8 + 1, this.Centers[n].Name, n + 1), matrix3.get(0, 0), "h" + String.format("%d@%s%d", n10 + 1, this.Centers[n7].Name, n7 + 1), matrix3.get(1, 0));
                String string6 = String.format("%s * (%7.4f) + %s * (%7.4f)", "h" + String.format("%d@%s%d", n8 + 1, this.Centers[n].Name, n + 1), matrix3.get(0, 1), "h" + String.format("%d@%s%d", n10 + 1, this.Centers[n7].Name, n7 + 1), matrix3.get(1, 1));
                this.out.printf("%5d\t%-35s\t%-9.5f\t%s\t%n", ++n2 - 1, String.format("(BD) %s, Io = %.4f", string4, Math.cos(Math.atan2(2.0 * d10, Math.abs(d9 - d11)))), dArray[0], string5);
                this.out.printf("%5d\t%-35s\t%9.5f\t%s\t%n", n2, "     " + string4 + ", antibonding (NB)", dArray[1], string6);
                d2 += dArray[0] * dArray[0];
                ++n5;
            }
        }
        if (d > 0.0) {
            this.out.println();
            if (n6 > 0) {
                this.out.printf("Note: %d one-center RY orbitals, each having occupancy below %.2e,%n      were not printed (use the program option %s to change this behavior)%n", n6, d, this.options.RyOccPrintThreshold.Name);
                this.out.printf("      Total occupancy of these RY orbitals is %.5f%n", d7);
            }
        }
        this.out.println();
        this.out.println();
        lOdescription.BDperAtomicPair = this.numBonds();
        this.printBondMatrix(lOdescription.BDperAtomicPair);
        if (string.equals("CLPO")) {
            for (n = 0; n < this.nAtoms; ++n) {
                this.out.printf("VAL: \t %2s \t %d %n", this.Centers[n].Name, lOdescription.BDperAtomicPair[n][n]);
            }
        }
        this.out.println();
        this.out.printf(">> %s occupancy summary >>%n", string);
        this.out.printf("       bonding (BD): %12.5f in %4d oribtals%n", d5, n5);
        this.out.printf("  anti-bonding (NB): %12.5f in %4d oribtals%n", d6, n5);
        this.out.printf(" 1c-lone pairs (LP): %12.5f in %4d oribtals%n", d3, n3);
        this.out.printf(" 1c-unoccupied (RY): %12.5f in %4d oribtals%n", d4, n4);
        this.out.println();
        this.out.printf("Method        BD+LP....in      NB+RY     BD+NB+LP  BD+NB+LP+RY      trace(D)   Sum[Bd^2+Lp^2]    ||D||^2%n", new Object[0]);
        double d12 = matrix.normF();
        this.out.printf(" %5s %12.5f %5d %10.5f %12.5f %12.5f %12.3f   %12.4f  %12.4f", string, d5 + d3, n5 + n3, d6 + d4, d5 + d3 + d6, d5 + d3 + d6 + d4, matrix.trace(), d2, d12 * d12);
        this.out.println();
        return matrix;
    }

    private double targ_func1(int[][] nArray) {
        Matrix matrix = this.SDS_in_hybrid_basis(nArray, null);
        double d = 0.0;
        for (int i = 0; i < this.nAtoms; ++i) {
            for (int j = 0; j < this.hybridsOfAtoms[i].nValidHybrids; ++j) {
                int n = nArray[i][j];
                int n2 = this.hybridsOfAtoms[i].friendAtomIndex[j];
                d += matrix.get(n, n) * matrix.get(n, n);
                if (n2 == -1) continue;
                int n3 = this.hybridsOfAtoms[i].friendHybridIndex[j];
                int n4 = nArray[n2][n3];
                d += matrix.get(n, n4) * matrix.get(n4, n);
            }
        }
        return d;
    }

    private void iterativeHybridOpt(int[][] nArray, boolean bl, String string) {
        int n;
        double d = 0.0;
        for (n = 0; n < this.nNAOs; ++n) {
            Matrix matrix = this.SDS_in_hybrid_basis(nArray, null);
            double d2 = this.reconnectHybrids(matrix, nArray, bl);
            this.out.printf("%s iteration %2d: hybrids reconnected, target function = %12.7f%n", string, n + 1, d2);
            if (n > 0 && d2 < d - 1.0E-10) {
                this.out.printf("WOW!!! new = %.12e < prev = %.12e ; new-prev = %.12e%n", d2, d, d2 - d);
                this.out.printf("PHI = %.12e tr(DNew**2) = %.12e %n", this.targ_func1(nArray), matrix.times(matrix.transpose()).trace());
            }
            if (n > 0 && Math.abs(d - d2) < this.target_function_conv_thresh) {
                this.out.printf("Done! ", new Object[0]);
                break;
            }
            d = this.optimizeHybrids();
            this.out.printf("%s iteration %2d: hybrids optimized, target function = %12.7f%n", string, n + 1, d);
        }
        this.out.printf("(in %d iterations)%n", n);
        this.out.println();
    }

    private String[] create_Hybrid_Labels(String string, int[][] nArray) {
        String[] stringArray = new String[this.nNAOs];
        for (int i = 0; i < this.nAtoms; ++i) {
            for (int j = 0; j < this.hybridsOfAtoms[i].NAO_indices.length; ++j) {
                int n = nArray[i][j];
                stringArray[n] = String.format("%s%d:%s%d", this.Centers[i].Name, i + 1, string, n + 1);
            }
        }
        return stringArray;
    }

    public void createCLPOs(Matrix matrix, BasisFunction[] basisFunctionArray, AtomicCenter[] atomicCenterArray, ono_options ono_options2) {
        this.options = ono_options2;
        this.target_function_conv_thresh = ono_options2.HybrOptOccConvThresh.get_double();
        this.Opt_Max_Iter = ono_options2.HybrOptMaxIter.get_int();
        this.nAtoms = atomicCenterArray.length;
        this.Centers = atomicCenterArray;
        this.SDS_NAO = matrix;
        this.nAtoms = this.nAtoms;
        this.nNAOs = basisFunctionArray.length;
        this.out.printf("Creating  LPOs (Localized Property-optimized Orbitals)%n%n%n", new Object[0]);
        this.NAOs_at_center = this.get_NAOs_at_centers(basisFunctionArray);
        this.hybridsOfAtoms = new AtomicHybrids[this.nAtoms];
        for (int i = 0; i < this.nAtoms; ++i) {
            this.hybridsOfAtoms[i] = new AtomicHybrids(this.NAOs_at_center[i]);
        }
        this.DAB = this.diatomic_Submatrices();
        this.out.println("Creating initial guess...");
        this.CS_Guess();
        int[][] nArray = this.getGlobalHybridIndices();
        this.out.printf("Optimizing LPOs...%n%n", new Object[0]);
        this.opt_Lewis_mode = false;
        this.iterativeHybridOpt(nArray, true, "LPO");
        this.LPO_descript = new LOdescription(this.nNAOs);
        this.createLOs("LPO ", this.LPO_descript);
        int[][][] nArrayArray = new int[][][]{(int[][])null};
        nArray = this.getGlobalHybridIndices();
        this.out.println();
        printout.PrintStars();
        this.out.printf("Creating CLPOs (Chemist's Localized Property-optimized Orbitals)%n%n%n", new Object[0]);
        this.out.println("Optimizing CLPOs...");
        this.opt_Lewis_mode = true;
        this.iterativeHybridOpt(nArray, false, "CLPO");
        nArray = this.getGlobalHybridIndices();
        this.CLPO_descript = new LOdescription(this.nNAOs);
        this.createLOs("CLPO", this.CLPO_descript);
        this.CLPO_descript.Hybrid_labels = this.create_Hybrid_Labels("LHO", nArray);
    }

    public int[] LOconnectivity(LOdescription lOdescription, double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int[] nArray = new int[this.nAtoms];
        int[] nArray2 = new int[this.nAtoms];
        int[][] nArray3 = new int[this.nAtoms][this.nAtoms];
        int[] nArray4 = new int[this.nAtoms];
        for (int i = 0; i < this.nAtoms; ++i) {
            for (n4 = i + 1; n4 < this.nAtoms; ++n4) {
                if (lOdescription.BDperAtomicPair[i][n4] <= 0) continue;
                int n5 = i;
                nArray2[n5] = nArray2[n5] + 1;
                int n6 = n4;
                nArray2[n6] = nArray2[n6] + 1;
                int n7 = i;
                int n8 = nArray4[n7];
                nArray4[n7] = n8 + 1;
                nArray3[i][n8] = n4;
                int n9 = n4;
                int n10 = nArray4[n9];
                nArray4[n9] = n10 + 1;
                nArray3[n4][n10] = i;
            }
        }
        int[] nArray5 = new int[this.nAtoms];
        n4 = 0;
        for (n3 = 0; n3 < this.nAtoms; ++n3) {
            nArray[n3] = -1;
        }
        n3 = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            if (nArray[i] != -1) continue;
            nArray5[n4++] = i;
            nArray[i] = ++n3;
            while (n4 > 0) {
                int n11 = nArray5[--n4];
                for (n2 = 0; n2 < nArray4[n11]; ++n2) {
                    n = nArray3[n11][n2];
                    if (nArray[n] != -1) continue;
                    nArray5[n4++] = n;
                    nArray[n] = n3;
                }
            }
        }
        this.out.printf("There are %d molecule(s) in the system%n", n3);
        this.out.println("(the 'molecule' is defined as the set of atoms linked with BD orbitals)");
        double[] dArray2 = new double[n3];
        int[] nArray6 = new int[n3];
        for (n2 = 0; n2 < this.nAtoms; ++n2) {
            int n12 = n = nArray[n2] - 1;
            dArray2[n12] = dArray2[n12] + dArray[n2];
            int n13 = n;
            nArray6[n13] = nArray6[n13] + 1;
        }
        this.out.println();
        this.out.println("Molecule   TotalNPA    NumberOf   ListOf ");
        this.out.println("id         charge      atoms      atoms...");
        for (n2 = 0; n2 < n3; ++n2) {
            this.out.printf("%4d    %+11.5f  %7d     ", n2 + 1, dArray2[n2], nArray6[n2]);
            for (n = 0; n < this.nAtoms; ++n) {
                if (nArray[n] != n2 + 1) continue;
                this.out.printf(" %s%d", this.Centers[n].Name, n + 1);
            }
            this.out.println();
        }
        this.out.println();
        this.out.println("Note: The total NPA charge is computed as the sum of NPA charge of atoms belonging to each molecule");
        return nArray;
    }
}

