/*
 * Decompiled with CFR 0.152.
 */
package nwchem2molden;

import java.util.Locale;
import nwchem2molden.BasisSetLoader;
import nwchem2molden.nw2moldenConverter;
import nwchem2molden.nw2molden_options;

public class Main {
    static final String Version = "13-01-2019";
    static nw2molden_options Options = new nw2molden_options();

    public static void main(String[] stringArray) throws Exception {
        Locale.setDefault(Locale.US);
        System.out.println(" * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
        System.out.println(" * nwchem2molden: produces MOLDEN-compatible files from NwChem results * ");
        System.out.println(" *        A part of JANPA package,   http://janpa.sourceforge.net      * ");
        System.out.printf(" *                      VERSION: %14s                        * %n", Version);
        System.out.println(" * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
        System.out.println();
        System.out.println("         (c) Tymofii Nikolaienko, 2014");
        System.out.println();
        System.out.println(" If any results obtained with this program are published,");
        System.out.println(" or for any other reasons, please, cite this work as: ");
        System.out.println("  T.Y.Nikolaienko, L.A.Bulavin, D.M.Hovorun; Comput.Theor.Chem.(2014),");
        System.out.println("  V.1050, P.15-22, DOI: 10.1016/j.comptc.2014.10.002");
        System.out.println("                       *  *  *                                   ");
        System.out.println();
        Options = new nw2molden_options();
        Main.Options._FirstOption.LoadOptionsFromCommandLine(stringArray, null, true, true);
        if (Main.Options.LogFile.get_String().isEmpty() || Main.Options.MO_File.get_String().isEmpty() || Main.Options.Molden_File.get_String().isEmpty()) {
            System.out.println("Usage:");
            System.out.println("java -jar nwchem2molden.jar -option1 value1 -option2 value2 ...");
            System.out.println();
            System.out.println("where possible options are");
            Main.Options._FirstOption.PrintDescriptions(null, " %s: %s%n");
            System.out.println("                       *  *  *                               ");
            return;
        }
        nw2moldenConverter nw2moldenConverter2 = new nw2moldenConverter();
        nw2moldenConverter2.molden.MOCoefLineFormat = "%3d %22.15f%n";
        if (!Main.Options.BasisSet_File.get_String().isEmpty()) {
            System.out.println("Loading external basis set information from " + Main.Options.BasisSet_File.get_String());
            nw2moldenConverter2.Extended_Basis_Info = new BasisSetLoader();
            nw2moldenConverter2.Extended_Basis_Info.print_loaded_basis = Main.Options.PrintNwBasis.get_boolean();
            nw2moldenConverter2.Extended_Basis_Info.LoadFromNwFile(Main.Options.BasisSet_File.get_String(), false);
            nw2moldenConverter2.do_basis_comparison = !Main.Options.CheckNwBasis.get_boolean();
        }
        System.out.println("Analyzing the log file " + Main.Options.LogFile.get_String());
        if (!nw2moldenConverter2._Parse_OUT_File(Main.Options.LogFile.get_String(), nw2moldenConverter2.molden)) {
            System.out.println(" There was an error loading Basis set and/or geometry data.");
            return;
        }
        System.out.println(" Basis set and geometry data loaded successfully.");
        System.out.println("Getting the MO/NO information from " + Main.Options.MO_File.get_String());
        nw2moldenConverter2._Parse_ASC_File(Main.Options.MO_File.get_String(), nw2moldenConverter2.molden);
        nw2moldenConverter2.molden.Title = String.format("Created by nwchem2molden from\tlogfile=%s\tand\tascfile=%s", Main.Options.LogFile.get_String(), Main.Options.MO_File.get_String());
        nw2moldenConverter2.molden.CoordsToAU();
        if (!nw2moldenConverter2.molden.Save_As_MOLDEN(Main.Options.Molden_File.get_String())) {
            System.out.println(" There was an error saving molden file.");
            return;
        }
        System.out.println(" Molden file saved to " + Main.Options.Molden_File.get_String());
    }
}

