/*
 * Decompiled with CFR 0.152.
 */
package molden2molden;

import JGints.BasisFunction;
import JGints.MO;
import JGints.RadialPartOfBasisFunction;
import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import MatrixHelper.EigenEngine;
import ProgramOptions.WarningManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import moldenio.MOLDEN_IO;

public class File47Import {
    public int natoms = 0;
    public int nbas = 0;
    public boolean bodm = false;
    public boolean upper = false;
    public boolean bohr = false;
    public int nshell = 0;
    public int nexp = 0;
    public double[][] Density;
    public double[][] Overlap;
    public int[] basis_center;
    public int[] basis_label;
    public int[] ncomp;
    public int[] nprim;
    public int[] nptr;
    public double[] c_exp;
    public double[] c_CS;
    public double[] c_CP;
    public double[] c_CD;
    public double[] c_CF;
    private int[] _MAT_ind = new int[14];
    private static final int _D_i = 0;
    private static final int _D_j = 1;
    private static final int _S_i = 2;
    private static final int _S_j = 3;
    private static final int _bas_cntr = 4;
    private static final int _bas_lbl = 5;
    private static final int _ncomp_arr = 6;
    private static final int _nprim_arr = 7;
    private static final int _nptr_arr = 8;
    private static final int _exp_arr = 9;
    private static final int _CS_arr = 10;
    private static final int _CP_arr = 11;
    private static final int _CD_arr = 12;
    private static final int _CF_arr = 13;
    int[] basis_remap;
    static final int section_unknown = -1;
    static final int section_NBO = 0;
    static final int section_GENNBO = 1;
    static final int section_COORD = 2;
    static final int section_BASIS = 3;
    static final int section_OVERLAP = 4;
    static final int section_DENSITY = 5;
    static final int section_CONTRACT = 7;
    PrintStream out = System.out;

    private String[] _Extract_Token(String string, String string2) {
        if (!string.matches(string2)) {
            return new String[]{string};
        }
        return new String[0];
    }

    private void _add_to_int_arr(int[] nArray, int n, int n2) {
        int n3 = this._MAT_ind[n];
        nArray[n3] = n2;
        int n4 = n;
        this._MAT_ind[n4] = this._MAT_ind[n4] + 1;
    }

    private void _add_to_dbl_arr(double[] dArray, int n, double d) {
        int n2 = this._MAT_ind[n];
        dArray[n2] = d;
        int n3 = n;
        this._MAT_ind[n3] = this._MAT_ind[n3] + 1;
    }

    private void _add_to_matrix(double[][] dArray, int n, int n2, double d) {
        int n3 = this._MAT_ind[n];
        int n4 = this._MAT_ind[n2];
        dArray[n3][n4] = d;
        if (this.upper) {
            dArray[n4][n3] = d;
        }
        if (this.upper && n4 == n3 || n4 == this.nbas - 1) {
            int n5 = n;
            this._MAT_ind[n5] = this._MAT_ind[n5] + 1;
            this._MAT_ind[n2] = 0;
        } else {
            int n6 = n2;
            this._MAT_ind[n6] = this._MAT_ind[n6] + 1;
        }
    }

    private void _Finalize_section(int n) {
        switch (n) {
            case 1: {
                this.Density = new double[this.nbas][this.nbas];
                this._MAT_ind[0] = 0;
                this._MAT_ind[1] = 0;
                this.Overlap = new double[this.nbas][this.nbas];
                this._MAT_ind[2] = 0;
                this._MAT_ind[3] = 0;
                this.basis_center = new int[this.nbas];
                this._MAT_ind[4] = 0;
                this.basis_label = new int[this.nbas];
                this._MAT_ind[5] = 0;
                this.basis_remap = new int[this.nbas];
            }
        }
    }

    public void import_from_file(String string) throws Exception {
        String string2;
        boolean bl = false;
        this.out.println("Reading data from the " + string + " nbo3-compatible .47 file...");
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        int n = 0;
        int n2 = 0;
        int[] nArray = null;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        while ((string2 = bufferedReader.readLine()) != null) {
            int n6;
            if ((string2 = string2.trim()).isEmpty()) continue;
            String[] stringArray = string2.split("[ =]+");
            for (int i = 0; i < stringArray.length; i += n6) {
                String string3 = stringArray[i];
                n6 = 0;
                if (string3.equals("$END")) {
                    this._Finalize_section(n5);
                    n5 = -1;
                    n6 = 1;
                }
                switch (n5) {
                    case 4: {
                        this._add_to_matrix(this.Overlap, 2, 3, Double.parseDouble(string3));
                        n6 = 1;
                        ++n2;
                        break;
                    }
                    case 5: {
                        this._add_to_matrix(this.Density, 0, 1, Double.parseDouble(string3));
                        n6 = 1;
                        ++n;
                        break;
                    }
                    case 3: {
                        if (string3.toLowerCase().equals("center")) {
                            nArray = this.basis_center;
                            n3 = 4;
                            n6 = 1;
                            break;
                        }
                        if (string3.toLowerCase().equals("label")) {
                            nArray = this.basis_label;
                            n3 = 5;
                            n6 = 1;
                            break;
                        }
                        if (!string3.matches("[0-9]+")) break;
                        this._add_to_int_arr(nArray, n3, Integer.parseInt(string3));
                        n6 = 1;
                        break;
                    }
                    case 1: {
                        if (string3.toLowerCase().equals("bodm")) {
                            this.bodm = true;
                            n6 = 1;
                        }
                        if (string3.toLowerCase().equals("upper")) {
                            this.upper = true;
                            n6 = 1;
                        }
                        if (string3.toLowerCase().equals("bohr")) {
                            this.bohr = true;
                            n6 = 1;
                        }
                        if (string3.toLowerCase().equals("nbas")) {
                            this.nbas = Integer.parseInt(stringArray[i + 1]);
                            n6 = 2;
                        }
                        if (string3.toLowerCase().equals("natoms")) {
                            this.natoms = Integer.parseInt(stringArray[i + 1]);
                            n6 = 2;
                        }
                        if (n6 != 0) break;
                        WarningManager.warning_printf("WARNING: UNKNOWN KEYWORD: " + string3, new Object[0]);
                        break;
                    }
                    case 7: {
                        if (string3.toLowerCase().equals("nshell") || string3.toLowerCase().equals("nshells")) {
                            this.nshell = Integer.parseInt(stringArray[i + 1]);
                            n6 = 2;
                            this.ncomp = new int[this.nshell];
                            this.nprim = new int[this.nshell];
                            this.nptr = new int[this.nshell];
                            this._MAT_ind[6] = 0;
                            this._MAT_ind[7] = 0;
                            this._MAT_ind[8] = 0;
                            break;
                        }
                        if (string3.toLowerCase().equals("nexp")) {
                            this.nexp = Integer.parseInt(stringArray[i + 1]);
                            n6 = 2;
                            this.c_exp = new double[this.nexp];
                            this.c_CS = new double[this.nexp];
                            this.c_CP = new double[this.nexp];
                            this.c_CD = new double[this.nexp];
                            this.c_CF = new double[this.nexp];
                            this._MAT_ind[9] = 0;
                            this._MAT_ind[10] = 0;
                            this._MAT_ind[11] = 0;
                            this._MAT_ind[12] = 0;
                            this._MAT_ind[13] = 0;
                            break;
                        }
                        if (string3.toLowerCase().equals("ncomp")) {
                            n4 = 6;
                            n6 = 1;
                            break;
                        }
                        if (string3.toLowerCase().equals("nprim")) {
                            n4 = 7;
                            n6 = 1;
                            break;
                        }
                        if (string3.toLowerCase().equals("nptr")) {
                            n4 = 8;
                            n6 = 1;
                            break;
                        }
                        if (string3.toLowerCase().equals("exp")) {
                            n4 = 9;
                            n6 = 1;
                            break;
                        }
                        if (string3.toLowerCase().equals("cs")) {
                            n4 = 10;
                            n6 = 1;
                            break;
                        }
                        if (string3.toLowerCase().equals("cp")) {
                            n4 = 11;
                            n6 = 1;
                            break;
                        }
                        if (string3.toLowerCase().equals("cd")) {
                            n4 = 12;
                            n6 = 1;
                            break;
                        }
                        if (string3.toLowerCase().equals("cf")) {
                            n4 = 13;
                            n6 = 1;
                            break;
                        }
                        if (!string3.matches("[0-9\\.DE\\+\\-]+")) break;
                        boolean bl2 = false;
                        int[] nArray2 = null;
                        double[] dArray = null;
                        switch (n4) {
                            case 6: {
                                bl2 = false;
                                nArray2 = this.ncomp;
                                break;
                            }
                            case 7: {
                                bl2 = false;
                                nArray2 = this.nprim;
                                break;
                            }
                            case 8: {
                                bl2 = false;
                                nArray2 = this.nptr;
                                break;
                            }
                            case 9: {
                                bl2 = true;
                                dArray = this.c_exp;
                                break;
                            }
                            case 10: {
                                bl2 = true;
                                dArray = this.c_CS;
                                break;
                            }
                            case 11: {
                                bl2 = true;
                                dArray = this.c_CP;
                                break;
                            }
                            case 12: {
                                bl2 = true;
                                dArray = this.c_CD;
                                break;
                            }
                            case 13: {
                                bl2 = true;
                                dArray = this.c_CF;
                            }
                        }
                        if (bl2) {
                            this._add_to_dbl_arr(dArray, n4, Double.parseDouble(string3));
                        } else {
                            this._add_to_int_arr(nArray2, n4, Integer.parseInt(string3));
                        }
                        n6 = 1;
                    }
                }
                if (n6 != 0) continue;
                if (string3.equals("$NBO")) {
                    n5 = 0;
                    n6 = 1;
                    continue;
                }
                if (string3.equals("$GENNBO")) {
                    n5 = 1;
                    n6 = 1;
                    continue;
                }
                if (string3.equals("$COORD")) {
                    n5 = 2;
                    n6 = 1;
                    continue;
                }
                if (string3.equals("$BASIS")) {
                    n5 = 3;
                    n6 = 1;
                    continue;
                }
                if (string3.equals("$OVERLAP")) {
                    n5 = 4;
                    n6 = 1;
                    continue;
                }
                if (string3.equals("$DENSITY")) {
                    n5 = 5;
                    n6 = 1;
                    continue;
                }
                if (string3.equals("$CONTRACT")) {
                    n5 = 7;
                    n6 = 1;
                    continue;
                }
                n6 = 1;
            }
        }
        this.out.println("Final array index values: ");
        for (int i = 0; i < this._MAT_ind.length; ++i) {
            this.out.printf("%d\t", this._MAT_ind[i]);
        }
        this.out.println();
        this.out.println(" nbas = " + this.nbas);
        this.out.println(" " + n + " elements of the density matrix read");
        this.out.println(" " + n2 + " elements of the overlap matrix read");
        bufferedReader.close();
        fileReader.close();
    }

    public boolean Check_BF_order_and_create_remap(MOLDEN_IO mOLDEN_IO) {
        int n;
        int n2;
        boolean bl = true;
        for (n2 = 0; n2 < this.nbas; ++n2) {
            if (mOLDEN_IO.Basis[n2].Center_ID != this.basis_center[n2]) {
                this.out.printf("ERROR: Basis function %d center ID mistach: %d in .47 file v.s. %d required by molden file%n", n2 + 1, this.basis_center[n2], mOLDEN_IO.Basis[n2].Center_ID);
                bl = false;
            }
            if (mOLDEN_IO.Basis[n2].L == this.basis_label[n2] / 100) continue;
            this.out.printf("ERROR: Basis function %d center L mistach: %d in .47 file v.s. %d required by molden file%n", n2 + 1, this.basis_label[n2] / 100, mOLDEN_IO.Basis[n2].L);
            bl = false;
        }
        if (!bl) {
            return false;
        }
        int[][] nArrayArray = new int[][]{{51}, {151, 152, 153}, {255, 252, 253, 254, 251}, {351, 352, 353, 354, 355, 356, 357}, {451, 452, 453, 454, 455, 456, 457, 458, 459}, {551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 561}};
        int[][] nArrayArray2 = new int[][]{{51}, {151, 152, 153}, {201, 204, 206, 202, 203, 205}, {301, 307, 310, 304, 302, 303, 306, 309, 308, 305}, {401, 411, 415, 402, 403, 407, 412, 410, 414, 404, 406, 413, 405, 408, 409}};
        int[] nArray = new int[]{1, 3, 6, 10, 15};
        for (n2 = 0; n2 < this.nbas; n2 += n) {
            int n3 = mOLDEN_IO.Basis[n2].L;
            n = mOLDEN_IO.IsSpherical ? 2 * n3 + 1 : nArray[n3];
            for (int i = 0; i < n; ++i) {
                int n4 = this.basis_label[n2 + i];
                if (n4 < 154) {
                    n4 = n4 / 100 * 100 + 50 + n4 % 10;
                }
                boolean bl2 = false;
                int n5 = 0;
                if (mOLDEN_IO.IsSpherical) {
                    while (!bl2 && n5 < nArrayArray[n3].length) {
                        bl2 = nArrayArray[n3][n5] == n4;
                        if (bl2) continue;
                        ++n5;
                    }
                } else {
                    while (!bl2 && n5 < nArrayArray2[n3].length) {
                        bl2 = nArrayArray2[n3][n5] == n4;
                        if (bl2) continue;
                        ++n5;
                    }
                }
                if (!bl2) {
                    this.out.printf("ERROR: function label %d is unknown for L = %d %n", this.basis_label[n2 + i], n3);
                    return false;
                }
                this.basis_remap[n2 + i] = n2 + n5;
            }
        }
        return true;
    }

    public boolean Insert_Geom_Into(MOLDEN_IO mOLDEN_IO) {
        return true;
    }

    public boolean Build_Basis_Set(MOLDEN_IO mOLDEN_IO) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.nshell; ++n3) {
            if (this.ncomp[n3] != 4) {
                ++n4;
                continue;
            }
            n4 += 2;
        }
        mOLDEN_IO._RadialParts_Alloc(n4);
        for (n3 = 0; n3 < mOLDEN_IO.RadialParts.length; ++n3) {
            mOLDEN_IO.RadialParts[n3] = new RadialPartOfBasisFunction();
        }
        int[] nArray = new int[n4];
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = 0;
        for (int i = 0; i < this.nshell; ++i) {
            mOLDEN_IO.RadialParts[n6].Coefs = new double[this.nprim[i]];
            mOLDEN_IO.RadialParts[n6].Exponents = new double[this.nprim[i]];
            n2 = -2;
            switch (this.ncomp[i]) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 3: {
                    n2 = 1;
                    break;
                }
                case 4: {
                    n2 = -1;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
                case 7: 
                case 10: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 15: {
                    n2 = 4;
                }
            }
            if (n2 == -2) {
                this.out.printf("Unrecognized ncomp value: ncomp[%d] = %d %n", i + 1, this.ncomp[i]);
                return false;
            }
            if (n2 == -1) {
                for (n = 0; n < this.nprim[i]; ++n) {
                    mOLDEN_IO.RadialParts[n6].Exponents[n] = this.c_exp[this.nptr[i] - 1 + n];
                    mOLDEN_IO.RadialParts[n6].Coefs[n] = this.c_CS[this.nptr[i] - 1 + n];
                }
                mOLDEN_IO.RadialParts[n6].LUsedWith = 0;
                nArray[n6] = 1;
                ++n6;
                n2 = 1;
            }
            block18: for (n = 0; n < this.nprim[i]; ++n) {
                mOLDEN_IO.RadialParts[n6].Exponents[n] = this.c_exp[this.nptr[i] - 1 + n];
                switch (n2) {
                    case 0: {
                        mOLDEN_IO.RadialParts[n6].Coefs[n] = this.c_CS[this.nptr[i] - 1 + n];
                        continue block18;
                    }
                    case 1: {
                        mOLDEN_IO.RadialParts[n6].Coefs[n] = this.c_CP[this.nptr[i] - 1 + n];
                        continue block18;
                    }
                    case 2: {
                        mOLDEN_IO.RadialParts[n6].Coefs[n] = this.c_CD[this.nptr[i] - 1 + n];
                        continue block18;
                    }
                    case 3: {
                        mOLDEN_IO.RadialParts[n6].Coefs[n] = this.c_CF[this.nptr[i] - 1 + n];
                    }
                }
            }
            mOLDEN_IO.RadialParts[n6].LUsedWith = n2;
            nArray[n6] = this.ncomp[i] != 4 ? this.ncomp[i] : 3;
            if (n2 == 2 && nArray[n6] != 5) {
                bl = true;
            }
            if (n2 == 3 && nArray[n6] != 7) {
                bl2 = true;
            }
            if (n2 == 4 && nArray[n6] != 9) {
                bl3 = true;
            }
            if (n2 > n5) {
                n5 = n2;
            }
            ++n6;
        }
        this.out.printf("%d radial parts have been assembled, L_MAX = %d%n", n6, n5);
        mOLDEN_IO.IsSpherical = !bl & !bl2 & !bl3;
        if (!mOLDEN_IO.IsSpherical) {
            if (n5 >= 2 && !bl) {
                this.out.println("Mixing of spherical D / cartesian others basis is not supported!");
                return false;
            }
            if (n5 >= 3 && !bl2) {
                this.out.println("Mixing of spherical F / cartesian others basis is not supported!");
                return false;
            }
            if (n5 >= 4 && !bl3) {
                this.out.println("Mixing of spherical G / cartesian others basis is not supported!");
                return false;
            }
        }
        if (mOLDEN_IO.IsSpherical) {
            this.out.println("Building SPHERICAL basis set...");
        } else {
            this.out.println("Building CARTESIAN basis set...");
        }
        int[][] nArrayArray = new int[][]{{0}, {1, 2, 3}, {4, 5, 6, 7, 8, 9}, {10, 11, 12, 13, 14, 15, 16, 17, 18, 19}, {20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34}};
        mOLDEN_IO.Basis = new BasisFunction[this.nbas];
        n2 = 0;
        for (n6 = 0; n6 < n4; ++n6) {
            n = 0;
            if (!mOLDEN_IO.IsSpherical) {
                n = nArrayArray[mOLDEN_IO.RadialParts[n6].LUsedWith][0];
            }
            mOLDEN_IO.Basis[n2] = new BasisFunction(mOLDEN_IO.RadialParts[n6].LUsedWith, n, null, mOLDEN_IO.RadialParts[n6].Exponents.length);
            mOLDEN_IO.RadialParts[n6].CenterID = this.basis_center[n2];
            mOLDEN_IO.Basis[n2].Center_ID = this.basis_center[n2];
            mOLDEN_IO.Basis[n2].RadialPart_ID = n6;
            mOLDEN_IO.Basis[n2].R0 = mOLDEN_IO.Centers[mOLDEN_IO.Basis[n2].Center_ID - 1].R0;
            mOLDEN_IO.Basis[n2].exponents = (double[])mOLDEN_IO.RadialParts[n6].Exponents.clone();
            mOLDEN_IO.Basis[n2].coefs = (double[])mOLDEN_IO.RadialParts[n6].Coefs.clone();
            ++n2;
            for (int i = 0; i < nArray[n6] - 1; ++i) {
                mOLDEN_IO.Basis[n2] = new BasisFunction(mOLDEN_IO.Basis[n2 - i - 1]);
                mOLDEN_IO.Basis[n2].m = mOLDEN_IO.IsSpherical ? (i % 2 == 0 ? i / 2 + 1 : -(i / 2 + 1)) : nArrayArray[mOLDEN_IO.RadialParts[n6].LUsedWith][i + 1];
                ++n2;
            }
        }
        this.out.printf("%d basis functions have been built (%d were expected)%n", n2, this.nbas);
        return true;
    }

    public void Procude_NOs(MOLDEN_IO mOLDEN_IO) {
        this.out.println("Creating natural orbitals from the .47 file density/overlap matrices data...");
        Matrix matrix = new Matrix(this.Density);
        Matrix matrix2 = new Matrix(this.Overlap);
        this.out.printf(" tr(S) = %.10f%n", matrix2.trace());
        this.out.printf(" tr(D) = %.10f%n", matrix.trace());
        if (!this.bodm) {
            this.out.println("ERROR: non-BODM density matrices are not supported yet!");
            return;
        }
        Matrix matrix3 = EigenEngine.Matrix_SQRT(matrix2, false);
        Matrix matrix4 = EigenEngine.TransformSymmetricMatrixToNewBasis(matrix, matrix3);
        EigenvalueDecomposition eigenvalueDecomposition = matrix4.eig();
        Matrix matrix5 = eigenvalueDecomposition.getD();
        this.out.println("tr(EIG) = " + eigenvalueDecomposition.getD().trace());
        Matrix matrix6 = EigenEngine.Matrix_SQRT(matrix2, true);
        Matrix matrix7 = matrix6.times(eigenvalueDecomposition.getV());
        mOLDEN_IO.MOs = new MO[this.nbas];
        for (int i = 0; i < this.nbas; ++i) {
            mOLDEN_IO.MOs[i] = new MO();
            mOLDEN_IO.MOs[i].Energy = 0.0;
            mOLDEN_IO.MOs[i].Occupancy = matrix5.get(i, i);
            mOLDEN_IO.MOs[i].BS_Coefs = new double[this.nbas];
            for (int j = 0; j < this.nbas; ++j) {
                mOLDEN_IO.MOs[i].BS_Coefs[this.basis_remap[j]] = matrix7.get(j, i);
            }
        }
    }
}

