/*
 * Decompiled with CFR 0.152.
 */
package Polynom3D;

import java.util.Locale;

public class Polynom3D {
    public double[] coefs;
    public int[][] powers;
    public double[] coefs_temp;
    public int[][] powers_temp;
    public int temp_num_terms;
    public static double[][] Quick_CNK = new double[0][0];
    public String polynom_term_print_format = " + (%.4f)\u0412\u00b7x^%d\u0412\u00b7y^%d\u0412\u00b7z^%d ";

    public Polynom3D(int n) {
        this.coefs = new double[n];
        this.powers = new int[n][3];
    }

    public Polynom3D(double[] dArray, int[][] nArray) {
        this.coefs = (double[])dArray.clone();
        this.powers = new int[nArray.length][3];
        for (int i = 0; i < nArray.length; ++i) {
            this.powers[i] = (int[])nArray[i].clone();
        }
    }

    public Polynom3D(Polynom3D polynom3D) {
        this.coefs = (double[])polynom3D.coefs.clone();
        this.powers = new int[polynom3D.powers.length][3];
        for (int i = 0; i < polynom3D.powers.length; ++i) {
            this.powers[i] = (int[])polynom3D.powers[i].clone();
        }
    }

    public void CreateFromArrays(int n, double[] dArray, int[][] nArray) {
        this.coefs = null;
        this.powers = null;
        this.coefs = new double[n];
        this.powers = new int[n][3];
        System.arraycopy(dArray, 0, this.coefs, 0, n);
        for (int i = 0; i < n; ++i) {
            this.powers[i] = (int[])nArray[i].clone();
        }
    }

    public void SetZero() {
        this.coefs = new double[]{0.0};
        this.powers = new int[][]{{0, 0, 0}};
    }

    public void SetTempZero() {
        this.temp_num_terms = 1;
        this.coefs_temp = new double[]{0.0};
        this.powers_temp = new int[][]{{0, 0, 0}};
    }

    public void _Add_Term_To_Temp(int n, int n2, int n3, double d) {
        boolean bl = false;
        int n4 = 0;
        while (n4 < this.temp_num_terms && !bl) {
            bl = this.powers_temp[n4][0] == n && this.powers_temp[n4][1] == n2 && this.powers_temp[n4][2] == n3;
            if (bl) continue;
            ++n4;
        }
        if (bl) {
            int n5 = n4;
            this.coefs_temp[n5] = this.coefs_temp[n5] + d;
        } else {
            this.powers_temp[this.temp_num_terms][0] = n;
            this.powers_temp[this.temp_num_terms][1] = n2;
            this.powers_temp[this.temp_num_terms][2] = n3;
            this.coefs_temp[this.temp_num_terms] = d;
            ++this.temp_num_terms;
        }
    }

    public void _Allocate_Temp(int n) {
        this.coefs_temp = new double[n];
        this.powers_temp = new int[n][3];
    }

    public void _Remove_small_terms_from_temp(double d) {
        int n = 0;
        while (n < this.temp_num_terms) {
            if (Math.abs(this.coefs_temp[n]) <= d) {
                --this.temp_num_terms;
                for (int i = n; i < this.temp_num_terms; ++i) {
                    this.coefs_temp[i] = this.coefs_temp[i + 1];
                    this.powers_temp[i] = this.powers_temp[i + 1];
                }
                continue;
            }
            ++n;
        }
    }

    public void _Temp_To_Main() {
        this.CreateFromArrays(this.temp_num_terms, this.coefs_temp, this.powers_temp);
    }

    public void _Main_To_Temp(int n) {
        this.coefs_temp = new double[n];
        System.arraycopy(this.coefs, 0, this.coefs_temp, 0, this.coefs.length);
        this.powers_temp = new int[n][3];
        for (int i = 0; i < this.powers.length; ++i) {
            this.powers_temp[i] = (int[])this.powers[i].clone();
        }
        this.temp_num_terms = this.coefs.length;
    }

    public void MultiplyBy(Polynom3D polynom3D) {
        this.temp_num_terms = 0;
        this._Allocate_Temp(this.coefs.length * polynom3D.coefs.length);
        for (int i = 0; i < this.coefs.length; ++i) {
            for (int j = 0; j < polynom3D.coefs.length; ++j) {
                this._Add_Term_To_Temp(this.powers[i][0] + polynom3D.powers[j][0], this.powers[i][1] + polynom3D.powers[j][1], this.powers[i][2] + polynom3D.powers[j][2], this.coefs[i] * polynom3D.coefs[j]);
            }
        }
        this._Remove_small_terms_from_temp(0.0);
        if (this.temp_num_terms == 0) {
            this.SetTempZero();
        }
        this._Temp_To_Main();
    }

    public void AddPoly(Polynom3D polynom3D, double d) {
        this.temp_num_terms = 0;
        this._Allocate_Temp(this.coefs.length + polynom3D.coefs.length);
        this._Main_To_Temp(this.coefs.length + polynom3D.coefs.length);
        for (int i = 0; i < polynom3D.coefs.length; ++i) {
            this._Add_Term_To_Temp(polynom3D.powers[i][0], polynom3D.powers[i][1], polynom3D.powers[i][2], d * polynom3D.coefs[i]);
        }
        this._Remove_small_terms_from_temp(0.0);
        if (this.temp_num_terms == 0) {
            this.SetTempZero();
        }
        this._Temp_To_Main();
    }

    public Polynom3D Laplacian() {
        Polynom3D polynom3D = new Polynom3D(this);
        polynom3D._Allocate_Temp(3 * this.coefs.length);
        this.temp_num_terms = 0;
        for (int i = 0; i < this.coefs.length; ++i) {
            if (this.powers[i][0] >= 2) {
                polynom3D._Add_Term_To_Temp(this.powers[i][0] - 2, this.powers[i][1], this.powers[i][2], this.coefs[i] * (double)this.powers[i][0] * (double)(this.powers[i][0] - 1));
            }
            if (this.powers[i][1] >= 2) {
                polynom3D._Add_Term_To_Temp(this.powers[i][0], this.powers[i][1] - 2, this.powers[i][2], this.coefs[i] * (double)this.powers[i][1] * (double)(this.powers[i][1] - 1));
            }
            if (this.powers[i][2] < 2) continue;
            polynom3D._Add_Term_To_Temp(this.powers[i][0], this.powers[i][1], this.powers[i][2] - 2, this.coefs[i] * (double)this.powers[i][2] * (double)(this.powers[i][2] - 1));
        }
        polynom3D._Remove_small_terms_from_temp(0.0);
        if (polynom3D.temp_num_terms == 0) {
            polynom3D.SetTempZero();
        }
        polynom3D._Temp_To_Main();
        return polynom3D;
    }

    public static double C_nk(int n, int n2) {
        if (n - n2 > n2) {
            return Polynom3D.C_nk(n, n - n2);
        }
        double d = 1.0;
        for (int i = 1; i <= n - n2; ++i) {
            d *= 1.0 * (double)n2 / (double)i + 1.0;
        }
        return d;
    }

    public static double[][] ensure_Cnk_enough(int n) {
        if (Quick_CNK.length - 1 < n) {
            int n2;
            double[][] dArrayArray = new double[n + 1][];
            for (n2 = 0; n2 < Quick_CNK.length; ++n2) {
                dArrayArray[n2] = new double[n2 + 1];
                System.arraycopy(Quick_CNK[n2], 0, dArrayArray[n2], 0, Quick_CNK[n2].length);
            }
            for (n2 = Quick_CNK.length; n2 <= n; ++n2) {
                dArrayArray[n2] = new double[n2 + 1];
                for (int i = 0; i <= n2; ++i) {
                    dArrayArray[n2][i] = Polynom3D.C_nk(n2, i);
                }
            }
            Quick_CNK = dArrayArray;
        }
        return Quick_CNK;
    }

    public void Print() {
        for (int i = 0; i < this.coefs.length; ++i) {
            System.out.printf(this.polynom_term_print_format, this.coefs[i], this.powers[i][0], this.powers[i][1], this.powers[i][2]);
        }
        System.out.println();
    }

    public void Print2(int n, int n2) {
        String string = new String();
        String string2 = new String();
        Locale.setDefault(new Locale("en", "US"));
        for (int i = 0; i < this.coefs.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + String.format("%25.20f", this.coefs[i]);
            if (i > 0) {
                string2 = string2 + ",";
            }
            string2 = string2 + String.format("{%2d,%2d,%2d}", this.powers[i][0], this.powers[i][1], this.powers[i][2]);
        }
        System.out.printf("   Quick_YLM[%2d][%2d] = new Polynom3D(new double[]{%s}, new int[][]{%s});\n", n, n + n2, string, string2);
    }

    public double EvaluateAtPoint(double[] dArray) {
        int n;
        int n2;
        double d = 0.0;
        int[] nArray = new int[3];
        for (n2 = 0; n2 < 3; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < this.powers.length; ++n2) {
            for (n = 0; n < 3; ++n) {
                if (this.powers[n2][n] <= nArray[n]) continue;
                nArray[n] = this.powers[n2][n];
            }
        }
        double[][] dArrayArray = new double[3][];
        for (n = 0; n < 3; ++n) {
            dArrayArray[n] = new double[nArray[n] + 1];
            dArrayArray[n][0] = 1.0;
        }
        for (n = 0; n < 3; ++n) {
            for (int i = 1; i <= nArray[n]; ++i) {
                dArrayArray[n][i] = dArrayArray[n][i - 1] * dArray[n];
            }
        }
        for (n = 0; n < this.coefs.length; ++n) {
            d += this.coefs[n] * dArrayArray[0][this.powers[n][0]] * dArrayArray[1][this.powers[n][1]] * dArrayArray[2][this.powers[n][2]];
        }
        return d;
    }

    public void ScaleCoefsBy(double d) {
        int n = 0;
        while (n < this.coefs.length) {
            int n2 = n++;
            this.coefs[n2] = this.coefs[n2] * d;
        }
    }

    public Polynom3D Differentiate_mu(int n) {
        Polynom3D polynom3D = new Polynom3D(this);
        for (int i = 0; i < polynom3D.coefs.length; ++i) {
            if (polynom3D.powers[i][n] == 0) {
                polynom3D.coefs[i] = 0.0;
                continue;
            }
            int n2 = i;
            polynom3D.coefs[n2] = polynom3D.coefs[n2] * (double)polynom3D.powers[i][n];
            int[] nArray = polynom3D.powers[i];
            int n3 = n;
            nArray[n3] = nArray[n3] - 1;
        }
        polynom3D._Main_To_Temp(polynom3D.coefs.length);
        polynom3D._Remove_small_terms_from_temp(0.0);
        if (polynom3D.temp_num_terms == 0) {
            polynom3D.SetTempZero();
        }
        polynom3D._Temp_To_Main();
        return polynom3D;
    }
}

