/*
 * Decompiled with CFR 0.152.
 */
package JGints;

import Polynom3D.Polynom3D;

public class OverlapIntegrals {
    private final boolean debugPrint = false;
    private final int L_MAX = 10;
    private final int pwr_MAX = 20;
    private double[][] Quick_CNK = new double[21][21];

    static double Gamma_hi(int n) {
        double d = Math.sqrt(Math.PI);
        for (int i = 1; i <= n; ++i) {
            d *= 0.5 + (double)(i - 1);
        }
        return d;
    }

    public static double primitive_int_1D(int n, double d) {
        if (n % 2 == 1) {
            return 0.0;
        }
        return Math.pow(d, -0.5 - (double)n / 2.0) * OverlapIntegrals.Gamma_hi(n / 2);
    }

    public static double primitive_int_1D_Sphr(int n, double d) {
        if (n % 2 == 0) {
            return OverlapIntegrals.primitive_int_1D(n, d) / 2.0;
        }
        double d2 = 0.5 / d;
        for (int i = 1; i <= (n - 1) / 2; ++i) {
            d2 *= (double)i / d;
        }
        return d2;
    }

    public OverlapIntegrals() {
        for (int i = 0; i <= 20; ++i) {
            for (int j = 0; j <= i; ++j) {
                this.Quick_CNK[i][j] = Polynom3D.C_nk(i, j);
            }
        }
    }

    public double BS_BS_Overlap(double d, Polynom3D polynom3D, double[] dArray, double d2, Polynom3D polynom3D2, double[] dArray2) {
        int n;
        int n2;
        double d3 = d + d2;
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = (d * dArray[i] + d2 * dArray2[i]) / d3;
        }
        double d4 = 0.0;
        for (int i = 0; i < 3; ++i) {
            d4 += (dArray[i] - dArray2[i]) * (dArray[i] - dArray2[i]);
        }
        d4 = Math.exp(-d * d2 * d4 / d3);
        double d5 = 0.0;
        int n3 = 0;
        for (int i = 0; i < polynom3D.coefs.length; ++i) {
            for (n2 = 0; n2 < polynom3D2.coefs.length; ++n2) {
                for (int j = 0; j < 3; ++j) {
                    int n4 = polynom3D.powers[i][j] + polynom3D2.powers[n2][j];
                    if (n4 <= n3) continue;
                    n3 = n4;
                }
            }
        }
        double[] dArray4 = new double[n3 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            dArray4[n2] = OverlapIntegrals.primitive_int_1D(n2, d3);
        }
        double[][] dArray5 = new double[n3 + 1][3];
        double[][] dArray6 = new double[n3 + 1][3];
        double[][] dArray7 = new double[2][3];
        for (n = 0; n < 3; ++n) {
            dArray7[0][n] = 1.0;
            dArray7[1][n] = 1.0;
        }
        for (n = 0; n < 3; ++n) {
            dArray5[0][n] = 1.0;
            dArray6[0][n] = 1.0;
        }
        for (n = 1; n <= n3; ++n) {
            for (int i = 0; i < 3; ++i) {
                double[] dArray8 = dArray7[0];
                int n5 = i;
                dArray8[n5] = dArray8[n5] * (dArray3[i] - dArray[i]);
                double[] dArray9 = dArray7[1];
                int n6 = i;
                dArray9[n6] = dArray9[n6] * (dArray3[i] - dArray2[i]);
                dArray5[n][i] = dArray7[0][i];
                dArray6[n][i] = dArray7[1][i];
            }
        }
        for (int i = 0; i < polynom3D.coefs.length; ++i) {
            for (int j = 0; j < polynom3D2.coefs.length; ++j) {
                double d6 = polynom3D.coefs[i] * polynom3D2.coefs[j];
                for (int k = 0; k < 3; ++k) {
                    double d7 = 0.0;
                    for (int i2 = 0; i2 <= polynom3D.powers[i][k]; ++i2) {
                        double d8 = this.Quick_CNK[polynom3D.powers[i][k]][i2] * dArray5[i2][k];
                        for (int i3 = 0; i3 <= polynom3D2.powers[j][k]; ++i3) {
                            d7 += d8 * this.Quick_CNK[polynom3D2.powers[j][k]][i3] * dArray6[i3][k] * dArray4[polynom3D.powers[i][k] - i2 + (polynom3D2.powers[j][k] - i3)];
                        }
                    }
                    d6 *= d7;
                    if (d7 == 0.0) break;
                }
                d5 += d6;
            }
        }
        return d5 * d4;
    }

    public double SameCenterRadialOverlapIntegral(double[] dArray, double[] dArray2, int n, double[] dArray3, double[] dArray4, int n2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray3.length; ++j) {
                d += dArray[i] * dArray3[j] * OverlapIntegrals.primitive_int_1D_Sphr(n + n2 + 2, dArray2[i] + dArray4[j]);
            }
        }
        return d * 4.0 * Math.PI;
    }
}

