/*
 * Decompiled with CFR 0.152.
 */
package JGints;

import JGints.OverlapIntegrals;
import Polynom3D.Polynom3D;

public class BasisFunction {
    public BasisFunction _next = null;
    public boolean IsSpherical = true;
    public int L;
    public int m;
    public int additional_r_power = 0;
    public int Center_ID = -1;
    public double[] R0 = null;
    public double[] exponents;
    public double[] coefs;
    public int RadialPart_ID = -1;
    public double weight = 0.0;
    public boolean NRB = false;
    public OverlapIntegrals OI;
    public Polynom3D[][] Quick_YLM = null;
    final double CF_SMALL_THRESHOLD = 1.0E-15;

    public BasisFunction(int n, int n2, double[] dArray, int n3) {
        this.L = n;
        this.m = n2;
        if (dArray != null) {
            this.R0 = (double[])dArray.clone();
        }
        this.exponents = new double[n3];
        this.coefs = new double[n3];
        this.OI = new OverlapIntegrals();
    }

    public BasisFunction(BasisFunction basisFunction) {
        if (basisFunction == null) {
            return;
        }
        this.OI = basisFunction.OI;
        this._next = basisFunction._next;
        this.IsSpherical = basisFunction.IsSpherical;
        this.L = basisFunction.L;
        this.m = basisFunction.m;
        this.additional_r_power = basisFunction.additional_r_power;
        this.Center_ID = basisFunction.Center_ID;
        if (basisFunction.R0 != null) {
            this.R0 = (double[])basisFunction.R0.clone();
        }
        if (basisFunction.exponents != null) {
            this.exponents = (double[])basisFunction.exponents.clone();
        }
        if (basisFunction.coefs != null) {
            this.coefs = (double[])basisFunction.coefs.clone();
        }
        this.RadialPart_ID = basisFunction.RadialPart_ID;
        this.weight = basisFunction.weight;
        this.NRB = basisFunction.NRB;
        if (basisFunction.Quick_YLM != null) {
            this.Quick_YLM = new Polynom3D[basisFunction.Quick_YLM.length][];
            for (int i = 0; i < this.Quick_YLM.length; ++i) {
                this.Quick_YLM[i] = new Polynom3D[basisFunction.Quick_YLM[i].length];
                for (int j = 0; j < this.Quick_YLM[i].length; ++j) {
                    this.Quick_YLM[i][j] = new Polynom3D(basisFunction.Quick_YLM[i][j]);
                }
            }
        }
    }

    public static void _Multiply_Pol3D_By_r2(Polynom3D polynom3D) {
        int n;
        polynom3D._Main_To_Temp(polynom3D.coefs.length * 3);
        polynom3D.temp_num_terms = 0;
        for (n = 0; n < polynom3D.coefs.length; ++n) {
            polynom3D._Add_Term_To_Temp(polynom3D.powers[n][0] + 2, polynom3D.powers[n][1], polynom3D.powers[n][2], polynom3D.coefs[n]);
        }
        for (n = 0; n < polynom3D.coefs.length; ++n) {
            polynom3D._Add_Term_To_Temp(polynom3D.powers[n][0], polynom3D.powers[n][1] + 2, polynom3D.powers[n][2], polynom3D.coefs[n]);
        }
        for (n = 0; n < polynom3D.coefs.length; ++n) {
            polynom3D._Add_Term_To_Temp(polynom3D.powers[n][0], polynom3D.powers[n][1], polynom3D.powers[n][2] + 2, polynom3D.coefs[n]);
        }
        polynom3D._Temp_To_Main();
    }

    public Polynom3D Get_YLM_with_Additional_r_power(BasisFunction basisFunction, boolean bl) throws Exception {
        if (this.Quick_YLM == null) {
            throw new Exception("Quick_YLM has not been set!");
        }
        Polynom3D polynom3D = this.Quick_YLM[basisFunction.L][basisFunction.L + basisFunction.m];
        if (bl || basisFunction.additional_r_power > 0) {
            polynom3D = new Polynom3D(polynom3D);
        }
        if (basisFunction.additional_r_power > 0) {
            if (basisFunction.additional_r_power % 2 != 0) {
                throw new Exception("Can not calculate overlap if this.additional_r_power==" + basisFunction.additional_r_power + " is odd");
            }
            for (int i = 0; i < basisFunction.additional_r_power / 2; ++i) {
                BasisFunction._Multiply_Pol3D_By_r2(polynom3D);
            }
        }
        return polynom3D;
    }

    public double _Term_By_Term_Product(BasisFunction basisFunction, Polynom3D polynom3D, BasisFunction basisFunction2, Polynom3D polynom3D2) {
        double d = 0.0;
        for (int i = 0; i < basisFunction.coefs.length; ++i) {
            for (int j = 0; j < basisFunction2.coefs.length; ++j) {
                d += basisFunction.coefs[i] * basisFunction2.coefs[j] * this.OI.BS_BS_Overlap(basisFunction.exponents[i], polynom3D, basisFunction.R0, basisFunction2.exponents[j], polynom3D2, basisFunction2.R0);
            }
        }
        return d;
    }

    public double OverlapWith(BasisFunction basisFunction) throws Exception {
        Polynom3D polynom3D = this.Get_YLM_with_Additional_r_power(this, false);
        Polynom3D polynom3D2 = this.Get_YLM_with_Additional_r_power(basisFunction, false);
        return this._Term_By_Term_Product(this, polynom3D, basisFunction, polynom3D2);
    }

    public double EvaluateAtPoint(double[] dArray, double[] dArray2) {
        double[] dArray3 = (double[])dArray.clone();
        if (dArray2 != null) {
            for (int i = 0; i < 3; ++i) {
                int n = i;
                dArray3[n] = dArray3[n] - dArray2[i];
            }
        }
        double d = 0.0;
        for (int i = 0; i < 3; ++i) {
            d += dArray3[i] * dArray3[i];
        }
        double d2 = 0.0;
        for (int i = 0; i < this.exponents.length; ++i) {
            d2 += Math.exp(-this.exponents[i] * d) * this.coefs[i];
        }
        if (this.additional_r_power > 0) {
            d2 *= Math.pow(d, (double)this.additional_r_power / 2.0);
        }
        double d3 = 0.0;
        if (!this.IsSpherical) {
            System.out.println("BasisFunction.EvaluateAtPoint still can not be used with cartesian functions!");
            return 0.0;
        }
        if (this.Quick_YLM == null) {
            System.out.println("BasisFunction.EvaluateAtPoint can not be used without setting Quick_YLM");
            return 0.0;
        }
        d3 = this.Quick_YLM[this.L][this.L + this.m].EvaluateAtPoint(dArray3);
        return d2 * d3;
    }

    public void ScaleCoefsBy(double d) {
        int n = 0;
        while (n < this.coefs.length) {
            int n2 = n++;
            this.coefs[n2] = this.coefs[n2] * d;
        }
    }

    public void Print() {
        System.out.printf(" %c %4d 1.00%n", Character.valueOf("spdfgh".charAt(this.L)), this.coefs.length);
        if (this.additional_r_power > 0) {
            System.out.println(" and multiply radial part by  r^" + this.additional_r_power);
        }
        for (int i = 0; i < this.coefs.length; ++i) {
            System.out.printf("%20.10f %20.10f %n", this.exponents[i], this.coefs[i]);
        }
    }

    public void removeSmallContractionCoefs() {
        int n = 0;
        for (int i = 0; i < this.coefs.length; ++i) {
            if (!(Math.abs(this.coefs[i]) > 1.0E-15)) continue;
            ++n;
        }
        if (n == this.coefs.length) {
            return;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        for (int i = 0; i < this.coefs.length; ++i) {
            if (!(Math.abs(this.coefs[i]) > 1.0E-15)) continue;
            dArray[n2] = this.exponents[i];
            dArray2[n2] = this.coefs[i];
            ++n2;
        }
        this.exponents = dArray;
        this.coefs = dArray2;
    }
}

