/*
 * Decompiled with CFR 0.152.
 */
package MatrixHelper;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import Jama.SingularValueDecomposition;
import ProgramOptions.WarningManager;
import java.io.PrintStream;

public class EigenEngine {
    public static PrintStream out = System.out;
    public boolean glbPrint = false;
    public static final double machiene_eps = 1.0E-15;
    static boolean EVD_DBG = false;

    public static Matrix TransformSymmetricMatrixToNewBasis(Matrix matrix, Matrix matrix2) {
        double[] dArray;
        int n;
        double[][] dArray2 = matrix.getArray();
        int n2 = dArray2.length;
        double[][] dArray3 = matrix2.getArray();
        int n3 = dArray3.length;
        double[] dArray4 = new double[n2];
        double[][] dArray5 = new double[n3][n3];
        for (n = 0; n < n3; ++n) {
            int n4;
            dArray = dArray3[n];
            for (int i = 0; i < n2; ++i) {
                dArray4[i] = 0.0;
                for (n4 = 0; n4 < i; ++n4) {
                    int n5 = i;
                    dArray4[n5] = dArray4[n5] + dArray[n4] * dArray2[n4][i];
                }
                int n6 = i;
                dArray4[n6] = dArray4[n6] + dArray[i] * dArray2[i][i] / 2.0;
            }
            double[] dArray6 = dArray5[n];
            for (n4 = 0; n4 < n3; ++n4) {
                double[] dArray7 = dArray3[n4];
                for (int i = 0; i < n2; ++i) {
                    int n7 = n4;
                    dArray6[n7] = dArray6[n7] + dArray4[i] * dArray7[i];
                }
            }
        }
        n = 0;
        while (n < n3) {
            dArray = dArray5[n];
            for (int i = 0; i < n; ++i) {
                int n8 = i;
                dArray[n8] = dArray[n8] + dArray5[i][n];
            }
            int n9 = n++;
            dArray[n9] = dArray[n9] * 2.0;
        }
        for (n = 0; n < n3; ++n) {
            dArray = dArray5[n];
            for (int i = 0; i < n; ++i) {
                dArray5[i][n] = dArray[i];
            }
        }
        return new Matrix(dArray5);
    }

    public Matrix TransformMatrixToNewBasis(Matrix matrix, Matrix matrix2, boolean bl) {
        if (matrix.getArray().length == 0) {
            return new Matrix(0, 0);
        }
        boolean bl2 = !bl;
        Matrix matrix3 = bl2 ? matrix2.times(matrix).times(matrix2.transpose()) : EigenEngine.TransformSymmetricMatrixToNewBasis(matrix, matrix2);
        return matrix3;
    }

    public static void Matrix_Symmetrize_Check(Matrix matrix, String string) {
        for (int i = 0; i < matrix.getArray().length; ++i) {
            for (int j = i; j < matrix.getArray().length; ++j) {
                if (Math.abs(matrix.get(i, j) - matrix.get(j, i)) > 1.0E-15) {
                    WarningManager.warning_printf("WARNING: non-symmetric matrix found in %s ((%d,%d) = %.20E, (%d,%d) = %.20E), diff = %.5E%n", string, i + 1, j + 1, matrix.get(i, j), j + 1, i + 1, matrix.get(j, i), matrix.get(i, j) - matrix.get(j, i));
                }
                double d = (matrix.get(i, j) + matrix.get(j, i)) / 2.0;
                matrix.set(j, i, d);
                matrix.set(i, j, d);
            }
        }
    }

    public static Matrix Matrix_SQRT(Matrix matrix, boolean bl) {
        int n;
        EigenEngine.Matrix_Symmetrize_Check(matrix, "Matrix_SQRT");
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
        Matrix matrix2 = eigenvalueDecomposition.getD();
        int n2 = matrix.getRowDimension();
        double[] dArray = new double[n2];
        if (bl) {
            for (n = 0; n < n2; ++n) {
                dArray[n] = 1.0 / Math.sqrt(matrix2.get(n, n));
            }
        } else {
            for (n = 0; n < n2; ++n) {
                dArray[n] = Math.sqrt(matrix2.get(n, n));
            }
        }
        double[][] dArray2 = eigenvalueDecomposition.getV().getArray();
        Matrix matrix3 = new Matrix(n2, n2, 0.0);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = 0.0;
                for (int k = 0; k < n2; ++k) {
                    d += dArray2[i][k] * dArray[k] * dArray2[j][k];
                }
                matrix3.set(i, j, d);
            }
        }
        return matrix3;
    }

    public Matrix Matrix_minus05(Matrix matrix) {
        if (matrix.getArray().length == 0) {
            return new Matrix(0, 0);
        }
        EigenEngine.Matrix_Symmetrize_Check(matrix, "Matrix_minus05");
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
        Matrix matrix2 = eigenvalueDecomposition.getD();
        return EigenEngine.Matrix_SQRT(matrix, true);
    }

    public Matrix[] Generalized_EVD_SymmMatr(Matrix matrix, Matrix matrix2) {
        Matrix[] matrixArray = new Matrix[2];
        Matrix matrix3 = EigenEngine.Matrix_SQRT(matrix2, false);
        Matrix matrix4 = matrix3.inverse();
        Matrix matrix5 = this.TransformMatrixToNewBasis(matrix, matrix4, true);
        EigenvalueDecomposition eigenvalueDecomposition = matrix5.eig();
        matrixArray[0] = eigenvalueDecomposition.getD();
        if (EVD_DBG) {
            out.println("EigenVALUES: ");
            matrixArray[0].print(13, 7);
            out.println("Trace = " + matrixArray[0].trace());
        }
        matrixArray[1] = matrix4.times(eigenvalueDecomposition.getV());
        if (EVD_DBG) {
            out.println("EigenVECTORS: ");
            matrixArray[1].print(13, 7);
        }
        if (this.glbPrint) {
            matrixArray[1].print(13, 7);
            matrixArray[1].transpose().times(matrix2).times(matrixArray[1]).print(13, 7);
            matrix2.print(13, 7);
        }
        return matrixArray;
    }

    public static Matrix[] SVD(Matrix matrix, double[][] dArray) {
        SingularValueDecomposition singularValueDecomposition;
        boolean bl = false;
        if (matrix.getRowDimension() >= matrix.getColumnDimension()) {
            singularValueDecomposition = new SingularValueDecomposition(matrix);
        } else {
            singularValueDecomposition = new SingularValueDecomposition(matrix.transpose());
            bl = true;
        }
        int n = singularValueDecomposition.getSingularValues().length;
        Matrix matrix2 = singularValueDecomposition.getS();
        if (dArray != null) {
            dArray[0] = new double[n];
            System.arraycopy(singularValueDecomposition.getSingularValues(), 0, dArray[0], 0, n);
        }
        if (!bl) {
            return new Matrix[]{singularValueDecomposition.getU(), matrix2, singularValueDecomposition.getV().transpose()};
        }
        return new Matrix[]{singularValueDecomposition.getV(), matrix2.transpose(), singularValueDecomposition.getU().transpose()};
    }

    public static Matrix symmetrOrth(Matrix matrix) {
        Matrix[] matrixArray = EigenEngine.SVD(matrix, null);
        return matrixArray[0].times(matrixArray[2]);
    }
}

