/*
 * Decompiled with CFR 0.152.
 */
package MatrixHelper;

import Jama.Matrix;

public class CS96_SimultDiag {
    private static void _2x2_rotate(Matrix matrix, int n, int n2, double d, double d2) {
        double[][] dArray = matrix.getArray();
        double d3 = d * d * dArray[n][n] + d2 * d2 * dArray[n2][n2] + d * d2 * (dArray[n][n2] + dArray[n2][n]);
        double d4 = d * d * dArray[n][n2] - d2 * d2 * dArray[n2][n] + d * d2 * (dArray[n2][n2] - dArray[n][n]);
        double d5 = d * d * dArray[n2][n2] + d2 * d2 * dArray[n][n] - d * d2 * (dArray[n][n2] + dArray[n2][n]);
        double d6 = d * d * dArray[n2][n] - d2 * d2 * dArray[n][n2] + d * d2 * (dArray[n2][n2] - dArray[n][n]);
        for (int i = 0; i < dArray[0].length; ++i) {
            if (i == n || i == n2) continue;
            double d7 = dArray[n][i];
            dArray[n][i] = d * d7 + d2 * dArray[n2][i];
            dArray[n2][i] = -d2 * d7 + d * dArray[n2][i];
            double d8 = dArray[i][n];
            dArray[i][n] = d * d8 + d2 * dArray[i][n2];
            dArray[i][n2] = -d2 * d8 + d * dArray[i][n2];
        }
        dArray[n][n] = d3;
        dArray[n2][n2] = d5;
        dArray[n][n2] = d4;
        dArray[n2][n] = d6;
    }

    private static Matrix iteration(Matrix[] matrixArray, int n, double[] dArray, Matrix matrix) {
        dArray[0] = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int n2;
                double d = 0.0;
                double d2 = 0.0;
                for (int k = 0; k < matrixArray.length; ++k) {
                    double d3 = matrixArray[k].get(i, i) - matrixArray[k].get(j, j);
                    double d4 = matrixArray[k].get(i, j) + matrixArray[k].get(j, i);
                    d += d3 * d3 - d4 * d4;
                    d2 += d3 * d4;
                }
                double d5 = Math.atan2(d2 *= 2.0, d) / 4.0;
                double d6 = Math.cos(d5);
                double d7 = Math.sin(d5);
                if (Math.abs(d7) > dArray[0]) {
                    dArray[0] = Math.abs(d7);
                }
                for (n2 = 0; n2 < matrixArray.length; ++n2) {
                    CS96_SimultDiag._2x2_rotate(matrixArray[n2], i, j, d6, d7);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    double d8 = matrix.get(i, n2);
                    matrix.set(i, n2, d6 * d8 + d7 * matrix.get(j, n2));
                    matrix.set(j, n2, -d7 * d8 + d6 * matrix.get(j, n2));
                }
            }
        }
        return matrix;
    }

    public static Matrix simult_diag(Matrix[] matrixArray, int[] nArray, Matrix matrix) {
        double d = 1.0E-7;
        int n = matrixArray[0].getRowDimension();
        Matrix matrix2 = matrix == null ? Matrix.identity(n, n) : matrix.transpose();
        double[] dArray = new double[]{0.0};
        int n2 = 0;
        do {
            CS96_SimultDiag.iteration(matrixArray, n, dArray, matrix2);
        } while (dArray[0] > d && (nArray == null || nArray[0] < 0 || ++n2 < nArray[0]));
        if (nArray != null) {
            nArray[0] = n2;
        }
        return matrix2.transpose();
    }
}

