require('script/moflib')
require('script/common')

--{{{ make_shop_item_explanation
function make_shop_item_explanation(item)
	local type = tonumber(item.type)
	if type == 1 or type == 2 or type == 3 then
		return make_weapon_explanation(item)
	elseif type == 4 or type == 5 then
		return make_armer_explanation(item)
	elseif type == 0 then
		return make_potion_explanation(item)
	end
end
--}}}
--{{{ make_weapon_explanation
function make_weapon_explanation(item)
	local text = '<layout w="300" h="24" xalign="left" yalign="center">' .. item.explanation .. '</layout><nl/>'
	text = text .. '<col name="blue">U</col><layout w="120" h="24" xalign="right" yalign="center">' .. item.offence 
		.. '<col name="green">(+' .. item.offence .. ')</col></layout>'
	text = text .. '@@@@<col name="blue">ђʗ</col><layout w="130" h="24" xalign="right" yalign="center">' .. item.penet 
		.. '%<col name="green">(+' .. item.penet .. '%)</col></layout>'
	return text
end
--}}}
--{{{ make_armer_explanation
function make_armer_explanation(item)
	local text = '<layout w="300" h="24" xalign="left" yalign="center">' .. item.explanation .. '</layout><nl/>'
	text = text .. '<col name="blue">h</col><layout w="120" h="24" xalign="right" yalign="center">' .. item.diffence 
		.. '<col name="green">(+' .. item.diffence .. ')</col></layout>'
	return text
end
--}}}
--{{{ make_potion_explanation
function make_potion_explanation(item)
	local text = '<layout w="300" h="24" xalign="left" yalign="center">' .. item.explanation .. '</layout><nl/>'
	text = text .. '<col name="blue">HP񕜗</col><layout w="150" h="24" xalign="right" yalign="center">' .. item.effect .. '</layout>'
	return text
end
--}}}
--{{{ make_relic_explanation
function make_relic_explanation(item)
	local text = '<layout w="300" h="24" xalign="left" yalign="center">' .. item.explanation .. '</layout><nl/>'
	return text
end
--}}}
