require("script/moflib");
require('script/common')

--{{{ forest_element
function forest_element(x, y, z, priority)
	sound('sound/element.wav')
	local b = Board:new('file.image/element.png', priority)
	b:set_tween('position3', {[0] = {x, y + 0.5, z}, [90] = {x, y, z}})
	b:set_tween('size3', {[0] = {0.2, 0.2, 0.2}})
	b:set_tween('texcoord', {[0] = {0, 1/8, 1/8, 2/8}})
	b:set_tween('color', {[0] = {1, 1, 1, 1}, [90] = {0, 1, 1, 1}})
	wait_frame(90)
	b:dispose()
	sound('sound/put_element.wav')
end
--}}}
--{{{ earth_element
function earth_element(x, y, z, priority)
	sound('sound/element.wav')
	local b = Board:new('file.image/element.png', priority)
	b:set_tween('position3', {[0] = {x, y + 0.5, z}, [90] = {x, y, z}})
	b:set_tween('size3', {[0] = {0.2, 0.2, 0.2}})
	b:set_tween('texcoord', {[0] = {0, 2/8, 1/8, 3/8}})
	b:set_tween('color', {[0] = {1, 1, 1, 1}, [90] = {0, 1, 1, 1}})
	wait_frame(90)
	b:dispose()
	sound('sound/put_element.wav')
end
--}}}
--{{{ water_element
function water_element(x, y, z, priority)
	sound('sound/element.wav')
	local b = Board:new('file.image/element.png', priority)
	b:set_tween('position3', {[0] = {x, y + 0.5, z}, [90] = {x, y, z}})
	b:set_tween('size3', {[0] = {0.2, 0.2, 0.2}})
	b:set_tween('texcoord', {[0] = {0, 3/8, 1/8, 4/8}})
	b:set_tween('color', {[0] = {1, 1, 1, 1}, [90] = {0, 1, 1, 1}})
	wait_frame(90)
	b:dispose()
	sound('sound/put_element.wav')
end
--}}}
--{{{ transition
function transition(span1, span2, priority)
	local size = load_game_data('system.client_region')[1]
	local filter = Picture:new('file.image/fill.png', priority)
	filter:set_tween('position2', {[0] = {0, 0}})
	filter:set_tween('size2', {[0] = {size.width, size.height}})
	filter:set_tween('color', {[0] = {0, 0, 0, 0}, [span1] = {1, 0, 0, 0},
		[span1 + 30] = {1, 0, 0, 0}, [span1 + 30 + span2] = {0, 0, 0, 0}})
	wait_frame( span1 + span2 + 30 )
	filter:dispose()

end
--}}}
