/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.mitonan.ipsfex;

import jp.gr.java_conf.mitonan.ipsfex.logging.Log;
import jp.gr.java_conf.mitonan.ipsfex.util.OffsetConvertUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

public class InputPositionStatusFieldEx {
    public static final String CATEGORY_NM = "InputPositionEx";
    private static final int CHAR_WIDTH = 25;
    private static final char CHAR_TAB = '\t';
    private static final char CHAR_SEP = ' ';
    private static final char CHAR_SEP_INPUT_POSITION = ':';
    private static final char CHAR_P = 'P';
    private static final char CHAR_PAREN_L = '(';
    private static final char CHAR_PAREN_R = ')';
    private static final char CHAR_SEP_OFFSET = '/';
    private static final char CHAR_O = 'O';
    private static final char CHAR_BRACKET_L = '[';
    private static final char CHAR_BRACKET_R = ']';
    private static final char CHAR_SEP_COORDINATES = ',';
    private static final char CHAR_C = 'C';
    private static final char CHAR_BRACE_L = '{';
    private static final char CHAR_BRACE_R = '}';
    private static Log LOG = Log.getLog();

    public void activateInputPositionExStatusField(ITextEditor textEditor) {
        IContributionItem inputPositionItem;
        if (textEditor == null) {
            return;
        }
        IStatusLineManager islm = this.getStatusLineManager(textEditor);
        IContributionItem item = islm.find(CATEGORY_NM);
        if (item == null) {
            item = new StatusLineContributionItem(CATEGORY_NM, true, 25);
        }
        if (textEditor instanceof ITextEditorExtension) {
            ITextEditorExtension textEditorExtension = (ITextEditorExtension)textEditor;
            if (item instanceof IStatusField) {
                textEditorExtension.setStatusField((IStatusField)item, CATEGORY_NM);
            }
        }
        if ((inputPositionItem = islm.find("InputPosition")) != null) {
            inputPositionItem.dispose();
            islm.remove("InputPosition");
        }
        islm.prependToGroup("MIDDLE_GROUP", item);
        islm.update(true);
        this.displayInputPositionEx(textEditor);
    }

    public void deactivateInputPositionExStatusField(ITextEditor textEditor) {
        if (textEditor == null) {
            return;
        }
        IStatusLineManager islm = this.getStatusLineManager(textEditor);
        IContributionItem item = islm.find(CATEGORY_NM);
        if (item != null) {
            item.dispose();
            islm.remove(item);
            islm.update(true);
        }
    }

    public void displayInputPositionEx(ITextEditor editor) {
        IContributionItem item;
        if (editor == null) {
            return;
        }
        IStatusLineManager statusLine = this.getStatusLineManager(editor);
        if (statusLine != null && (item = statusLine.find(CATEGORY_NM)) != null && item instanceof IStatusField) {
            IStatusField field = (IStatusField)item;
            field.setText(this.createStatusLineText(editor));
        }
    }

    private String createStatusLineText(ITextEditor textEditor) {
        StyledText styledText = (StyledText)textEditor.getAdapter(Control.class);
        int widgetOffset = styledText.getCaretOffset();
        int modelOffset = OffsetConvertUtil.widgetOffset2modelOffset(textEditor, widgetOffset);
        StringBuilder text = new StringBuilder();
        text.append(this.createInputPositionStr(textEditor, styledText, modelOffset));
        text.append(' ');
        text.append(this.createOffsetStr(widgetOffset, modelOffset));
        text.append(' ');
        text.append(this.createCoordinatesStr(styledText));
        return text.toString();
    }

    private String createInputPositionStr(ITextEditor textEditor, StyledText styledText, int modelOffset) {
        StringBuilder text = new StringBuilder();
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return text.toString();
        }
        try {
            int line = document.getLineOfOffset(modelOffset);
            int lineOffset = document.getLineOffset(line);
            int tabWidth = styledText.getTabs();
            int column = 0;
            int i = lineOffset;
            while (i < modelOffset) {
                column = '\t' == document.getChar(i) ? (column += tabWidth - (tabWidth == 0 ? 0 : column % tabWidth)) : ++column;
                ++i;
            }
            text.append('P');
            text.append('(');
            text.append(++line);
            text.append(':');
            text.append(++column);
            text.append(')');
        }
        catch (BadLocationException e) {
            LOG.error("createInputPositionStr() error occured.", e);
        }
        return text.toString();
    }

    private String createOffsetStr(int widgetOffset, int modelOffset) {
        StringBuilder text = new StringBuilder();
        text.append('O');
        text.append('[');
        text.append(widgetOffset);
        text.append('/');
        text.append(modelOffset);
        text.append(']');
        return text.toString();
    }

    private String createCoordinatesStr(StyledText styledText) {
        StringBuilder text = new StringBuilder();
        Point point = styledText.getCaret().getLocation();
        text.append('C');
        text.append('{');
        text.append(point.x);
        text.append(',');
        text.append(point.y);
        text.append('}');
        return text.toString();
    }

    private IStatusLineManager getStatusLineManager(ITextEditor editor) {
        return editor.getEditorSite().getActionBars().getStatusLineManager();
    }
}

