/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.mitonan.ipsfex;

import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.mitonan.ipsfex.InputPositionStatusFieldEx;
import jp.gr.java_conf.mitonan.ipsfex.listener.IPSFExCursorListener;
import jp.gr.java_conf.mitonan.ipsfex.listener.IPSFExExecutionListener;
import jp.gr.java_conf.mitonan.ipsfex.listener.IPSFExPartListener;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.BundleContext;

public class IPSFExPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "jp.gr.java_conf.mitonan.ipsfex";
    private static IPSFExPlugin plugin;
    private Map<IWorkbenchPart, IPSFExCursorListener> cursorListenerMap = new HashMap<IWorkbenchPart, IPSFExCursorListener>();
    private Map<IWorkbenchPart, IPSFExExecutionListener> executionListenerMap = new HashMap<IWorkbenchPart, IPSFExExecutionListener>();
    private IPSFExPartListener partListener;
    private InputPositionStatusFieldEx ipsfEx;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.init();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static IPSFExPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return IPSFExPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void earlyStartup() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IPSFExPlugin.this.enableIPSFEx();
                IPSFExPlugin.this.activateIPSFExStatusField(IPSFExPlugin.this.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart());
            }
        });
    }

    public void enableIPSFEx() {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            window.getPartService().addPartListener((IPartListener)this.partListener);
            this.enableIPSFEx(window.getPartService().getActivePart());
            ++n2;
        }
    }

    public void enableIPSFEx(IWorkbenchPart part) {
        if (part == null) {
            return;
        }
        if (part instanceof ITextEditor) {
            this.enableIPSFEx((ITextEditor)part);
        }
    }

    private void enableIPSFEx(ITextEditor textEditor) {
        if (!this.cursorListenerMap.containsKey(textEditor)) {
            IPSFExCursorListener cursorListener = new IPSFExCursorListener(textEditor);
            StyledText styledText = (StyledText)textEditor.getAdapter(Control.class);
            styledText.addKeyListener((KeyListener)cursorListener);
            styledText.addMouseListener((MouseListener)cursorListener);
            this.cursorListenerMap.put((IWorkbenchPart)textEditor, cursorListener);
        }
        if (!this.executionListenerMap.containsKey(textEditor)) {
            IPSFExExecutionListener executionListener = new IPSFExExecutionListener();
            ICommandService commandService = this.getCommandService();
            commandService.addExecutionListener((IExecutionListener)executionListener);
            this.executionListenerMap.put((IWorkbenchPart)textEditor, executionListener);
        }
    }

    public void activateIPSFExStatusField(IWorkbenchPart part) {
        if (part == null) {
            return;
        }
        if (part instanceof ITextEditor) {
            this.ipsfEx.activateInputPositionExStatusField((ITextEditor)part);
        }
    }

    public void disableIPSFEx() {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            window.getPartService().removePartListener((IPartListener)this.partListener);
            this.disableIPSFEx(window.getPartService().getActivePart());
            ++n2;
        }
    }

    public void disableIPSFEx(IWorkbenchPart part) {
        if (part == null) {
            return;
        }
        if (part instanceof ITextEditor) {
            this.disableIPSFEx((ITextEditor)part);
        }
    }

    private void disableIPSFEx(ITextEditor textEditor) {
        if (this.cursorListenerMap.containsKey(textEditor)) {
            IPSFExCursorListener cursorListener = this.cursorListenerMap.get(textEditor);
            StyledText styledText = (StyledText)textEditor.getAdapter(Control.class);
            styledText.removeKeyListener((KeyListener)cursorListener);
            styledText.removeMouseListener((MouseListener)cursorListener);
            this.cursorListenerMap.remove(textEditor);
        }
        if (this.executionListenerMap.containsKey(textEditor)) {
            IPSFExExecutionListener executionListener = this.executionListenerMap.get(textEditor);
            ICommandService commandService = this.getCommandService();
            commandService.removeExecutionListener((IExecutionListener)executionListener);
            this.executionListenerMap.remove(textEditor);
        }
        this.deactivateIPSFExStatusField((IWorkbenchPart)textEditor);
    }

    public void deactivateIPSFExStatusField(IWorkbenchPart part) {
        if (part == null) {
            return;
        }
        if (part instanceof ITextEditor) {
            this.ipsfEx.deactivateInputPositionExStatusField((ITextEditor)part);
        }
    }

    public void displayInputPositionEx() {
        IWorkbenchPart part = this.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
        if (part != null && part instanceof ITextEditor) {
            this.displayInputPositionEx((ITextEditor)part);
        }
    }

    public void displayInputPositionEx(ITextEditor editor) {
        if (editor == null) {
            return;
        }
        this.ipsfEx.displayInputPositionEx(editor);
    }

    private void init() {
        this.partListener = new IPSFExPartListener();
        this.ipsfEx = new InputPositionStatusFieldEx();
    }

    public ICommandService getCommandService() {
        return (ICommandService)this.getWorkbench().getAdapter(ICommandService.class);
    }
}

