/**
 * @fileOverview MbedM3ネームスペース、定数値を定義する。
 */

/**
 * MbedM3用の高レベルAPIのネームスペースである。LPC1769ネームスペースを継承して、MbedM3独自の拡張要素を追加する。
 * このネームスペースは、LPC1769ネームスペースの全てのクラス、関数、宣言を継承する。LPC1769.xxxは、MbedM3.xxxに置き換えることができる。
 * @namespace
 * <p>
 * 実装メモ
 * このネームスペースは、LPC1769を継承する。LPC1769の構築を完了させてから読み込むこと。
 * </p>
 *@example
 * var mcu=new MbedM3.Mcu(“192.168.0.39”);
 * var adpin=mcu.getPin(MbedM3.PINNAME.AIN0,"AD");//bind AIN0 with AD function
 * //This is same as the above fragment.
 * var mcu=new LPC1769.Mcu(“192.168.0.39”);
 * var adpin=mcu.getPin(LPC1769.P0[23],"AD");//bind AIN0 with AD function
 */
var MbedM3;

(function(){
	var isUndef=MiMicLib.isUndef;
	var DEV=LPC1769;
	//LPC1769を継承する。"構築済のLPC1769ネームスペース"をシャローコピーして、extensionをマージする方法で生成する。
	MbedM3=MiMicLib.cloneAssoc(DEV);

	if(!isUndef(MbedM3.PINNAME)){alert("invalid override[PINNAME]");}
	/**
	 * Mbedのピン名に対応するピン識別子である。
	 * 要素は、LPC1769のピン識別子を参照する。
	 * @name MbedM3#PINNAME
	 * @constant
	 * @field
	 * @example
	 * var mcu=new MbedM3.Mcu(“192.168.0.39”);
	 * var adpin=mcu.getPin(MbedM3.PINNAME.AIN0,"AD");//bind AIN0 with AD function
	 */
	MbedM3.PINNAME={
		//Left side
		SPI1MOSI:DEV.P0[9],
		SPI1MISO:DEV.P0[8],
		SPI1SCK :DEV.P0[7],
		GPIO    :DEV.P0[6],
		UART1TX :DEV.P0[0],I2C1SDA:DEV.P0[0],
		UART1RX :DEV.P0[1],I2C1SCL:DEV.P0[1],
		SPI2MODI:DEV.P0[18],
		SPI2MISO:DEV.P0[17],
		SPI2SCK :DEV.P0[15],UART2TX:DEV.P0[15],SPI2SCL :DEV.P0[15], //SPISCL->SPISCK?
		UART2RX :DEV.P0[16],
		AIN0:DEV.P0[23],
		AIN1:DEV.P0[24],
		AIN2:DEV.P0[25],
		AIN3:DEV.P0[26],AOUT:DEV.P0[26],
		AIN4:DEV.P0[30],
		AIN5:DEV.P0[31],
		//Right side
		USBDP:DEV.P0[29],
		USBDM:DEV.P0[30],
		CANRD:DEV.P0[4],
		CANTD:DEV.P0[5],
		UART3TX:DEV.P0[10],I2C2SDA:DEV.P0[10],
		UART3RX:DEV.P0[11],I2C2SCL:DEV.P0[10],
		PWMOUT0:DEV.P2[0],
		PWMOUT1:DEV.P2[1],
		PWMOUT2:DEV.P2[2],
		PWMOUT3:DEV.P2[3],
		PWMOUT4:DEV.P2[4],
		PWMOUT5:DEV.P2[5],
	};
	if(!isUndef(MbedM3.PIN)){alert("invalid override[PIN]");}
	/**
	 * Mbedのピン名に対応するピン識別子である。配列の番号は、Mbed付属のチートシートに一致する。
	 * 要素は、LPC1769のピン識別子を参照する。
	 * @name MbedM3#PIN
	 * @constant
	 * @field
	 * @example
	 * var mcu=new MbedM3.Mcu(“192.168.0.39”);
	 * var adpin=mcu.getPin(MbedM3.PINNAME.AIN0,"AD");//bind AIN0 with AD function
	 */
	MbedM3.PIN=[
		null,null,null,null,null,//0,1,2,3,4
		DEV.P0[9],//5
		DEV.P0[8],//6
		DEV.P0[7],//7
		DEV.P0[6],//8
		DEV.P0[0],//9
		DEV.P0[1],//10
		DEV.P0[18],//11
		DEV.P0[17],//12
		DEV.P0[15],//13
		DEV.P0[16],//14
		DEV.P0[23],//15
		DEV.P0[24],//16
		DEV.P0[25],//17
		DEV.P0[26],//18
		DEV.P1[30],//19
		DEV.P1[31],//20
		DEV.P2[5],//21
		DEV.P2[4],//22
		DEV.P2[3],//23
		DEV.P2[2],//24
		DEV.P2[1],//25
		DEV.P2[0],//26
		DEV.P0[11],//27
		DEV.P0[10],//28
		DEV.P0[5],//29
		DEV.P0[4]//30
	];
	if(!isUndef(MbedM3.LED)){alert("invalid override[LED]");}
	/**
	 * MbedのLEDに接続されたピン識別子である。
	 * 要素は、LPC1769のピン識別子を参照する。
	 * @name MbedM3#LED
	 * @constant
	 * @field
	 * @example
	 * var mcu=new MbedM3.Mcu(“192.168.0.39”);
	 * var pin=mcu.getPin(MbedM3.LED[0],"GPIO");//bind LEDPIN with gpio function
	 */
	MbedM3.LED=[
		DEV.P1[18],
		DEV.P1[20],
		DEV.P1[21],
		DEV.P1[23]
	]
}());