/**
 * @fileOverview LPCXpresso1769ネームスペース、定数値を定義する。
 */

/**
 * LPCXpresso1769用の高レベルAPIのネームスペースである。LPC1769ネームスペースを継承して、LPCXpresso1769独自の拡張要素を追加する。
 * このネームスペースは、LPC1769ネームスペースの全てのクラス、関数、宣言を継承する。
 * @namespace
 * <p>
 * 実装メモ
 * このネームスペースは、LPC1769を継承する。LPC1769の構築を完了させてから読み込むこと。
 * </p>
 *@example
 * var mcu=new LPCXpresso1769.Mcu(“192.168.0.39”);
 * var adpin=mcu.getPin(LPCXpresso1769.P0[23],"AD");//bind P0[23] with AD function
 * //This is same as the above fragment.
 * var mcu=new LPC1769.Mcu(“192.168.0.39”);
 * var adpin=mcu.getPin(LPC1769.P0[23],"AD");//bind P0[23] with AD function
 */
var LPCXpresso1769;

(function(){
	var DEV=LPC1769;
	var isUndef=MiMicLib.isUndef;
	//LPC1769を継承する。"構築済のLPC1769ネームスペース"をシャローコピーして、extensionをマージする方法で生成する。
	LPCXpresso1769=MiMicLib.cloneAssoc(DEV);
	if(!isUndef(LPCXpresso1769.LED)){alert("invalid override[LED]");}
	/**
	 * LPCXpresso1769のLEDに接続されたピン識別子である。
	 * 要素は、LPC1769のピン識別子を参照する。
	 * @name LPCXpresso1769#LED
	 * @constant
	 * @field
	 * @example
	 * var mcu=new LPCXpresso1769.Mcu(“192.168.0.39”);
	 * var pin=mcu.getPin(LPCXpresso1769.LED[0],"GPIO");//bind LEDPIN with gpio function
	 */
	LPCXpresso1769.LED=[
		DEV.P0[22]
	]
}());

