/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.UnMnemonicProperties;

/**
 * |󃆁[eBeB[łB
 * <p>
 * ̃NX̃\bh́AoCgR[hϊꂽNX
 * Ăяo₷悤ɁAstatic \bhō\Ă܂B
 * <p>
 * @author C/pHeR
 */
public class TranslationUtils {

	/** K[ */
	@SuppressWarnings("unused")
	private static final Logger log = Logger.getLogger(TranslationUtils.class);

	/**  */
	private static final IDictionary dictionary = DictionaryFactory.create();

	/** R{̒lێ}bv */
	private static final Map<String, String> comboMap =
		new HashMap<String, String>();

	/**
	 * CX^Xł܂B
	 */
	private TranslationUtils() {
	}

	/**
	 * w肳ꂽpꃊ\[X|󂵂܂B
	 * <p>
	 * @param enValue pꃊ\[X
	 * @param jointPoint WCgE|Cg
	 * @return |㕶B|łȂꍇ͈ƓB
	 */
	public static String translate(String enValue, JointPoint jointPoint) {

		if (enValue == null) return null;
		return dictionary.lookup(enValue, jointPoint);
	}

	/**
	 * w肳ꂽpꃊ\[X̔z|󂵂܂B
	 * <p>
	 * @param enValues pꃊ\[X̔z
	 * @param jointPoint WCgE|Cg
	 * @return |㕶B|łȂꍇ͈ƓB
	 */
	public static String[] translate(String[] enValues, JointPoint jointPoint) {

		if (enValues == null) return null;
		for (int i = 0; i < enValues.length; i++) {
			enValues[i] = translate(enValues[i], jointPoint);
		}
		return enValues;
	}

	/**
	 * w肳ꂽpꃊ\[XEIuWFNg|󂵂܂B
	 * <p>
	 * @param enValue pꃊ\[XEIuWFNg
	 * @param jointPoint WCgE|Cg
	 * @return |㕶B|łȂꍇ͈ƓB
	 */
	public static Object translate(Object enValue, JointPoint jointPoint) {

		if (enValue == null) {
			return null;
		} else if (enValue instanceof String) {
			return translate((String) enValue, jointPoint);
		} else if (enValue instanceof String[]) {
			return translate((String[]) enValue, jointPoint);
		} else if (enValue instanceof Object[]) {
			return translate((Object[]) enValue, jointPoint);
		}
		return enValue;
	}

	/**
	 * w肳ꂽpꃊ\[XEIuWFNg|󂵂܂B
	 * <p>
	 * @param enValue pꃊ\[XEIuWFNg
	 * @param jointPoint WCgE|Cg
	 * @return |㕶B|łȂꍇ͈ƓB
	 */
	public static Object[] translate(Object enValue[], JointPoint jointPoint) {

		if (enValue instanceof String[]) {
			return translate((String[]) enValue, jointPoint);
		}
		return enValue;
	}

	/**
	 * w肳ꂽpꃊ\[Xj[pɖ|󂵂܂B
	 * <p>
	 * @param enValue pꃊ\[X
	 * @param jointPoint WCgE|Cg
	 * @return |㕶B|łȂꍇ͈ƓB
	 */
	/*	XMLGfB^[̐݌v^úuq̒ǉvj[ŗvf󂳂邽ߔp~ 2007.06.23
		̃j[͊ɕʂ JointPoint Ŗ󂳂Ă邽ߑ֕sv
	*/
	public static String translateMenu(String enValue, JointPoint jointPoint) {

		if (enValue == null) return null;
		String[] splitsAccelerator = enValue.split("\t");
		String enMenuText = splitsAccelerator[0];

		if (!enMenuText.matches("\\p{ASCII}+")) {
			// {ꃁj[̐VKڐ擪 & tĂ܂̂
			enMenuText = enMenuText.replaceFirst("^&", "");
		}
		if (splitsAccelerator.length == 1) {
			return dictionary.lookup(enMenuText, jointPoint);
		} else {
			return dictionary.lookup(enMenuText, jointPoint) + "\t" + splitsAccelerator[1];
		}
	}

	/**
	 * w肳ꂽpꃊ\[XR{pɖ|󂵂܂B
	 * <p>
	 * @param enValue pꃊ\[X
	 * @param jointPoint WCgE|Cg
	 * @return |㕶B|łȂꍇ͈ƓB
	 */
	public static String translateCombo(String enValue, JointPoint jointPoint) {

		if (enValue == null) return null;
		String jaValue = dictionary.lookup(enValue, jointPoint);
		comboMap.put(jaValue, enValue);
		return jaValue;
	}

	/**
	 * w肳ꂽpꃊ\[XzR{pɖ|󂵂܂B
	 * <p>
	 * @param enValues pꃊ\[X
	 * @param jointPoint WCgE|Cg
	 * @return |㕶B|łȂꍇ͈ƓB
	 */
	public static String[] translateCombo(String[] enValues, JointPoint jointPoint) {

		if (enValues == null) return null;
		for (int i = 0; i < enValues.length; i++) {
			enValues[i] = translateCombo(enValues[i], jointPoint);
		}
		return enValues;
	}

	/**
	 * R{Ŏgpꂽ{ꃊ\[Xpɖ߂܂B
	 * <p>
	 * @param jaValue {ꃊ\[X
	 * @param jointPoint WCgE|Cg
	 * @return pꕶB߂Ȃꍇ͈ƓB
	 */
	public static String restoreCombo(String jaValue, JointPoint jointPoint) {

		if (jaValue == null) return null;
		String enValue = comboMap.get(jaValue);
		if (enValue == null) {
			return jaValue;
		}
		return enValue;
	}

	/**
	 * w肳ꂽpꃊ\[X|󂵂܂B
	 * 󔒂 1 ȏ܂܂ꍇ̂ݖ|󂳂܂B
	 * <p>
	 * @param enValue pꃊ\[X
	 * @param jointPoint WCgE|Cg
	 * @return |㕶B|łȂꍇ͈ƓB
	 */
	public static String translateSentence(String enValue, JointPoint jointPoint) {

		if (enValue == null) return null;
		if (enValue.contains(" ")) {
			return dictionary.lookup(enValue, jointPoint);
		}
		return enValue;
	}

	/**
	 * w肳ꂽ{pj[jbN܂ރ\[X|󂵂܂B
	 * Ɋ܂܂{pj[jbN͖|Oɏ܂B
	 * <p>
	 * @param enValue {pj[jbN܂܂ꂽ\[X
	 * @param jointPoint WCgE|Cg
	 * @return |㕶B|łȂꍇ͈ƓB
	 */
	public static String translateWithoutJaMnemonic(String enValue, JointPoint jointPoint) {

		if (enValue == null) return null;
		enValue = enValue.replaceFirst(
				"\\(\\&" + UnMnemonicProperties.MNEMONIC_CHARS + "\\)", "");
		return dictionary.lookup(enValue, jointPoint);
	}

	/**
	 * w肵lfobOEOƂďo͂܂B
	 * <p>
	 * @param value pꃊ\[XEIuWFNg
	 * @param jointPoint WCgE|Cg
	 */
	public static void debug(Object value, JointPoint jointPoint) {
		log.info("Translator#debug " +
				(value == null ? "" : value.getClass().getName()) +
				"[" + value + "] -> [" + translate(value, jointPoint) + "]");
	}

	/**
	 * w肵lfobOEOƂďo͂܂B
	 * <p>
	 * @param value pꃊ\[XEIuWFNg̔z
	 * @param jointPoint WCgE|Cg
	 */
	public static void debug(String[] value, JointPoint jointPoint) {
		log.info("Translator#debug " +
				(value == null
					? "null"
					: value.getClass().getName() +
						Arrays.asList(value) + " -> " +
						Arrays.asList(translate(value, jointPoint))));
	}

	/**
	 * ݂̃Xbh̃X^bNg[XOɏo͂܂B
	 * <p>
	 * @param value pꃊ\[XEIuWFNg
	 * @param jointPoint WCgE|Cg
	 */
	public static void printStackTrace(Object value, JointPoint jointPoint) {
		log.info("Translator#debug " +
				(value == null ? "" : value.getClass().getName()) +
				"[" + value + "] -> [" + translate(value, jointPoint) + "]",
				new Exception());
	}
}
