/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Map.Entry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/**
 * |p̐K\łB
 * <p>
 * @author C/pHeR
 */
public class RegexDictionary {
	
	/** K[ */
	private static final Logger log = Logger.getLogger(RegexDictionary.class);
	
	/** |󐳋K\vpeB[Et@C */
	private static final String PROP_FILE_NAME = "translation-regex.properties";
	
	/** ̃NX̃VOgECX^X */
	private static final RegexDictionary singleton = new RegexDictionary();
	
	/**
	 * K\IuWFNg擾܂B
	 * <p>
	 * @return |󐳋K\vpeB[EIuWFNg
	 */
	public static RegexDictionary getInstance() {
		return singleton;
	}
	
	/** |󐳋K\}bv */
	private final Map<Pattern, String> map = new HashMap<Pattern, String>();
	
	/**
	 * K\\z܂B
	 */
	@SuppressWarnings("unchecked")
	private RegexDictionary() {
		
		File file = FileSystem.getResourceFile(PROP_FILE_NAME);
		if (!file.exists()) {
			Exception e = new FileNotFoundException(file.getPath());
			log.fatal(e.toString(), e);
			throw new IllegalStateException(e);
		}
		
		Properties prop = FileSystem.loadProperties(file);
		for (Entry<Object, Object> entry : prop.entrySet()) {
			map.put(
				Pattern.compile((String) entry.getKey()),
				(String) entry.getValue());
		}
		log.info("|󐳋K\vpeB[h܂B" + map.size());
	}

	/**
	 * |󂵂܂B
	 * <p>
	 * @param pꕶ
	 * @return |{ꕶ
	 */
	public String lookup(String enValue) {
		
		for (Entry<Pattern, String> entry : map.entrySet()) {
			
			Pattern pattern = entry.getKey();
			Matcher matcher = pattern.matcher(
					Matcher.quoteReplacement(enValue));
			try {
				if (matcher.matches()) {
					String replacement = entry.getValue();
					return matcher.replaceFirst(replacement);
				}
			} catch (RuntimeException e) {
				log.error("K\|ŃG[܂B" + pattern, e);
				break;
			}
		}
		return null;
	}
}
