/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.advice;

import java.lang.reflect.Modifier;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * WCgE|CgłB
 * <p>
 * @author C/pHeR
 */
public class JointPoint {
	
	/** ҏW|Cg enum */
	public static enum EditPoint {
		/** Ăяo */
		CALL,
		/** s */
		EXECUTION
	}

	/** \bhEANZXCq enum */
	private static enum MethodModifire {
		/** pubN */
		PUBLIC,
		/** veNebh */
		PROTECTED,
		/** pbP[WEvCx[g */
		PACKAGE,
		/** vCx[g */
		PRIVATE
	}
	
	/** ҏW|Cg */
	private EditPoint editPoint;
	
	/** NX */
	private String className;
	
	/** \bh */
	private String methodName;
	
	/** \bh̃ANZXCqBftHg MethodModifire.PUBLICB */
	private MethodModifire modifier = MethodModifire.PUBLIC;

	/** \bhLqq */
	private String descriptor;
	
	/**
	 * WCgE|Cg\z܂B
	 */
	public JointPoint() {
	}
	
	/**
	 * WCgE|Cg\z܂B
	 * <p>
	 * @param editPoint ҏW|Cg
	 * @param className NX
	 * @param methodName \bh
	 * @param descriptor \bhLqq
	 * @param mod ANZXCq
	 */
	public JointPoint(
			EditPoint editPoint,
			String className,
			String methodName,
			String descriptor,
			int mod) {
		
		this.editPoint = editPoint;
		this.className = className;
		this.methodName = methodName;
		this.descriptor = descriptor;
		setModifier(mod);
	}
	
	/**
	 * ҏW|Cg擾܂B
	 * <p>
	 * @return ҏW|Cg
	 */
	public EditPoint getEditPoint() {
		return editPoint;
	}
	
	/**
	 * ҏW|CgZbg܂B
	 * <p>
	 * @param editPoint ҏW|Cg
	 */
	public void setEditPoint(EditPoint editPoint) {
		this.editPoint = editPoint;
	}
	
	/**
	 * ҏW|CgijZbg܂B
	 * <p>
	 * @param editPoint ҏW|Cgij
	 */
	public void setEditPoint(String editPoint) {
		try {
			this.editPoint = EditPoint.valueOf(editPoint.toUpperCase());
		} catch (RuntimeException e) {
			throw new IllegalArgumentException(
				editPoint + " is illegal editPoint. " +
				StringUtils.join(EditPoint.values(), " or "));
		}
	}
	
	/**
	 * NX擾܂B
	 * <p>
	 * @return NX
	 */
	public String getClassName() {
		return className;
	}
	
	/**
	 * NXZbg܂B
	 * <p>
	 * @param className NX
	 */
	public void setClassName(String className) {
		this.className = className;
	}
	
	/**
	 * \bh擾܂B
	 * <p>
	 * @return \bh
	 */
	public String getMethodName() {
		return methodName;
	}
	
	/**
	 * \bhZbg܂B
	 * RXgN^[̏ꍇ this ܂ super ̂ǂ炩łB
	 * <p>
	 * @param methodName \bh
	 */
	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}
	
	/**
	 * \bh̃ANZXCq擾܂B
	 * <p>
	 * @return \bh̃ANZXCq
	 */
	public MethodModifire getModifier() {
		return modifier;
	}

	/**
	 * \bh̃ANZXCqijZbg܂B
	 * <p>
	 * @param modifier \bh̃ANZXCqij
	 */
	public void setModifier(String modifier) {
		if (modifier == null) {
			this.modifier = MethodModifire.PUBLIC;
			return;
		}
		try {
			this.modifier = MethodModifire.valueOf(modifier.toUpperCase());
		} catch (RuntimeException e) {
			throw new IllegalArgumentException(
				modifier + " is illegal modifier. " +
				StringUtils.join(MethodModifire.values(), " or "));
		}
	}
	
	/**
	 * \bh̃ANZXCqiljZbg܂B
	 * <p>
	 * @param mod \bh̃ANZXCqilj
	 */
	public void setModifier(int mod) {
		if (Modifier.isPublic(mod)) {
			this.modifier = MethodModifire.PUBLIC;
		} else if (Modifier.isProtected(mod)) {
			this.modifier = MethodModifire.PROTECTED;
		} else if (Modifier.isPrivate(mod)) {
			this.modifier = MethodModifire.PRIVATE;
		} else {
			this.modifier = MethodModifire.PACKAGE;
		}
	}

	/**
	 * \bhLqq擾܂B
	 * <p>
	 * @return \bhLqq
	 */
	public String getDescriptor() {
		return descriptor;
	}

	/**
	 * \bhLqqZbg܂B
	 * <p>
	 * @param descriptor \bhLqq
	 */
	public void setDescriptor(String descriptor) {
		this.descriptor = descriptor;
	}

	/**
	 * nbVR[h擾܂B
	 */
	@Override
	public int hashCode() {
		return new HashCodeBuilder(-1398227719, -1807208065)
			.append(this.editPoint)
			.append(this.className)
			.append(this.methodName)
			.append(this.modifier)
			.append(this.descriptor)
			.toHashCode();
	}
	
	/**
	 * ̃IuWFNgƑ̃IuWFNgr܂B
	 */
	@Override
	public boolean equals(Object object) {
		if (!(object instanceof JointPoint)) {
			return false;
		}
		JointPoint rhs = (JointPoint) object;
		return new EqualsBuilder()
			.append(this.editPoint, rhs.editPoint)
			.append(this.className, rhs.className)
			.append(this.methodName, rhs.methodName)
			.append(this.modifier, rhs.modifier)
			.append(this.descriptor, rhs.descriptor)
			.isEquals();
	}

	/**
	 * ̃IuWFNg̕\擾܂B
	 */
	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("editPoint", this.editPoint.toString().toLowerCase())
			.append("className", this.className)
			.append("methodName", this.methodName)
			.append("modefier", this.modifier.toString().toLowerCase())
			.append("descriptor", this.descriptor)
			.toString();
	}
}
