/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.Arrays;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.CachedDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

import org.apache.commons.lang.ArrayUtils;

/**
 * Eclipse ÑoCgR[hϊsgXtH[}[łB
 * <p>
 * @author C/pHeR
 */
public class LauncherTransformer extends AbstractTransformer {

	/** K[ */
	private static final Logger log = Logger.getLogger(LauncherTransformer.class);
	
	/**
	 * NgXtH[}[\z܂B
	 */
	public LauncherTransformer() {
		launcherTransformer = this;
	}
	static LauncherTransformer launcherTransformer;
	
	/**
	 * oCgR[hϊs܂B
	 * <p>
	 * ̃\bh Eclipse ̃`[ƂȂNXɈȉ̏ǉ܂B
	 * <ul>
	 * <li>OF {@link #startTranslationTransformer(String[])} Ăяo
	 * <li>㏈F {@link #destroyTranslationTransformer()} Ăяo
	 * </ul>
	 */
	protected byte[] transform(
			ClassLoader loader,
			String className,
			ProtectionDomain protectionDomain,
			byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {
		
		// NNX̕ϊ
		// 3.2 ȑOF org.eclipse.core.launcher.Main
		// 3.3 ȍ~F org.eclipse.equinox.launcher.Main
		if (className.endsWith(".launcher.Main")) {
			
			log.info("Eclipse ̋NJn܂B");
			
			// Eclipse Main NXɊJnǉ
			CtClass ctClass = createCtClass(bytecode, protectionDomain);
			CtMethod run = ctClass.getMethod("run", "([Ljava/lang/String;)I");
			run.insertBefore("$1 = " + getClass().getName() + ".startTranslationTransformer($$);");
			
			// Eclipse Main NXɏIǉ
			run.insertAfter(getClass().getName() + ".destroyTranslationTransformer();", true);
			
			// XvbV摜̕ύXZbg
			if (!Agent.getInstance().getAgentOption().isDefaultSplash()) {
				
				CtMethod searchForSplash = ctClass.getMethod(
						"searchForSplash", "([Ljava/lang/String;)Ljava/lang/String;");
				searchForSplash.setBody(
						"return \"" + getSplashPath() + "\";");
			}
			return ctClass.toBytecode();
			
		} else if (className.equals("org.eclipse.ui.internal.Workbench")) {
			
			// ̃gXtH[}[G[WFg폜
			Agent.getInstance().getInstrumentation().removeTransformer(this);
			
			// NԂ̌vIǉ
			CtClass ctClass = createCtClass(bytecode, protectionDomain);
			CtMethod runStartupWithProgress =
				ctClass.getMethod("runStartupWithProgress", "(ILjava/lang/Runnable;)V");
			runStartupWithProgress.insertAfter(getClass().getName() + ".startTime();");
			return ctClass.toBytecode();
		}
		return null;
	}
	
	/**
	 * |gXtH[}[Jn܂B
	 * <p>
	 * @param args Eclipse NIvVz
	 * @return NIvVz
	 */
	public static String[] startTranslationTransformer(String... args) {
		
		String[] newArgs = args;
		
		// N -clean 擾
		Agent agent = Agent.getInstance();
		AgentOption agentOption = agent.getAgentOption();
		agentOption.setClean(Arrays.asList(args).contains("-clean"));
		
		// LbVꍇ͋I -claen w
		if (!agentOption.isClean()) {
			boolean isClean = false;
			if (!ExcludesClassCache.file.exists()) {
				isClean = true;
				log.info("AXyNgOLbV݂Ȃ߁A" +
					"I -clean [hŋN܂B");
			}
			if (!CachedDictionary.cacheFile.exists() && !agentOption.isNoCache()) {
				isClean = true;
				log.info("LbV݂Ȃ߁A" +
					"I -clean [hŋN܂B");
			}
			if (isClean) {
				newArgs = (String[]) ArrayUtils.add(args, "-clean");
				agentOption.setClean(true);
			}
		}
		log.info("-clean: " + agentOption.isClean());
		
		// |gXtH[}[Jn
		agent.getInstrumentation().addTransformer(new TranslationTransformer());
		
		return newArgs;
	}
	
	/**
	 * NԂv܂B
	 */
	public static void startTime() {
		
		long startTime = Long.valueOf(System.getProperty("eclipse.startTime"));
		double time = (System.currentTimeMillis() - startTime) / 1000d;
		log.info(String.format(
				"Eclipse ̋N܂B: %.3f b", time));
	}
	
	/**
	 * |gXtH[}[j܂B
	 */
	public static void destroyTranslationTransformer() {
		TranslationTransformer.destroy();
	}
	
	/**
	 * XvbV摜pX擾܂B
	 * @return XvbV摜pX
	 */
	private String getSplashPath() {
		
		String version = "";
		
		File pluginsFolder = FileSystem.resourceRoot.getParentFile().getParentFile();
		for (File folder : pluginsFolder.listFiles()) {
			String folderName = folder.getName();
			if (folderName.startsWith("org.eclipse.core.runtime_")) {
				version = folderName.replaceFirst(".*?_(\\d+\\.\\d+).*", "$1");
				break;
			}
		}
		String fileName = "splash" + version + ".bmp";
		
		File file = FileSystem.getResourceFile(fileName);
		if (!file.exists()) {
			fileName = "splash.bmp";
		}
		return FileSystem.getResourceFile(fileName).getAbsolutePath().replace('\\', '/');
	}
}
