/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.aspect.Agent;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;
import org.apache.commons.io.IOUtils;

public class NotFoundLog {
    private static final Logger log = Logger.getLogger(NotFoundLog.class);
    private static final File NOT_FOUND_LOG_FILE_NAME = new File(Agent.configurationPath, "translation-notfound.properties");
    private static final File EXCLUDE_LIST_FILE_NAME = FileSystem.getResourceFile("translation-notfound-exclud.list");
    private static NotFoundLog notFoundLog;
    private Set<String> excludSet;
    private Set<Pattern> excludPatternSet;
    private Set<String> loggedSet;
    private PrintStream out;

    static {
        if (Agent.getInstance().getAgentOption().isEnabledNotFoundLog()) {
            notFoundLog = new NotFoundLog();
            notFoundLog.init();
        } else {
            notFoundLog = new NotFoundLog(){

                public void println(String enValueNonMnemonic) {
                }
            };
        }
    }

    private NotFoundLog() {
    }

    public static NotFoundLog getInstance() {
        return notFoundLog;
    }

    private void init() {
        this.excludSet = new HashSet<String>();
        this.excludPatternSet = new HashSet<Pattern>();
        this.loggedSet = new HashSet<String>();
        BufferedReader in = null;
        try {
            try {
                String line;
                in = new BufferedReader(new FileReader(EXCLUDE_LIST_FILE_NAME));
                while ((line = in.readLine()) != null) {
                    String prefix;
                    if (line.startsWith("#")) continue;
                    String str = line.replaceAll("\\\\n", "\n");
                    if (str.startsWith(prefix = "%REGEX%")) {
                        Pattern pattern = Pattern.compile(str.replaceFirst(prefix, ""));
                        this.excludPatternSet.add(pattern);
                        continue;
                    }
                    this.excludSet.add(str);
                }
            }
            catch (IOException e) {
                String msg = "\u8a33\u7121\u3057\u30ed\u30b0\u51fa\u529b\u9664\u5916\u30ea\u30b9\u30c8\u3092\u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                log.fatal(msg, e);
                throw new RuntimeException(msg, e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        try {
            this.out = new PrintStream(new BufferedOutputStream(new FileOutputStream(NOT_FOUND_LOG_FILE_NAME)), true);
        }
        catch (IOException e) {
            String msg = "\u8a33\u7121\u3057\u30ed\u30b0\u30e9\u30a4\u30bf\u30fc\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            log.fatal(msg, e);
            throw new RuntimeException(msg, e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                PrintStream out = NotFoundLog.getInstance().out;
                IOUtils.closeQuietly((OutputStream)out);
            }
        });
    }

    public void println(String enValueNonMnemonic) {
        if (this.loggedSet.contains(enValueNonMnemonic)) {
            return;
        }
        if (this.excludSet.contains(enValueNonMnemonic)) {
            return;
        }
        for (Pattern pattern : this.excludPatternSet) {
            if (!pattern.matcher(enValueNonMnemonic).matches()) continue;
            return;
        }
        this.loggedSet.add(enValueNonMnemonic);
        String key = enValueNonMnemonic.replaceAll("[ :=#!\t\\\\]", "\\\\$0").replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n");
        String value = enValueNonMnemonic.replaceAll("\n", " ");
        if (key.matches("(?s).*\\p{Alpha}{2}.*")) {
            this.out.println(String.valueOf(key) + "=" + value);
        }
    }

    /* synthetic */ NotFoundLog(NotFoundLog notFoundLog) {
        this();
    }
}

