/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.logging;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.logging.LoggingCallableStatement;
import com.lavans.util.jdbc.logging.LoggingPreparedStatement;
import com.lavans.util.jdbc.logging.LoggingStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class LoggingConnection
implements Connection {
    protected Logger logger = null;
    private Connection con = null;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggingConnection(Connection con) {
        this.con = con;
    }

    public Statement createStatement() throws SQLException {
        LoggingStatement st = new LoggingStatement(this.con.createStatement());
        st.setLogger(this.logger);
        return st;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        LoggingStatement st = new LoggingStatement(this.con.createStatement(resultSetType, resultSetConcurrency));
        st.setLogger(this.logger);
        return st;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LoggingStatement st = new LoggingStatement(this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        st.setLogger(this.logger);
        return st;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        LoggingCallableStatement st = new LoggingCallableStatement(this.con.prepareCall(sql), sql);
        st.setLogger(this.logger);
        return st;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        LoggingCallableStatement st = new LoggingCallableStatement(this.con.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
        st.setLogger(this.logger);
        return st;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LoggingCallableStatement st = new LoggingCallableStatement(this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        st.setLogger(this.logger);
        return st;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        LoggingPreparedStatement st = new LoggingPreparedStatement(this.con.prepareStatement(sql), sql);
        st.setLogger(this.logger);
        return st;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        LoggingPreparedStatement st = new LoggingPreparedStatement(this.con.prepareStatement(sql, autoGeneratedKeys), sql);
        st.setLogger(this.logger);
        return st;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        LoggingPreparedStatement st = new LoggingPreparedStatement(this.con.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
        st.setLogger(this.logger);
        return st;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LoggingPreparedStatement st = new LoggingPreparedStatement(this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        st.setLogger(this.logger);
        return st;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        LoggingPreparedStatement st = new LoggingPreparedStatement(this.con.prepareStatement(sql, columnIndexes), sql);
        st.setLogger(this.logger);
        return st;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        LoggingPreparedStatement st = new LoggingPreparedStatement(this.con.prepareStatement(sql, columnNames), sql);
        st.setLogger(this.logger);
        return st;
    }

    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    public void close() throws SQLException {
        this.con.close();
    }

    public void commit() throws SQLException {
        this.con.commit();
    }

    public void rollback() throws SQLException {
        this.con.rollback();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    public void setHoldability(int holdability) throws SQLException {
        this.con.setHoldability(holdability);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.con.setTransactionIsolation(level);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.con.setAutoCommit(autoCommit);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.con.setReadOnly(readOnly);
    }

    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.con.setCatalog(catalog);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback(savepoint);
    }

    public Map getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.con.setTypeMap(map);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.con.nativeSQL(sql);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.con.setSavepoint(name);
    }
}

