/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.cluster;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.cluster.CalledMethod;
import com.lavans.util.jdbc.cluster.ClusterConnection;
import com.lavans.util.jdbc.cluster.ClusterResultSet;
import com.lavans.util.jdbc.cluster.ClusterStatementInterface;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ClusterStatement
implements Statement,
ClusterStatementInterface {
    protected static final String MSG_ERR_REUPDATE = "Statement\u306e\u518d\u751f\u6210\u306b\u5931\u6557\u3002";
    protected static final String MSG_WARN_SWITCH_DB = "\u969c\u5bb3\u304c\u51fa\u305f\u306e\u3067\u63a5\u7d9a\u5148\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002";
    private Statement st = null;
    private ClusterConnection con = null;
    private List methodList = null;
    private String sql = null;
    protected static Logger logger = Logger.getInstance();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ClusterStatement(ClusterConnection con, Statement st) {
        this.con = con;
        this.st = st;
        this.methodList = new ArrayList();
    }

    public void reupdateStatement(Statement st) throws SQLException {
        logger.enteringTool();
        try {
            this.st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.st = st;
        int i = 0;
        while (i < this.methodList.size()) {
            CalledMethod calledMethod = (CalledMethod)this.methodList.get(i);
            try {
                calledMethod.invoke(st);
            }
            catch (Exception e) {
                logger.err(e);
                throw new SQLException(MSG_ERR_REUPDATE);
            }
            ++i;
        }
        logger.exitingTool();
    }

    private Object clusterCall(String methodName, Object[] args, Class[] parameterTypes, boolean saveMethod) throws SQLException {
        logger.enteringTool();
        Object result = null;
        CalledMethod calledMethod = new CalledMethod(methodName, args, parameterTypes);
        logger.debugTool(calledMethod.toString());
        try {
            result = calledMethod.invoke(this.st);
        }
        catch (Exception e) {
            logger.err(MSG_WARN_SWITCH_DB + e.getCause().getMessage());
            this.con.notifyError(this);
            try {
                result = calledMethod.invoke(this.st);
            }
            catch (InvocationTargetException e2) {
                Throwable t = e2.getTargetException();
                if (t instanceof SQLException) {
                    throw (SQLException)t;
                }
                SQLException sqle = new SQLException();
                sqle.initCause(e2.getTargetException());
                throw sqle;
            }
            catch (Exception e2) {
                SQLException sqle = new SQLException();
                sqle.initCause(e2);
                throw sqle;
            }
        }
        if (saveMethod) {
            this.methodList.add(calledMethod);
        }
        logger.exitingTool();
        return result;
    }

    public ResultSet getAnotherResultSet() throws SQLException {
        logger.enteringTool();
        logger.debug("\u6b21\u306esql\u3092\u518d\u767a\u884c\u3057\u3066ResultSet\u3092\u518d\u751f\u6210\u3057\u307e\u3059\u3002\n" + this.sql);
        this.con.notifyError(this);
        ResultSet rs = this.st.executeQuery(this.sql);
        logger.exitingTool();
        return rs;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        logger.enteringTool();
        Object[] objectArray = new Object[]{sql};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        ResultSet rs = (ResultSet)this.clusterCall("executeQuery", objectArray, classArray, true);
        logger.exitingTool();
        return new ClusterResultSet(this, rs);
    }

    public int executeUpdate(String sql) throws SQLException {
        Object[] objectArray = new Object[]{sql};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Integer)this.clusterCall("executeUpdate", objectArray, classArray, true);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        Object[] objectArray = new Object[]{sql, new Integer(autoGeneratedKeys)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Integer.TYPE;
        return (Integer)this.clusterCall("executeUpdate", objectArray, classArray, true);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        Object[] objectArray = new Object[]{sql, columnIndexes};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        return (Integer)this.clusterCall("executeUpdate", objectArray, classArray, true);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        Object[] objectArray = new Object[]{sql, columnNames};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        return (Integer)this.clusterCall("executeUpdate", objectArray, classArray, true);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        Object[] objectArray = new Object[]{sql, new Integer(autoGeneratedKeys)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Integer.TYPE;
        return (Boolean)this.clusterCall("execute", objectArray, classArray, true);
    }

    public boolean execute(String sql) throws SQLException {
        Object[] objectArray = new Object[]{sql};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Boolean)this.clusterCall("execute", objectArray, classArray, true);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        Object[] objectArray = new Object[]{sql, columnIndexes};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        return (Boolean)this.clusterCall("execute", objectArray, classArray, true);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        Object[] objectArray = new Object[]{sql, columnNames};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        return (Boolean)this.clusterCall("execute", objectArray, classArray, true);
    }

    public int getFetchDirection() throws SQLException {
        return (Integer)this.clusterCall("getFetchDirection", null, null, false);
    }

    public int getFetchSize() throws SQLException {
        return (Integer)this.clusterCall("getFetchSize", null, null, false);
    }

    public int getMaxFieldSize() throws SQLException {
        return (Integer)this.clusterCall("getMaxFieldSize", null, null, false);
    }

    public int getMaxRows() throws SQLException {
        return (Integer)this.clusterCall("getMaxRows", null, null, false);
    }

    public int getQueryTimeout() throws SQLException {
        return (Integer)this.clusterCall("getQueryTimeout", null, null, false);
    }

    public int getResultSetConcurrency() throws SQLException {
        return (Integer)this.clusterCall("getResultSetConcurrency", null, null, false);
    }

    public int getResultSetHoldability() throws SQLException {
        return (Integer)this.clusterCall("getResultSetConcurrency", null, null, false);
    }

    public int getResultSetType() throws SQLException {
        return (Integer)this.clusterCall("getResultSetType", null, null, false);
    }

    public int getUpdateCount() throws SQLException {
        return (Integer)this.clusterCall("getUpdateCount", null, null, false);
    }

    public void cancel() throws SQLException {
        this.clusterCall("cancel", null, null, true);
    }

    public void clearBatch() throws SQLException {
        this.clusterCall("clearBatch", null, null, true);
        this.st.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.clusterCall("clearWarnings", null, null, true);
        this.st.clearWarnings();
    }

    public void close() throws SQLException {
        this.clusterCall("close", null, null, true);
        this.st.close();
        this.con.remove(this);
    }

    public boolean getMoreResults() throws SQLException {
        return (Boolean)this.clusterCall("getMoreResults", null, null, false);
    }

    public int[] executeBatch() throws SQLException {
        return (int[])this.clusterCall("executeBatch", null, null, true);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.clusterCall("setFetchDirection", new Object[]{new Integer(direction)}, new Class[]{Integer.TYPE}, true);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.clusterCall("setFetchSize", new Object[]{new Integer(rows)}, new Class[]{Integer.TYPE}, true);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.clusterCall("setMaxFieldSize", new Object[]{new Integer(max)}, new Class[]{Integer.TYPE}, true);
    }

    public void setMaxRows(int max) throws SQLException {
        this.clusterCall("setMaxRows", new Object[]{new Integer(max)}, new Class[]{Integer.TYPE}, true);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.clusterCall("setQueryTimeout", new Object[]{new Integer(seconds)}, new Class[]{Integer.TYPE}, true);
    }

    public boolean getMoreResults(int current) throws SQLException {
        return (Boolean)this.clusterCall("getMoreResults", new Object[]{new Integer(current)}, new Class[]{Integer.TYPE}, false);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.clusterCall("setFetchDirection", new Object[]{new Boolean(enable)}, new Class[]{Boolean.TYPE}, true);
    }

    public void addBatch(String sql) throws SQLException {
        Object[] objectArray = new Object[]{sql};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this.clusterCall("addBatch", objectArray, classArray, true);
    }

    public void setCursorName(String name) throws SQLException {
        Object[] objectArray = new Object[]{name};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this.clusterCall("setCursorName", objectArray, classArray, true);
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return (ResultSet)this.clusterCall("getGeneratedKeys", null, null, false);
    }

    public ResultSet getResultSet() throws SQLException {
        return (ResultSet)this.clusterCall("getResultSet", null, null, false);
    }

    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.clusterCall("getWarnings", null, null, false);
    }
}

