package jp.sourceforge.larch.example.chat
{
    import jp.sourceforge.larch.fms.so.AbstractSharedObject;

    import mx.collections.ArrayCollection;
    import mx.controls.Alert;

    /**
     * チャット用の共有オブジェクト
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class ChatSO extends AbstractSharedObject
    {
        /**
         * 共有オブジェクトを初期化します。
         */
        override protected function initProperties():void
        {
            _memberList = new ArrayCollection();
            _messageHistory = "";
            sync();
        }

        /** @private */
        private var _memberList:ArrayCollection;
        /** ログインメンバーリスト */
        [Bindable]
        public function get memberList():ArrayCollection
        {
            return _memberList;
        }
        /** @private */
        public function set memberList(value:ArrayCollection):void
        {
            if(_memberList != value)
            {
                _memberList = value;
                sync();
            }
        }

        /** @private */
        private var _messageHistory:String;
        /** 発言履歴 */
        [Bindable]
        public function get messageHistory():String
        {
            return _messageHistory;
        }
        /** @private */
        public function set messageHistory(value:String):void
        {
            if(_messageHistory != value)
            {
                _messageHistory = value;
                sync();
            }
        }

        /**
         * すべてのクライアントのalertメソッドを呼び出します。
         * @param publisher 通知者
         * @param message メッセージ
         */
        public function callAlert(publisher:String, message:String):void
        {
            call("alert", publisher, message);
        }

        /**
         * アラートを表示します。
         * @param publisher 通知者
         * @param message メッセージ
         */
        public function alert(publisher:String, message:String):void
        {
            Alert.show(message, publisher + "さんからの通知です");
        }
    }
}