/*
 * Decompiled with CFR 0.152.
 */
package junkutil.crypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5 {
    public static final String MD2 = "MD2";
    public static final String MD5 = "MD5";
    public static final String SHA = "SHA";
    public static final String SHA_1 = "SHA-1";
    public static final String SHA_256 = "SHA-256";
    public static final String SHA_384 = "SHA-384";
    public static final String SHA_512 = "SHA-512";
    private String algorithm = "MD5";

    public MD5() {
    }

    public MD5(String algorithm) {
        this.algorithm = algorithm;
    }

    public String crypt(String str) throws NoSuchAlgorithmException {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("str is null.");
        }
        return this.crypt(str.getBytes());
    }

    public String crypt(String str, String encoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("str is null.");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null.");
        }
        return this.crypt(str.getBytes(encoding));
    }

    public String crypt(byte[] byteArray) throws NoSuchAlgorithmException {
        if (byteArray == null || byteArray.length == 0) {
            throw new IllegalArgumentException("bytes is null");
        }
        MessageDigest digest = MessageDigest.getInstance(this.algorithm);
        byte[] hash = digest.digest(byteArray);
        return junkutil.crypt.MD5.asHex(hash);
    }

    public String crypt(InputStream in, int buffSize) throws NoSuchAlgorithmException, IOException {
        if (in == null || in.available() == 0) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        MessageDigest digest = MessageDigest.getInstance(this.algorithm);
        try {
            byte[] buff = new byte[buffSize];
            int len = 0;
            while ((len = in.read(buff, 0, buff.length)) >= 0) {
                digest.update(buff, 0, len);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        byte[] hash = digest.digest();
        return junkutil.crypt.MD5.asHex(hash);
    }

    public static String asHex(byte[] byteArray) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            if ((0xFF & byteArray[i]) < 16) {
                hexString.append("0" + Integer.toHexString(0xFF & byteArray[i]));
                continue;
            }
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return new String(hexString);
    }

    public static byte[] asByteArray(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(i * 2, (i + 1) * 2), 16);
        }
        return bytes;
    }
}

