package org.maachang.dbm.engine ;

import java.util.Enumeration;
import java.util.NoSuchElementException;

/**
 * 次情報管理用.
 * 
 * @version 2008/01/16
 * @author masahito suzuki
 * @since MaachangDBM 1.00
 */
class MDbmEnumeration implements Enumeration<byte[]> {
    
    /**
     * DBM-Engine.
     */
    private MDbmEngine engine = null ;
    
    /**
     * キー管理用.
     */
    private NextKey next = null ;
    
    /**
     * コンストラクタ.
     */
    private MDbmEnumeration() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を設定してオブジェクトを生成します.
     * <BR>
     * @param engine DBM-Engineを設定します.
     */
    protected MDbmEnumeration( MDbmEngine engine ) {
        this.engine = engine ;
    }
    
    /**
     * Tests if this enumeration contains more elements.
     *
     * @return  <code>true</code> if and only if this enumeration object
     *           contains at least one more element to provide;
     *          <code>false</code> otherwise.
     */
    public boolean hasMoreElements() {
        boolean ret = false ;
        try {
            ret = ( this.engine.next( next ) == null ) ? false : true ;
        } catch( Exception e ) {
            ret = false ;
        }
        return ret ;
    }
    
    /**
     * Returns the next element of this enumeration if this enumeration
     * object has at least one more element to provide.
     *
     * @return     the next element of this enumeration.
     * @exception  NoSuchElementException  if no more elements exist.
     */
    public byte[] nextElement() {
        byte[] ret = null ;
        try {
            next = this.engine.next( next ) ;
            if( next != null ) {
                ret = next.getKey() ;
            }
        } catch( Exception e ) {
            ret = null ;
        }
        return ret ;
    }
}
