package org.maachang.dbm ;

import java.util.Enumeration;

import org.maachang.dbm.engine.MDbmEngine;

/**
 * MaachangDbm.
 * <BR>
 * MaachangDbmとは、javaで作成されたDBM[データベースマネージャ]で
 * Key,Value形式の内容を永続化させます.<BR>
 * データ管理最大数は、4250000件(425万件)です.<BR>
 * <BR>
 * MaachangDbmの利用方法について説明します.<BR>
 * MaachangDbmを利用するには、まず最初に、以下のように、MaachangDbmを初期化する
 * 必要があります.<BR>
 * <BR>
 * <div style="border:1px solid gray; padding:5px;">
 * <pre>
 * MaachangDbm dbm = new MaachangDbmImpl( "dbm" ) ;
 * 
 * </pre>
 * </div>
 * <BR>
 * 第一引数には、MaachangDbmの内容を保持するディレクトリ名を指定します.<BR>
 * これで、MaachangDbmが利用可能になります.<BR>
 * また、MaachangDbmを操作するには、<BR>
 * <BR>
 * <div style="border:1px solid gray; padding:5px;">
 * <pre>
 * MaachangDbm dbm = new MaachangDbmImpl( "dbm" ) ;
 * dbm.put( "hoge".getBytes( "UTF8" ),"hogehoge".getBytes( "UTF8" ) ;
 * byte[] b = dbm.get( "hoge".getBytes( "UTF8" ) ) ;
 * System.out.println( new String( b,"UTF8" ) ) ;
 * dbm.remove( "hoge".getBytes( "UTF8" ) ) ;
 * 
 * </pre>
 * </div>
 * <BR>
 * などで、利用できますが、この場合["hoge".getBytes( "UTF8" )]などと記述するのは、面倒です.<BR>
 * このため、MaachangDbm操作用オブジェクトとして、別途[MaachangDbmOp]が用意されています.<BR>
 * 利用方法としては、以下の通りです.<BR>
 * <BR>
 * <div style="border:1px solid gray; padding:5px;">
 * <pre>
 * MaachangDbm dbm = new MaachangDbmImpl( "dbm" ) ;
 * MaachangDbmOp op = new MaachangDbmOp( dbm ) ;
 * 
 * </pre>
 * </div>
 * <BR>
 * または、<BR>
 * <BR>
 * <div style="border:1px solid gray; padding:5px;">
 * <pre>
 * MaachangDbmOp op = new MaachangDbmOp( "dbm" ) ;
 * 
 * </pre>
 * </div>
 * <BR>
 * のようにMaachangDbmOpを初期化します.そして、MaachangDbmOpの利用方法は、下記の通りです.<BR>
 * <BR>
 * <div style="border:1px solid gray; padding:5px;">
 * <pre>
 * op.put( "hoge","moge" ) ;
 * String a = op.getString( "hoge" ) ;
 * op.remove( "hoge" ) ;
 * 
 * </pre>
 * </div>
 * 
 * @version 2008/01/18
 * @author masahito suzuki
 * @since MaachangDBM 1.00
 */
public interface MaachangDbm {
    
    /**
     * オブジェクトクローズ.
     */
    public void close() ;
    
    /**
     * 情報を設定.
     * <BR>
     * @param key 対象のキー情報を設定します.
     * @param value 対象の情報を設定します.
     * @exception Exception 例外.
     */
    public void put( byte[] key,byte[] value ) throws Exception ;
    
    /**
     * 情報を削除.
     * <BR>
     * @param key 対象のキー情報を設定します.
     * @exception Exception 例外.
     */
    public void remove( byte[] key ) throws Exception ;
    
    /**
     * 情報を取得.
     * <BR>
     * @param key 対象のキー情報を設定します.
     * @return byte[] 対象の情報が返されます.
     * @exception Exception 例外.
     */
    public byte[] get( byte[] key ) throws Exception ;
    
    /**
     * キー内容を列挙.
     * <BR><BR>
     * @return  Enumeration<byte[]> 列挙オブジェクトが返されます.
     */
    public Enumeration<byte[]> elements() ;
    
    /**
     * 格納情報数を取得.
     * <BR>
     * @return int 格納情報数が返されます.<BR>
     *             [-1]が返された場合、オブジェクトは既に破棄されています.
     */
    public int size() ;
    
    /**
     * MaachangDbm展開ディレクトリを取得.
     * <BR>
     * @return String MaachangDbm展開ディレクトリ名が返されます.
     */
    public String getDirectory() ;
    
    /**
     * MaachangDbmエンジンを取得.
     * <BR>
     * @return MDbmEngine MaachangDbmエンジンが返されます.
     */
    public MDbmEngine getEngine() ;
    
    /**
     * このオブジェクトが有効かチェック.
     * <BR>
     * @return boolean [true]の場合、有効です.
     */
    public boolean isUse() ;
}
